/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.log.Log;

public class Handler {
    public static final int STATE_NEW = 0;
    public static final int STATE_ADDED = 1;
    public static final int STATE_DISABLED = 4;
    protected BaseInterceptor module;
    protected ContextManager contextM;
    protected String name;
    protected int state = 0;
    protected Exception errorException = null;
    protected int debug = 0;
    protected Log logger = null;
    protected Handler next;
    protected Handler prev;
    private Object[] notes = new Object[32];

    public void setModule(BaseInterceptor module) {
        this.module = module;
        this.contextM = module.getContextManager();
        this.debug = module.getDebug();
        this.logger = module.getLog();
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
        if (this.logger == null) {
            this.logger = cm.getLog();
        }
    }

    public BaseInterceptor getModule() {
        return this.module;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        this.state = i;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String handlerName) {
        this.name = handlerName;
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public void init() throws TomcatException {
    }

    public void destroy() throws TomcatException {
    }

    public void service(Request req, Response res) throws Exception {
        Exception serviceException;
        BaseInterceptor[] reqI;
        block5: {
            reqI = req.getContainer().getInterceptors(5);
            for (int i = 0; i < reqI.length; ++i) {
                reqI[i].preService(req, res);
            }
            serviceException = null;
            try {
                this.invoke(req, res);
            }
            catch (Exception ex) {
                serviceException = ex;
                if (ex == res.getErrorException()) break block5;
                res.setErrorException(ex);
                res.setErrorURI(null);
            }
        }
        reqI = req.getContainer().getInterceptors(11);
        for (int i = 0; i < reqI.length; ++i) {
            reqI[i].postService(req, res);
        }
        if (serviceException != null) {
            this.handleServiceError(req, res, serviceException);
        }
    }

    public void setNext(Handler next) {
        this.next = next;
    }

    public Handler getNext() {
        return this.next;
    }

    public Handler getPrevious() {
        return this.prev;
    }

    public void setPrevious(Handler prev) {
        this.prev = prev;
    }

    protected void handleServiceError(Request req, Response res, Throwable t) throws Exception {
        this.contextM.handleError(req, res, t);
    }

    public void reload() {
    }

    protected void doService(Request req, Response res) throws Exception {
    }

    protected void invoke(Request req, Response res) throws Exception {
        this.doService(req, res);
    }

    public String toString() {
        return this.name;
    }

    public void setDebug(int d) {
        this.debug = d;
    }

    protected void log(String s) {
        if (this.logger == null) {
            this.contextM.log(s);
        } else {
            this.logger.log(s);
        }
    }

    protected void log(String s, Throwable t) {
        if (this.logger == null) {
            this.contextM.log(s, t);
        } else {
            this.logger.log(s, t);
        }
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public Object getNote(String name) throws TomcatException {
        int id = this.contextM.getNoteId(3, name);
        return this.getNote(id);
    }

    public void setNote(String name, Object value) throws TomcatException {
        int id = this.contextM.getNoteId(3, name);
        this.setNote(id, value);
    }
}

