/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.hooks.Hooks;

public class Container
implements Cloneable {
    private ContextManager contextM;
    private Context context;
    public static final int UNKNOWN_MAP = 0;
    public static final int PATH_MAP = 1;
    public static final int PREFIX_MAP = 2;
    public static final int EXTENSION_MAP = 3;
    public static final int DEFAULT_MAP = 4;
    private int mapType = 0;
    private String transport;
    private String path;
    private String proto;
    private String[] vhosts;
    private Hashtable attributes = new Hashtable();
    private Handler handler;
    private String handlerName;
    private String[] roles = null;
    private String[] methods = null;
    private boolean special = false;
    Object[] notes = new Object[32];
    public static final int H_postReadRequest = 0;
    public static final int H_requestMap = 1;
    public static final int H_contextMap = 2;
    public static final int H_authenticate = 3;
    public static final int H_authorize = 4;
    public static final int H_preService = 5;
    public static final int H_beforeBody = 6;
    public static final int H_findSession = 7;
    public static final int H_sessionState = 8;
    public static final int H_beforeCommit = 9;
    public static final int H_afterBody = 10;
    public static final int H_postService = 11;
    public static final int H_postRequest = 12;
    public static final int H_handleError = 13;
    public static final int H_getInfo = 14;
    public static final int H_setInfo = 15;
    public static final int H_engineInit = 16;
    public static final int H_preInitCheck = 17;
    public static final int H_postInitCheck = 18;
    public static final int H_copyContext = 19;
    public static final int H_COUNT = 20;
    private Hooks hooks = new Hooks();
    private BaseInterceptor[][] hooksCache = null;
    private BaseInterceptor[] allHooksCache = null;
    private static final int dL = 0;

    public Container() {
        this.initHooks();
    }

    public ContextManager getContextManager() {
        if (this.contextM == null && this.context == null) {
            throw new RuntimeException("Assert: container.contextM==null");
        }
        if (this.contextM == null) {
            this.contextM = this.context.getContextManager();
        }
        return this.contextM;
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public Context getContext() {
        return this.context;
    }

    public void setSpecial(boolean b) {
        this.special = b;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int getMapType() {
        if (this.mapType != 0) {
            return this.mapType;
        }
        this.mapType = this.path == null || this.path.equals("") || this.path.equals("/") ? 4 : (this.path.startsWith("/") && this.path.endsWith("/*") ? 2 : (this.path.startsWith("*.") ? 3 : 1));
        return this.mapType;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : path.trim();
    }

    public String getPath() {
        return this.path;
    }

    public void setProtocol(String protocol) {
        this.proto = protocol;
    }

    public String getProtocol() {
        return this.proto;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getTransport() {
        return this.transport;
    }

    public String[] getVhosts() {
        return this.vhosts;
    }

    public void setVhosts(String[] vhosts) {
        this.vhosts = vhosts;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public void setMethods(String[] m) {
        this.methods = m;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler h) {
        this.handler = h;
    }

    public void setHandlerName(String hn) {
        this.handlerName = hn;
    }

    public String getHandlerName() {
        if (this.handlerName != null) {
            return this.handlerName;
        }
        if (this.handler != null) {
            return this.handler.getName();
        }
        return null;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Ct (");
        sb.append(this.path).append(" ");
        if (this.handler != null) {
            sb.append(this.handler.toString());
        }
        if (this.roles != null) {
            sb.append(" Roles: ");
            for (int i = 0; i < this.roles.length; ++i) {
                sb.append(" ").append(this.roles[i]);
            }
        }
        sb.append(" )");
        return sb.toString();
    }

    public Container getClone() {
        try {
            return (Container)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return this;
        }
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public Object getNote(String name) throws TomcatException {
        int id = this.getContextManager().getNoteId(1, name);
        return this.getNote(id);
    }

    public void setNote(String name, Object value) throws TomcatException {
        int id = this.getContextManager().getNoteId(1, name);
        this.setNote(id, value);
    }

    private void initHooks() {
        this.hooks.registerHook("postReadRequest", 0);
        this.hooks.registerHook("requestMap", 1);
        this.hooks.registerHook("contextMap", 2);
        this.hooks.registerHook("authenticate", 3);
        this.hooks.registerHook("authorize", 4);
        this.hooks.registerHook("preService", 5);
        this.hooks.registerHook("beforeBody", 6);
        this.hooks.registerHook("findSession", 7);
        this.hooks.registerHook("sessionState", 8);
        this.hooks.registerHook("beforeCommit", 9);
        this.hooks.registerHook("afterBody", 10);
        this.hooks.registerHook("postService", 11);
        this.hooks.registerHook("postRequest", 12);
        this.hooks.registerHook("handleError", 13);
        this.hooks.registerHook("getInfo", 14);
        this.hooks.registerHook("setInfo", 15);
        this.hooks.registerHook("engineInit", 16);
        this.hooks.registerHook("preInitCheck", 17);
        this.hooks.registerHook("postInitCheck", 18);
        this.hooks.registerHook("copyContext", 19);
    }

    public Hooks getHooks() {
        return this.hooks;
    }

    public void addInterceptor(BaseInterceptor bi) {
        bi.setContext(this.getContext());
        int status = bi.registerHooks(this.hooks, this.contextM, this.context);
        if (status != 0) {
            this.hooks.addModule((Object)bi);
        }
        this.hooksCache = null;
        this.allHooksCache = null;
    }

    public void removeInterceptor(BaseInterceptor bi) {
        this.hooks.removeModule((Object)bi);
        this.hooksCache = null;
        this.allHooksCache = null;
    }

    public BaseInterceptor[] getInterceptors(int type) {
        if (this.hooksCache != null) {
            if (this.hooksCache[type] == null) {
                Container gContainer = this.getContextManager().getContainer();
                Hooks gHooks = gContainer.getHooks();
                this.hooksCache[type] = this != gContainer ? this.mergeHooks(gHooks.getModules(type), this.getHooks().getModules(type)) : this.mergeHooks(gHooks.getModules(type), null);
            }
            return this.hooksCache[type];
        }
        Container globalIntContainer = this.getContextManager().getContainer();
        Hooks globals = globalIntContainer.getHooks();
        this.hooksCache = new BaseInterceptor[20][];
        for (int i = 0; i < 20; ++i) {
            Object locals = null;
            this.hooksCache[i] = this != globalIntContainer ? this.mergeHooks(globals.getModules(i), this.getHooks().getModules(i)) : this.mergeHooks(globals.getModules(i), null);
        }
        return this.hooksCache[type];
    }

    public BaseInterceptor[] getInterceptors() {
        if (this.allHooksCache != null) {
            return this.allHooksCache;
        }
        Container globalIntContainer = this.getContextManager().getContainer();
        Hooks globals = globalIntContainer.getHooks();
        this.allHooksCache = this == globalIntContainer ? this.mergeHooks(globals.getModules(), null) : this.mergeHooks(globals.getModules(), this.getHooks().getModules());
        return this.allHooksCache;
    }

    private BaseInterceptor[] mergeHooks(Object[] globalM, Object[] localM) {
        BaseInterceptor[] hA = null;
        if (localM == null) {
            hA = new BaseInterceptor[globalM.length];
            for (int j = 0; j < globalM.length; ++j) {
                hA[j] = (BaseInterceptor)globalM[j];
            }
        } else {
            int j;
            hA = new BaseInterceptor[globalM.length + localM.length];
            int gsize = globalM.length;
            for (j = 0; j < globalM.length; ++j) {
                hA[j] = (BaseInterceptor)globalM[j];
            }
            for (j = 0; j < localM.length; ++j) {
                hA[gsize + j] = (BaseInterceptor)localM[j];
            }
        }
        return hA;
    }

    public void resetInterceptorCache(int id) {
        this.allHooksCache = null;
        this.hooksCache = null;
    }

    private void debug(String s) {
        System.out.println("Container: " + s);
    }
}

