/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.optional.jsp.JspC;
import org.apache.tools.ant.taskdefs.optional.jsp.JspMangler;
import org.apache.tools.ant.taskdefs.optional.jsp.JspNameMangler;
import org.apache.tools.ant.taskdefs.optional.jsp.compilers.DefaultJspCompilerAdapter;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class Tomcat3Precompiler
extends DefaultJspCompilerAdapter {
    public boolean execute() throws BuildException {
        this.getJspc().log("Using Tomcat 3 precompiler", 3);
        Vector vector = this.getJspc().getCompileList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CommandlineJava commandlineJava = this.setupJasperCommand();
            String string = (String)enumeration.nextElement();
            String string2 = this.getBase(string);
            String string3 = string2 + "_1";
            this.addArg(commandlineJava, "-c", string3);
            commandlineJava.createArgument().setValue(string);
            this.getJspc().log("Compiling file [" + string + "] to class [" + string3 + "]", 3);
            this.compile(commandlineJava);
        }
        return true;
    }

    private boolean compile(CommandlineJava commandlineJava) throws BuildException {
        try {
            boolean bl;
            Java java = (Java)this.getJspc().getProject().createTask("java");
            if (this.getJspc().getClasspath() != null) {
                java.setClasspath(this.getJspc().getClasspath());
            } else {
                java.setClasspath(Path.systemClasspath);
            }
            java.setClassname("org.apache.jasper.JspC");
            String[] stringArray = commandlineJava.getJavaCommand().getArguments();
            for (bl = false; bl < stringArray.length; bl += 1) {
                java.createArg().setValue(stringArray[bl]);
            }
            java.setFailonerror(this.getJspc().getFailonerror());
            java.setFork(true);
            java.execute();
            bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)((Object)exception);
            }
            throw new BuildException("Error running jsp compiler: ", (Throwable)exception, this.getJspc().getLocation());
        }
        finally {
            this.getJspc().deleteEmptyJavaFiles();
        }
    }

    private String getBase(String string) {
        int n;
        int n2 = string.lastIndexOf(File.separator);
        if (n2 == -1) {
            n2 = 0;
        }
        if ((n = string.lastIndexOf(46)) == -1) {
            n = string.length();
        }
        return string.substring(n2 + 1, n);
    }

    private CommandlineJava setupJasperCommand() {
        CommandlineJava commandlineJava = new CommandlineJava();
        JspC jspC = this.getJspc();
        this.addArg(commandlineJava, "-d", jspC.getDestdir());
        this.addArg(commandlineJava, "-p", jspC.getPackage());
        this.addArg(commandlineJava, "-v" + jspC.getVerbose());
        this.addArg(commandlineJava, "-uriroot", jspC.getUriroot());
        this.addArg(commandlineJava, "-ieplugin", jspC.getIeplugin());
        this.addArg(commandlineJava, "-die9");
        if (jspC.isMapped()) {
            this.addArg(commandlineJava, "-mapped");
        }
        if (jspC.getWebApp() != null) {
            File file = jspC.getWebApp().getDirectory();
            this.addArg(commandlineJava, "-webapp", file);
        }
        return commandlineJava;
    }

    public JspMangler createMangler() {
        return new TomcatJSPMangler();
    }

    private class TomcatJSPMangler
    implements JspMangler {
        private JspMangler mangler = new JspNameMangler();

        public String mapJspToJavaName(File file) {
            String string = this.mangler.mapJspToJavaName(file);
            int n = string.lastIndexOf(".java");
            if (n != -1) {
                string = string.substring(0, n) + "_1.java";
            }
            return string;
        }

        public String mapPath(String string) {
            return this.mangler.mapPath(string);
        }
    }
}

