/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class Tomcat3JSPVersionFile
extends Task {
    private File srcdir;
    private Path regexpClasspath;
    private RegexpMatcherFactory factory = new RegexpMatcherFactory();
    protected String DEFAULT_REGEXP_CLASS = "org.apache.tools.ant.util.regexp.JakartaRegexpMatcher";

    public void setSrcdir(String string) {
        this.srcdir = new File(string);
    }

    public void setRegexpClasspath(Path path) {
        if (this.regexpClasspath == null) {
            this.regexpClasspath = path;
        } else {
            this.regexpClasspath.append(path);
        }
    }

    public Path createRegexpClasspath() {
        if (this.regexpClasspath == null) {
            this.regexpClasspath = new Path(this.project);
        }
        return this.regexpClasspath.createPath();
    }

    public void setRegexpClasspathRef(Reference reference) {
        this.createRegexpClasspath().setRefid(reference);
    }

    public void execute() throws BuildException {
        if (this.srcdir == null) {
            throw new BuildException("srcdir attribute required", this.location);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setIncludes(new String[]{"**_?*.class"});
        directoryScanner.setBasedir(this.srcdir);
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            RegexpMatcher regexpMatcher = this.loadRegexpMatcher();
            regexpMatcher.setPattern("(.*)_(\\d*).class");
            if (!regexpMatcher.matches(stringArray[i])) continue;
            Vector vector = regexpMatcher.getGroups(stringArray[i]);
            String string = (String)vector.elementAt(1);
            String string2 = (String)vector.elementAt(2);
            int n2 = new Integer(string2);
            File file = new File(this.srcdir, string + ".ver");
            try {
                if (file.exists() && this.readVersionFile(file) == n2) continue;
                this.log("Creating verion file " + file.getAbsolutePath(), 3);
                ++n;
                this.writeVersionFile(file, n2);
                continue;
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        this.log("Created " + n + " version file" + (n != 1 ? "s" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readVersionFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n = fileInputStream.read();
            return n;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionFile(File file, int n) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(n);
        }
        finally {
            fileOutputStream.close();
        }
    }

    private RegexpMatcher loadRegexpMatcher() throws BuildException {
        try {
            RegexpMatcher regexpMatcher = this.factory.newRegexpMatcher();
            this.log("Loaded RegexpMatcher from factory", 4);
            return regexpMatcher;
        }
        catch (BuildException buildException) {
            try {
                this.log("Loading RegexpMatcher from " + this.regexpClasspath, 4);
                AntClassLoader antClassLoader = new AntClassLoader(this.getProject(), this.regexpClasspath);
                Class clazz = antClassLoader.findClass(this.DEFAULT_REGEXP_CLASS);
                return (RegexpMatcher)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new BuildException(throwable);
            }
        }
    }
}

