/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test.matchers;

import java.util.Hashtable;
import org.apache.tomcat.util.test.Header;
import org.apache.tomcat.util.test.Matcher;

public class SessionMatch
extends Matcher {
    String id;
    String cookieName = "JSESSIONID";
    String property;

    public void setCookieName(String n) {
        this.cookieName = n;
    }

    public void setId(String v) {
        this.id = v;
    }

    public void setProperty(String prop) {
        this.property = prop;
    }

    public String getTestDescription() {
        return "Session extract";
    }

    public void execute() {
        if (this.skipTest()) {
            return;
        }
        try {
            this.extractSession();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.result = false;
        }
    }

    private void extractSession() throws Exception {
        int begin;
        String temp;
        Hashtable headers = this.response.getHeaders();
        Header resH = (Header)headers.get("Set-Cookie");
        if (null != resH && null != (temp = resH.getValue()) && (begin = temp.indexOf("JSESSIONID")) >= 0) {
            if (null != this.property) {
                int end = temp.indexOf(";", begin);
                temp = end >= 0 ? temp.substring(begin, end) : temp.substring(begin);
                this.client.getProject().setUserProperty(this.property, temp);
            }
            this.result = true;
        }
    }
}

