/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test.matchers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tomcat.util.test.Matcher;

public class ResponseMatchFile
extends Matcher {
    String responseMatchFile;

    public void setFile(String s) {
        this.responseMatchFile = s;
    }

    public void setResponseMatchFile(String s) {
        this.responseMatchFile = s;
    }

    public String getTestDescription() {
        StringBuffer desc = new StringBuffer();
        boolean needAND = false;
        if (this.responseMatchFile != null) {
            if (needAND) {
                desc.append(" && ");
            }
            needAND = true;
            desc.append("( responseBody matches lines in '" + this.responseMatchFile + "') ");
        }
        desc.append(" == ").append(this.magnitude);
        return desc.toString();
    }

    public void execute() {
        if (this.skipTest()) {
            return;
        }
        try {
            this.result = this.checkResponse(this.magnitude);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.result = false;
        }
    }

    private boolean checkResponse(boolean testCondition) throws Exception {
        String responseLine = this.response.getResponseLine();
        Hashtable headers = this.response.getHeaders();
        boolean responseStatus = true;
        String responseBody = this.response.getResponseBody();
        if (this.responseMatchFile != null) {
            try {
                boolean desiredResult = true;
                FileReader fr = new FileReader(this.responseMatchFile);
                BufferedReader br = new BufferedReader(fr);
                String expected = br.readLine();
                while (expected != null) {
                    if ("!=".equals(expected)) {
                        desiredResult = false;
                    } else {
                        boolean result;
                        boolean bl = result = responseBody.indexOf(expected) >= 0;
                        if (result != desiredResult) {
                            responseStatus = false;
                            if (desiredResult) {
                                this.log("ERROR: expecting match on " + expected);
                            } else {
                                this.log("ERROR: expecting no match on " + expected);
                            }
                            this.log("In match file: " + this.responseMatchFile);
                            this.log("====================Got:");
                            this.log(responseBody);
                            this.log("====================");
                        }
                    }
                    expected = br.readLine();
                }
                br.close();
            }
            catch (FileNotFoundException ex) {
                this.log("\tMatch file not found: " + this.responseMatchFile);
                this.log("====================Got:");
                this.log(responseBody);
                this.log("====================");
                responseStatus = false;
            }
            catch (IOException ex) {
                this.log("\tError reading match file: " + this.responseMatchFile);
                this.log(ex.toString());
                responseStatus = false;
            }
        }
        return responseStatus;
    }
}

