/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test.matchers;

import java.util.Hashtable;
import org.apache.tomcat.util.test.Matcher;

public class ResponseMatch
extends Matcher {
    String responseMatch;

    public void setMatch(String s) {
        this.responseMatch = s;
    }

    public void setResponseMatch(String s) {
        this.responseMatch = s;
    }

    public String getTestDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append("( responseBody matches '" + this.responseMatch + "') ");
        return desc.toString();
    }

    public void execute() {
        if (this.skipTest()) {
            return;
        }
        try {
            this.result = this.checkResponse(this.magnitude);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.result = false;
        }
    }

    private boolean checkResponse(boolean testCondition) throws Exception {
        String responseLine = this.response.getResponseLine();
        Hashtable headers = this.response.getHeaders();
        boolean responseStatus = true;
        String responseBody = this.response.getResponseBody();
        if (this.responseMatch != null) {
            boolean match;
            if (responseBody == null) {
                this.log("ERROR: got no response, expecting " + this.responseMatch);
                return false;
            }
            boolean bl = match = responseBody.indexOf(this.responseMatch) >= 0;
            if (match != testCondition) {
                responseStatus = false;
                if (testCondition) {
                    this.log("ERROR: expecting match on " + this.responseMatch);
                } else {
                    this.log("ERROR: expecting no match on " + this.responseMatch);
                }
                this.log("GOT: ");
                this.log(responseBody);
            }
        }
        return responseStatus;
    }
}

