/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test.matchers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.util.test.Header;
import org.apache.tomcat.util.test.Matcher;

public class HeaderMatch
extends Matcher {
    String name;
    String value;
    Vector headerVector = new Vector();
    Hashtable expectHeaders = new Hashtable();

    public void setName(String n) {
        this.name = n;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public void addHeader(Header rh) {
        this.headerVector.addElement(rh);
    }

    public void setExpectHeaders(String s) {
        Header.parseHeadersAsString(s, this.headerVector);
    }

    public Hashtable getExpectHeaders() {
        if (this.name != null) {
            this.headerVector.addElement(new Header(this.name, this.value));
        }
        if (this.headerVector.size() > 0) {
            Enumeration en = this.headerVector.elements();
            while (en.hasMoreElements()) {
                Header rh = (Header)en.nextElement();
                this.expectHeaders.put(rh.getName(), rh);
            }
            this.headerVector = new Vector();
        }
        return this.expectHeaders;
    }

    public String getTestDescription() {
        StringBuffer desc = new StringBuffer();
        boolean needAND = false;
        if (this.getExpectHeaders().size() > 0) {
            Enumeration e = this.expectHeaders.keys();
            while (e.hasMoreElements()) {
                if (needAND) {
                    desc.append(" && ");
                }
                needAND = true;
                String key = (String)e.nextElement();
                Header h = (Header)this.expectHeaders.get(key);
                desc.append("( responseHeader '" + h.getName() + ": " + h.getValue() + "' ) ");
            }
        }
        desc.append(" == ").append(this.magnitude);
        return desc.toString();
    }

    public void execute() {
        if (this.skipTest()) {
            return;
        }
        try {
            this.result = this.checkResponse(this.magnitude);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.result = false;
        }
    }

    private boolean checkResponse(boolean testCondition) throws Exception {
        String responseLine = this.response.getResponseLine();
        Hashtable headers = this.response.getHeaders();
        boolean responseStatus = true;
        this.getExpectHeaders();
        if (this.expectHeaders.size() > 0) {
            if (headers == null) {
                this.log("ERROR no response header, expecting header");
            }
            Enumeration e = this.expectHeaders.keys();
            while (e.hasMoreElements()) {
                String respValue;
                String key = (String)e.nextElement();
                Header expH = (Header)this.expectHeaders.get(key);
                String value = expH.getValue();
                Header resH = (Header)headers.get(key);
                String string = respValue = resH == null ? "" : resH.getValue();
                if (respValue != null && respValue.indexOf(value) >= 0) continue;
                this.log("ERROR expecting header " + key + ":" + value + " \r\nGOT: " + respValue + " HEADERS(" + Header.toString(headers) + ")");
                return false;
            }
        }
        return responseStatus;
    }
}

