/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test.matchers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.tomcat.util.test.Matcher;

public class GoldenMatch
extends Matcher {
    String goldenFile;
    boolean exactMatch = false;

    public void setExactMatch(boolean ex) {
        this.exactMatch = ex;
    }

    public void setFile(String s) {
        this.goldenFile = s;
    }

    public void setGoldenFile(String s) {
        this.goldenFile = s;
    }

    public String getTestDescription() {
        StringBuffer desc = new StringBuffer();
        desc.append("( responseBody ");
        if (this.exactMatch) {
            desc.append("equals file '");
        } else {
            desc.append("like file '");
        }
        int idx = this.goldenFile.lastIndexOf("/");
        String g = idx > 0 ? this.goldenFile.substring(idx) : this.goldenFile;
        desc.append(this.goldenFile + "') ");
        desc.append(" == ").append(this.magnitude);
        return desc.toString();
    }

    public void execute() {
        if (this.skipTest()) {
            return;
        }
        try {
            this.result = this.checkResponse(this.magnitude);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.result = false;
        }
    }

    private boolean checkResponse(boolean testCondition) throws Exception {
        String responseLine = this.response.getResponseLine();
        Hashtable headers = this.response.getHeaders();
        boolean responseStatus = true;
        String responseBody = this.response.getResponseBody();
        if (this.goldenFile == null) {
            return responseStatus;
        }
        StringBuffer expResult = this.getExpectedResult();
        boolean cmp = true;
        cmp = this.exactMatch ? this.compare(responseBody, expResult.toString()) : this.compareWeek(responseBody, expResult.toString());
        if (cmp != testCondition) {
            responseStatus = false;
            this.log("ERROR (" + cmp + "," + testCondition + ")");
            this.log("====================Expecting: ");
            this.log(expResult.toString());
            this.log("====================Got:");
            this.log(responseBody);
            this.log("====================");
        }
        return responseStatus;
    }

    private StringBuffer getExpectedResult() throws IOException {
        StringBuffer expResult = new StringBuffer("NONE");
        try {
            FileInputStream in = new FileInputStream(this.goldenFile);
            return this.readBody(in);
        }
        catch (Exception ex) {
            this.log("\tGolden file not found: " + this.goldenFile);
            return expResult;
        }
    }

    private boolean compare(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str1.length() != str2.length()) {
            this.log("Wrong size " + str1.length() + " " + str2.length());
            return false;
        }
        for (int i = 0; i < str1.length(); ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            this.log("Error at " + i + " " + str1.charAt(1) + str2.charAt(i));
            return false;
        }
        return true;
    }

    private boolean compareWeek(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        StringTokenizer st1 = new StringTokenizer(str1);
        StringTokenizer st2 = new StringTokenizer(str2);
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            String tok2;
            String tok1 = st1.nextToken();
            if (tok1.equals(tok2 = st2.nextToken())) continue;
            this.log("\tFAIL*** : Rtok1 = " + tok1 + ", Etok2 = " + tok2);
            return false;
        }
        return !st1.hasMoreTokens() && !st2.hasMoreTokens();
    }

    StringBuffer readBody(InputStream input) {
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                int ch;
                if ((ch = input.read()) < 0) {
                    if (sb.length() == 0) {
                        return null;
                    }
                    break;
                }
                sb.append((char)ch);
            }
        }
        catch (IOException ex) {
            return sb;
        }
        return sb;
    }
}

