/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.util.test.Header;
import org.apache.tomcat.util.test.HttpClient;
import org.apache.tomcat.util.test.HttpRequest;

public class Report {
    static PrintWriter defaultOutput = new PrintWriter(System.out);
    static String defaultOutType = "text";
    PrintWriter out = null;
    String outType = null;
    HttpClient httpClient;
    HttpRequest httpRequest;
    String description;
    String failueMessage;

    public static void setDefaultWriter(PrintWriter pw) {
        defaultOutput = pw;
    }

    public static void setDefaultOutput(String s) {
        defaultOutType = s;
    }

    public void setWriter(PrintWriter pw) {
        this.out = pw;
    }

    public void setOutput(String t) {
        this.outType = t;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    public void setHttpRequest(HttpRequest req) {
        this.httpRequest = req;
    }

    public void setFailureMsg(String msg) {
        this.failueMessage = msg;
    }

    public void writeReport() {
        if (this.out == null) {
            this.out = defaultOutput;
        }
        if (this.outType == null) {
            this.outType = defaultOutType;
        }
        if ("text".equals(this.outType)) {
            this.textReport();
        }
        if ("html".equals(this.outType)) {
            this.htmlReport();
        }
    }

    private void textReport() {
        String msg = null;
        msg = "".equals(this.httpClient.getComment()) ? " (" + this.httpRequest.getRequestLine() + ")" : this.httpClient.getComment() + " (" + this.httpRequest.getRequestLine() + ")";
        if (this.httpClient.getResult()) {
            this.out.println("OK " + msg);
        } else {
            this.out.println("FAIL " + msg);
            this.out.println("Message: " + this.httpClient.getFailureMessage());
        }
        this.out.flush();
    }

    private void htmlReport() {
        Throwable ex;
        String uri = this.httpRequest.getURI();
        boolean result = this.httpClient.getResult();
        if (uri != null) {
            this.out.println("<a href='" + uri + "'>");
        }
        if (result) {
            this.out.println("OK ");
        } else {
            this.out.println("<font color='red'>FAIL ");
        }
        if (uri != null) {
            this.out.println("</a>");
        }
        String msg = null;
        msg = "".equals(this.httpClient.getComment()) ? " (" + this.httpRequest.getRequestLine() + ")" : this.httpClient.getComment() + " (" + this.httpRequest.getRequestLine() + ")";
        this.out.println(msg);
        if (!result) {
            this.out.println("</font>");
        }
        this.out.println("<br>");
        if (!result) {
            this.out.println("<b>Message:</b><pre>");
            this.out.println(this.httpClient.getFailureMessage());
            this.out.println("</pre>");
        }
        if (!result && this.httpClient.getDebug() > 0) {
            this.out.println("<b>Request: </b><pre>" + this.httpRequest.getFullRequest());
            this.out.println("</pre><b>Response:</b> " + this.httpRequest.getHttpResponse().getResponseLine());
            this.out.println("<br><b>Response headers:</b><br>");
            Hashtable headerH = this.httpRequest.getHttpResponse().getHeaders();
            Enumeration hE = headerH.elements();
            while (hE.hasMoreElements()) {
                Header h = (Header)hE.nextElement();
                this.out.println("<b>" + h.getName() + ":</b>" + h.getValue() + "<br>");
            }
            this.out.println("<b>Response body:</b><pre> ");
            this.out.println(this.httpRequest.getHttpResponse().getResponseBody());
            this.out.println("</pre>");
        }
        if ((ex = this.httpRequest.getHttpResponse().getThrowable()) != null) {
            this.out.println("<b>Exception</b><pre>");
            ex.printStackTrace(this.out);
            this.out.println("</pre><br>");
        }
        this.out.flush();
    }
}

