/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tomcat.util.buf.Base64;
import org.apache.tomcat.util.test.Body;
import org.apache.tomcat.util.test.Header;
import org.apache.tomcat.util.test.HttpClient;
import org.apache.tomcat.util.test.HttpResponse;
import org.apache.tomcat.util.test.Parameter;

public class HttpRequest {
    static String defaultHost = "localhost";
    static int defaultPort = 8080;
    static int defaultDebug = 0;
    static String defaultProtocol = "HTTP/1.0";
    String id;
    String host = null;
    int port = -1;
    String method = "GET";
    String protocol = null;
    String path;
    String requestLine;
    Vector headerVector = new Vector();
    Vector paramsV = new Vector();
    String user;
    String password;
    Body body;
    String fullRequest;
    int debug = defaultDebug;
    HttpClient client = null;
    HttpResponse response = null;
    boolean prepared = false;
    static String CRLF = "\r\n";
    static int idCounter = 0;
    static Hashtable allRequests = new Hashtable();

    public void setHttpResponse(HttpResponse r) {
        this.response = r;
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    public void setHttpClient(HttpClient c) {
        this.client = c;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setHost(String h) {
        this.host = h;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = defaultHost;
        }
        return this.host;
    }

    public void setMethod(String h) {
        this.method = h;
    }

    public void setPort(String portS) {
        this.port = Integer.valueOf(portS);
    }

    public void setPortInt(int i) {
        this.port = i;
    }

    public int getPort() {
        if (this.port == -1) {
            this.port = defaultPort;
        }
        return this.port;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setContent(String s) {
        this.body = new Body(s);
    }

    public void addBody(Body b) {
        this.body = b;
    }

    public void setProtocol(String s) {
        this.protocol = s;
    }

    public void setPath(String s) {
        this.path = s;
    }

    public void addHeader(String n, String v) {
        this.headerVector.addElement(new Header(n, v));
    }

    public void addHeader(Header rh) {
        this.headerVector.addElement(rh);
    }

    public void setHeaders(String s) {
        Header.parseHeadersAsString(s, this.headerVector);
    }

    public void addParam(Parameter rp) {
        this.paramsV.addElement(rp);
    }

    public void setDebug(int d) {
        this.debug = d;
    }

    public void setRequestLine(String s) {
        this.requestLine = s;
    }

    public String getRequestLine() {
        if (this.requestLine == null) {
            this.prepareRequest();
            int idx = this.fullRequest.indexOf("\r");
            this.requestLine = idx < 0 ? this.fullRequest : this.fullRequest.substring(0, idx);
        }
        return this.requestLine;
    }

    public void setFullRequest(String s) {
        this.fullRequest = s;
    }

    public String getFullRequest() {
        return this.fullRequest;
    }

    public void addVerbose(Body b) {
        this.fullRequest = b.getBody();
    }

    public void addText(String s) {
        if (null != s && s.trim().length() > 0) {
            this.fullRequest = s;
        }
    }

    public void execute() {
        this.prepareRequest();
    }

    public void prepareRequest() {
        if (this.prepared) {
            return;
        }
        if (this.host == null) {
            this.host = defaultHost;
        }
        if (this.port == -1) {
            this.port = defaultPort;
        }
        if (this.protocol == null) {
            this.protocol = defaultProtocol;
        }
        this.prepared = true;
        if (this.id == null) {
            this.id = "Req" + HttpRequest.getId();
        }
        HttpRequest.registerHttpRequest(this.id, this);
        if (this.fullRequest != null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (this.requestLine != null) {
            sb.append(this.requestLine);
        } else {
            sb.append(this.method).append(" ").append(this.path);
            boolean first = true;
            for (int i = 0; i < this.paramsV.size(); ++i) {
                Parameter p = (Parameter)this.paramsV.elementAt(i);
                if (!"GET".equals(p.getType(this.method))) continue;
                if (first && this.path.indexOf("?") < 0) {
                    sb.append("?");
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(p.getName());
                sb.append("=");
                String v = p.getValue();
                if (v == null) continue;
                sb.append(v);
            }
            sb.append(" ").append("HTTP/1.0");
            this.requestLine = sb.toString();
        }
        sb.append(CRLF);
        if (this.requestLine.indexOf("HTTP/1.") < 0) {
            this.fullRequest = sb.toString();
            return;
        }
        String contentL = null;
        String hostHeader = null;
        String contentType = null;
        String authorization = null;
        Enumeration headersE = this.headerVector.elements();
        while (headersE.hasMoreElements()) {
            Header h = (Header)headersE.nextElement();
            sb.append(h.getName()).append(": ");
            sb.append(h.getValue()).append(CRLF);
            if ("Content-Type".equals(h.getName())) {
                contentType = h.getValue();
            }
            if ("Content-Length".equals(h.getName())) {
                contentL = h.getValue();
            }
            if ("Host".equals(h.getName())) {
                hostHeader = h.getValue();
            }
            if (!"Authorization".equals(h.getName())) continue;
            authorization = h.getValue();
        }
        if (hostHeader == null && this.host != null && !"".equals(this.host)) {
            sb.append("Host: ").append(this.host).append(':').append(this.port).append(CRLF);
        }
        if (this.body == null && "POST".equals(this.method)) {
            StringBuffer bodySB = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < this.paramsV.size(); ++i) {
                Parameter p = (Parameter)this.paramsV.elementAt(i);
                if (!"POST".equals(p.getType("POST"))) continue;
                if (!first) {
                    bodySB.append("&");
                }
                first = false;
                bodySB.append(p.getName());
                bodySB.append("=");
                String v = p.getValue();
                if (v == null) continue;
                bodySB.append(v);
            }
            if (!first) {
                if (contentType == null) {
                    sb.append("Content-Type: ");
                    sb.append("application/x-www-form-urlencoded");
                    sb.append(CRLF);
                }
                this.body = new Body(bodySB.toString());
            }
        }
        if (authorization == null && this.user != null && this.password != null) {
            sb.append("Authorization: Basic ");
            String token = this.user + ":" + this.password;
            sb.append(Base64.encode((byte[])token.getBytes()));
            sb.append(CRLF);
        }
        if (this.body != null) {
            if (contentL == null) {
                sb.append("Content-Length: ").append(this.body.getBody().length());
                sb.append(CRLF).append(CRLF);
            }
            sb.append(this.body.getBody());
        } else {
            sb.append(CRLF);
        }
        this.fullRequest = sb.toString();
    }

    public String getURI() {
        String toExtract = this.getRequestLine();
        if (this.fullRequest == null) {
            toExtract = this.requestLine;
        }
        if (toExtract == null) {
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(toExtract, " ");
            st.nextToken();
            return st.nextToken();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static synchronized int getId() {
        return idCounter++;
    }

    public static Hashtable getAllRequests() {
        return allRequests;
    }

    public static void registerHttpRequest(String id, HttpRequest req) {
        allRequests.put(id, req);
    }

    public static HttpRequest getHttpRequest(String id) {
        return (HttpRequest)allRequests.get(id);
    }

    public static Enumeration getHttpRequests() {
        return allRequests.keys();
    }
}

