/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.util.test.Body;
import org.apache.tomcat.util.test.Header;
import org.apache.tomcat.util.test.HttpRequest;
import org.apache.tomcat.util.test.HttpResponse;
import org.apache.tomcat.util.test.Matcher;
import org.apache.tomcat.util.test.Report;
import org.apache.tomcat.util.test.matchers.GoldenMatch;
import org.apache.tomcat.util.test.matchers.HeaderMatch;
import org.apache.tomcat.util.test.matchers.HttpStatusMatch;
import org.apache.tomcat.util.test.matchers.ResponseMatch;
import org.apache.tomcat.util.test.matchers.ResponseMatchFile;
import org.apache.tomcat.util.test.matchers.SessionMatch;
import org.apache.tools.ant.Project;

public class HttpClient {
    static Report defaultReport = new Report();
    Project project = null;
    String ifProp = null;
    String unlessProp = null;
    HttpRequest firstRequest = null;
    Vector actions = new Vector();
    String id;
    int debug = 0;
    Body comment = null;
    boolean success = true;
    PrintWriter out = null;
    String outType = null;
    Matcher failingMatcher = null;
    static Vector testResults = new Vector();
    static Vector testFailures = new Vector();
    static Vector testSuccess = new Vector();
    static Hashtable clients = new Hashtable();

    public void setProject(Project p) {
        this.project = p;
    }

    public Project getProject() {
        return this.project;
    }

    public void setIf(String prop) {
        this.ifProp = prop;
    }

    public void setUnless(String prop) {
        this.unlessProp = prop;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDebug(int d) {
        this.debug = d;
    }

    public int getDebug() {
        return this.debug;
    }

    public void addHttpRequest(HttpRequest b) {
        b.setHttpClient(this);
        if (this.firstRequest == null) {
            this.firstRequest = b;
        }
        this.actions.addElement(b);
    }

    public Body createComment() {
        this.comment = new Body();
        return this.comment;
    }

    public String getComment() {
        if (this.comment == null) {
            return "";
        }
        return this.comment.getText();
    }

    public void setDescription(String s) {
        this.comment = new Body(s);
    }

    public void setWriter(PrintWriter pw) {
        this.out = pw;
    }

    public void setOutput(String t) {
        this.outType = t;
    }

    public void addMatcher(Matcher m) {
        m.setHttpClient(this);
        this.actions.addElement(m);
    }

    public void addGoldenMatch(GoldenMatch m) {
        this.addMatcher(m);
    }

    public void addHeaderMatch(HeaderMatch m) {
        this.addMatcher(m);
    }

    public void addHttpStatusMatch(HttpStatusMatch m) {
        this.addMatcher(m);
    }

    public void addResponseMatch(ResponseMatch m) {
        this.addMatcher(m);
    }

    public void addResponseMatchFile(ResponseMatchFile m) {
        this.addMatcher(m);
    }

    public void addSessionMatch(SessionMatch m) {
        this.addMatcher(m);
    }

    public HttpRequest getFirstRequest() {
        return this.firstRequest;
    }

    public Matcher getFailingMatch() {
        return this.failingMatcher;
    }

    public String getFailureMessage() {
        if (this.failingMatcher == null) {
            return "";
        }
        return this.failingMatcher.getMessage();
    }

    public boolean getResult() {
        return this.success;
    }

    public void execute() {
        if (this.project != null) {
            if (this.ifProp != null && this.project.getProperty(this.ifProp) == null) {
                return;
            }
            if (this.unlessProp != null && this.project.getProperty(this.unlessProp) != null) {
                return;
            }
        }
        HttpRequest lastRequest = null;
        try {
            Enumeration aE = this.actions.elements();
            while (aE.hasMoreElements()) {
                Object action = aE.nextElement();
                if (action instanceof HttpRequest) {
                    lastRequest = (HttpRequest)action;
                    this.dispatch(lastRequest);
                    continue;
                }
                if (!(action instanceof Matcher)) continue;
                Matcher matcher = (Matcher)action;
                matcher.setHttpRequest(lastRequest);
                matcher.setHttpResponse(lastRequest.getHttpResponse());
                matcher.execute();
                boolean testResult = matcher.getResult();
                if (testResult) continue;
                this.success = false;
                this.failingMatcher = matcher;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.id != null) {
            clients.put(this.id, this);
        }
        testResults.addElement(this);
        if (!this.success) {
            testFailures.addElement(this.getFailingMatch());
        } else {
            testSuccess.addElement(this);
        }
        if (lastRequest != null) {
            defaultReport.setHttpClient(this);
            defaultReport.setHttpRequest(lastRequest);
            defaultReport.setWriter(this.out);
            defaultReport.setOutput(this.outType);
            defaultReport.writeReport();
        }
    }

    private void dispatch(HttpRequest req) throws Exception {
        Socket s = new Socket(req.getHost(), req.getPort());
        s.setSoLinger(true, 1000);
        InputStream is = s.getInputStream();
        OutputStream os = s.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os);
        PrintWriter pw = new PrintWriter(out);
        HttpResponse response = new HttpResponse();
        req.setHttpResponse(response);
        req.prepareRequest();
        String fullRequest = req.getFullRequest();
        if (this.debug > 5) {
            System.out.println("--------------------Sending ");
            System.out.println(fullRequest);
            System.out.println("----------");
        }
        try {
            os.write(fullRequest.getBytes());
            os.flush();
        }
        catch (Exception ex1) {
            response.setThrowable(ex1);
            return;
        }
        try {
            StringBuffer result;
            if (fullRequest.indexOf("HTTP/1.") > -1) {
                if (this.debug > 5) {
                    System.out.println("Reading response ");
                }
                String responseLine = HttpClient.read(is);
                if (this.debug > 5) {
                    System.out.println("Got: " + responseLine);
                }
                response.setResponseLine(responseLine);
                Hashtable headers = Header.parseHeaders(is);
                if (this.debug > 5) {
                    System.out.println("Got headers: " + headers);
                }
                response.setHeaders(headers);
            }
            if ((result = this.readBody(is)) != null) {
                response.setResponseBody(result.toString());
            }
            if (this.debug > 5) {
                System.out.println("Got body: " + result);
            }
        }
        catch (SocketException ex) {
            response.setThrowable(ex);
        }
        try {
            s.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    StringBuffer readBody(InputStream input) {
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                int ch;
                if ((ch = input.read()) < 0) {
                    if (sb.length() == 0) {
                        return null;
                    }
                    break;
                }
                sb.append((char)ch);
            }
        }
        catch (IOException ex) {
            return sb;
        }
        return sb;
    }

    public static String read(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        block2: while (true) {
            try {
                while (true) {
                    int ch;
                    if ((ch = input.read()) < 0) {
                        if (sb.length() != 0) break block2;
                        return "";
                    }
                    if (ch == 10) break block2;
                    sb.append((char)ch);
                }
            }
            catch (IOException ex) {
                System.out.println("Error reading : " + ex);
                ex.printStackTrace();
                continue;
            }
            break;
        }
        int n = sb.length();
        if (n > 0 && sb.charAt(n - 1) == '\r') {
            sb.setLength(n - 1);
        }
        return sb.toString();
    }

    public static Hashtable getHttpClients() {
        return clients;
    }

    public static Vector getTestResults() {
        return testResults;
    }

    public static Vector getTestFailures() {
        return testFailures;
    }

    public static Vector getTestSuccess() {
        return testSuccess;
    }

    public String getMatchDescription() {
        return "";
    }
}

