/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tomcat.util.test.HttpClient;

public class Header {
    String name;
    String value;

    public Header() {
    }

    public Header(String n, String v) {
        this.setName(n);
        this.setValue(v);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String toString() {
        return this.value;
    }

    public static Hashtable parseHeaders(InputStream is) throws IOException {
        String line;
        Hashtable<String, Header> headers = new Hashtable<String, Header>();
        while ((line = HttpClient.read(is)) != null && line.length() >= 1) {
            Header h = new Header();
            h.parseHeaderLine(line);
            if (h.getName() == null) {
                System.out.println("ERROR: Wrong Header Line: " + line);
                continue;
            }
            headers.put(h.getName(), h);
        }
        return headers;
    }

    public void parseHeaderLine(String line) {
        int colon = line.indexOf(":");
        if (colon < 0) {
            return;
        }
        this.name = line.substring(0, colon).trim();
        this.value = line.substring(colon + 1).trim();
    }

    public static void parseHeadersAsString(String s, Vector headers) {
        StringTokenizer st = new StringTokenizer(s, "|");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            Header h = new Header();
            h.parseHeaderLine(tok);
            if (h.getName() == null) continue;
            headers.addElement(h);
        }
    }

    public static String toString(Hashtable headers) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Enumeration eH = headers.keys();
        while (eH.hasMoreElements()) {
            String k = (String)eH.nextElement();
            sb.append(k).append("=");
            sb.append(((Header)headers.get(k)).getValue());
            if (!eH.hasMoreElements()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public void execute() {
    }
}

