/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.test;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.util.test.HttpClient;
import org.apache.tomcat.util.test.HttpRequest;
import org.apache.tomcat.util.test.Matcher;
import org.apache.tomcat.util.test.Report;
import org.apache.tomcat.util.test.matchers.GoldenMatch;
import org.apache.tomcat.util.test.matchers.HeaderMatch;
import org.apache.tomcat.util.test.matchers.HttpStatusMatch;
import org.apache.tomcat.util.test.matchers.ResponseMatch;
import org.apache.tomcat.util.test.matchers.ResponseMatchFile;
import org.apache.tools.ant.Project;

public class GTest {
    static int defaultDebug = 0;
    static boolean failureOnly = false;
    static Hashtable testProperties = new Hashtable();
    Project project = null;
    String ifProp = null;
    String unlessProp = null;
    HttpClient httpClient = new HttpClient();
    HttpRequest httpRequest = new HttpRequest();
    String failMessage = "";
    PrintWriter out = null;
    String outType = null;
    int debug = -1;
    boolean result = false;
    boolean exactMatch = false;
    boolean magnitude = true;
    String goldenFile;
    String expectedHeader;
    String responseMatch;
    String responseMatchFile;
    String returnCode;

    public GTest() {
        this.httpClient.setDebug(this.debug);
        this.httpClient.addHttpRequest(this.httpRequest);
    }

    public static void setDefaultDebug(int d) {
        defaultDebug = d;
    }

    public static void setDefaultWriter(PrintWriter pw) {
        Report.setDefaultWriter(pw);
    }

    public static void setDefaultOutput(String s) {
        Report.setDefaultOutput(s);
    }

    public static Vector getTestResults() {
        return HttpClient.getTestResults();
    }

    public static Vector getTestFailures() {
        return HttpClient.getTestFailures();
    }

    public static Vector getTestSuccess() {
        return HttpClient.getTestSuccess();
    }

    public static Hashtable getTestProperties() {
        return testProperties;
    }

    public static void resetGTest() {
        GTest.getTestResults().setSize(0);
        GTest.getTestFailures().setSize(0);
        GTest.getTestSuccess().setSize(0);
        GTest.getTestProperties().clear();
        HttpClient.getHttpClients().clear();
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public void setIf(String prop) {
        this.ifProp = prop;
    }

    public void setUnless(String prop) {
        this.unlessProp = prop;
    }

    public void setWriter(PrintWriter pw) {
        this.out = pw;
    }

    public void setOutput(String t) {
        this.outType = t;
    }

    public void setFailureOnly(String e) {
        failureOnly = Boolean.valueOf(e);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getComment() {
        return this.httpClient.getComment();
    }

    public String getDescription() {
        return this.httpClient.getComment();
    }

    public void setDescription(String description) {
        this.httpClient.setDescription(description);
    }

    public String getMatchDescription() {
        Matcher m = this.httpClient.getFailingMatch();
        if (m == null) {
            return "";
        }
        return m.getTestDescription();
    }

    public String getFailureMessage() {
        return this.httpClient.getFailureMessage();
    }

    public void setDebug(String debugS) {
        this.debug = Integer.valueOf(debugS);
        this.httpClient.setDebug(this.debug);
    }

    public void setHost(String h) {
        this.httpRequest.setHost(h);
    }

    public void setPort(String portS) {
        this.httpRequest.setPort(portS);
    }

    public void setPortInt(int i) {
        this.httpRequest.setPortInt(i);
    }

    public void setContent(String s) {
        this.httpRequest.setContent(s);
    }

    public void setRequest(String s) {
        this.httpRequest.setRequestLine(s);
    }

    public void setHeaders(String s) {
        this.httpRequest.setHeaders(s);
    }

    public void setExactMatch(boolean exact) {
        this.exactMatch = exact;
    }

    public void setMagnitude(boolean m) {
        this.magnitude = m;
    }

    public void setGoldenFile(String s) {
        this.goldenFile = s;
    }

    public void setExpectHeaders(String s) {
        this.expectedHeader = s;
    }

    public void setResponseMatch(String s) {
        this.responseMatch = s;
    }

    public void setResponseMatchFile(String s) {
        this.responseMatchFile = s;
    }

    public void setReturnCode(String s) {
        this.returnCode = s;
    }

    public void execute() {
        try {
            if (this.debug == -1) {
                this.debug = defaultDebug;
            }
            this.httpClient.setProject(this.project);
            this.httpClient.setIf(this.ifProp);
            this.httpClient.setUnless(this.unlessProp);
            this.initMatchers();
            this.httpClient.setWriter(this.out);
            this.httpClient.setOutput(this.outType);
            this.httpClient.setDebug(this.debug);
            this.httpClient.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initMatchers() {
        if (this.goldenFile != null) {
            GoldenMatch gm = new GoldenMatch();
            gm.setFile(this.goldenFile);
            gm.setExactMatch(this.exactMatch);
            gm.setExpectedResult(this.magnitude);
            this.httpClient.addMatcher(gm);
        }
        if (this.expectedHeader != null) {
            HeaderMatch hm = new HeaderMatch();
            hm.setExpectHeaders(this.expectedHeader);
            hm.setExpectedResult(this.magnitude);
            this.httpClient.addMatcher(hm);
        }
        if (this.responseMatch != null) {
            ResponseMatch rm = new ResponseMatch();
            rm.setMatch(this.responseMatch);
            rm.setExpectedResult(this.magnitude);
            this.httpClient.addMatcher(rm);
        }
        if (this.responseMatchFile != null) {
            ResponseMatchFile rf = new ResponseMatchFile();
            rf.setFile(this.responseMatchFile);
            rf.setExpectedResult(this.magnitude);
            this.httpClient.addMatcher(rf);
        }
        if (this.returnCode != null) {
            HttpStatusMatch sm = new HttpStatusMatch();
            sm.setMatch(this.returnCode);
            sm.setExpectedResult(this.magnitude);
            this.httpClient.addMatcher(sm);
        }
    }
}

