/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.util.Enumeration;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.collections.SimpleHashtable;
import org.apache.tomcat.util.io.FileUtil;

public class PrefixMapper {
    SimpleHashtable vhostMaps = new SimpleHashtable();
    SimpleHashtable prefixMappedServlets = new SimpleHashtable();
    SimpleHashtable exactMappedServlets = new SimpleHashtable();
    SimpleHashtable mapCache = new SimpleHashtable();
    boolean mapCacheEnabled = false;

    public void setMapCache(boolean v) {
        this.mapCacheEnabled = v;
    }

    public void removeAllMappings(String host, String path) {
        String s;
        PrefixMapper vmap = this;
        if (host != null) {
            host = host.toLowerCase();
            vmap = (PrefixMapper)this.vhostMaps.get(host);
        }
        Enumeration en = vmap.prefixMappedServlets.keys();
        while (en.hasMoreElements()) {
            s = (String)en.nextElement();
            if (!s.startsWith(path)) continue;
            vmap.prefixMappedServlets.remove((Object)s);
        }
        en = vmap.exactMappedServlets.keys();
        while (en.hasMoreElements()) {
            s = (String)en.nextElement();
            if (!s.startsWith(path)) continue;
            vmap.exactMappedServlets.remove((Object)s);
        }
        this.mapCache = new SimpleHashtable();
    }

    void addMapping(String path, Object target) {
        this.prefixMappedServlets.put((Object)path, target);
    }

    void addExactMapping(String path, Object target) {
        this.exactMappedServlets.put((Object)path, target);
    }

    public void addMapping(String host, String path, Object target) {
        if (host == null) {
            this.prefixMappedServlets.put((Object)path, target);
        } else {
            PrefixMapper vmap = (PrefixMapper)this.vhostMaps.get(host = host.toLowerCase());
            if (vmap == null) {
                vmap = new PrefixMapper();
                this.vhostMaps.put((Object)host, (Object)vmap);
                vmap.setMapCache(this.mapCacheEnabled);
            }
            vmap.addMapping(path, target);
        }
    }

    public void addExactMapping(String host, String path, Object target) {
        if (host == null) {
            this.exactMappedServlets.put((Object)path, target);
        } else {
            PrefixMapper vmap = (PrefixMapper)this.vhostMaps.get(host = host.toLowerCase());
            if (vmap == null) {
                vmap = new PrefixMapper();
                this.vhostMaps.put((Object)host, (Object)vmap);
            }
            vmap.addExactMapping(path, target);
        }
    }

    public Object getLongestPrefixMatch(MessageBytes hostMB, MessageBytes pathMB) {
        String host = hostMB.toString();
        String path = pathMB.toString();
        Object container = null;
        String s = path;
        PrefixMapper myMap = null;
        if (host != null && (myMap = (PrefixMapper)this.vhostMaps.get(host)) == null) {
            myMap = (PrefixMapper)this.vhostMaps.get(host.toLowerCase());
        }
        if (myMap == null) {
            myMap = this;
        }
        if ((container = myMap.exactMappedServlets.get(path)) != null) {
            return container;
        }
        if (myMap.mapCacheEnabled && (container = myMap.mapCache.get(path)) != null) {
            return container;
        }
        while (s.length() >= 0) {
            container = myMap.prefixMappedServlets.get(s);
            if (container == null) {
                if (s.length() == 0) break;
                s = FileUtil.removeLast(s);
                continue;
            }
            if (myMap.mapCacheEnabled) {
                myMap.mapCache.put((Object)path, container);
            }
            return container;
        }
        return container;
    }
}

