/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.FileOutputStream;
import java.io.PrintStream;
import org.apache.tomcat.modules.server.StartupThread;

public class JNIEndpoint {
    JniHandler handler;
    boolean running = false;
    static JNIEndpoint ep;
    public static final int DEFAULT_TIMEOUT = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionHandler(JniHandler handler) {
        this.handler = handler;
        if (handler == null) {
            System.out.println("Shutting down, handler==null ...");
            this.running = false;
            JNIEndpoint jNIEndpoint = this;
            synchronized (jNIEndpoint) {
                this.notify();
            }
            return;
        }
        System.out.println("Running ...");
        this.running = true;
        JNIEndpoint jNIEndpoint = this;
        synchronized (jNIEndpoint) {
            this.notify();
        }
    }

    public static void setEndpoint(JNIEndpoint jniep) {
        ep = jniep;
    }

    public static JNIEndpoint getEndpoint() {
        return ep;
    }

    public static int getTimeout() {
        String to = System.getProperty("JNIEndpoint.timeout");
        if (to != null) {
            try {
                int i = new Integer(to);
                return i;
            }
            catch (Exception ex) {
                System.out.println("Invalid timeout " + to);
            }
        }
        return 60000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startup(String cmdLine, String stdout, String stderr) {
        if (ep != null) {
            System.err.println("ALREADY STARTED, this is the second call to STARTUP ");
            return 1;
        }
        System.err.println("Mod_jk calling startup() ");
        try {
            if (null != stdout) {
                System.setOut(new PrintStream(new FileOutputStream(stdout)));
            }
            if (null != stderr) {
                System.setErr(new PrintStream(new FileOutputStream(stderr)));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            JNIEndpoint.setEndpoint(this);
            StartupThread startup = new StartupThread(cmdLine);
            System.err.println("Starting up StartupThread");
            startup.start();
            JNIEndpoint jNIEndpoint = this;
            synchronized (jNIEndpoint) {
                this.wait(JNIEndpoint.getTimeout());
            }
            System.err.println("End waiting");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.running) {
            System.err.println("Running fine ");
            return 1;
        }
        System.err.println("Error - why doesn't run ??");
        return 0;
    }

    public int service(long s, long l) {
        if (this.running) {
            try {
                this.handler.processConnection(s, l);
                return 1;
            }
            catch (Throwable t) {
                System.out.println("Caught throwable " + t);
                t.printStackTrace();
            }
        }
        return 0;
    }

    public void shutdown() {
        if (this.handler != null && this.running) {
            this.handler.shutdown();
        }
    }

    public static interface JniHandler {
        public void processConnection(long var1, long var3);

        public void shutdown();
    }
}

