/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.xml.AddChild;
import org.apache.tomcat.util.xml.MethodParam;
import org.apache.tomcat.util.xml.MethodSetter;
import org.apache.tomcat.util.xml.ObjectCreate;
import org.apache.tomcat.util.xml.PathMatch;
import org.apache.tomcat.util.xml.PopStack;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.SetParent;
import org.apache.tomcat.util.xml.SetProperties;
import org.apache.tomcat.util.xml.SetVar;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMatch;
import org.xml.sax.AttributeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XmlMapper
extends HandlerBase
implements SaxContext {
    static Log logger = LogFactory.getLog((Class)(class$org$apache$tomcat$util$xml$XmlMapper == null ? (class$org$apache$tomcat$util$xml$XmlMapper = XmlMapper.class$("org.apache.tomcat.util.xml.XmlMapper")) : class$org$apache$tomcat$util$xml$XmlMapper));
    Locator locator;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resDTDs = new Hashtable();
    private Hashtable variables = new Hashtable();
    Stack oStack = new Stack();
    Object root;
    Object[] attributeStack;
    String[] tagStack;
    int oSp;
    int sp;
    ErrorHandler errorHandler;
    String body;
    boolean validating = false;
    private Hashtable entities = new Hashtable();
    Object propSource;
    boolean useLocalLoader = true;
    static final Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    Rule[] rules = new Rule[200];
    Rule[] matching = new Rule[200];
    int ruleCount = 0;
    ClassLoader loader;
    static /* synthetic */ Class class$org$apache$tomcat$util$xml$XmlMapper;

    public XmlMapper() {
        this.attributeStack = new Object[200];
        this.tagStack = new String[200];
        this.initDefaultRules();
    }

    public void setDocumentLocator(Locator locator) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Set locator : " + locator));
        }
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void startDocument() throws SAXException {
        this.sp = 0;
    }

    public void endDocument() throws SAXException {
        if (this.sp != 0) {
            System.out.println("The XML document is probably broken. " + this.sp);
        }
    }

    public void startElement(String tag, AttributeList attributes) throws SAXException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.sp + " <" + tag + " " + attributes + ">"));
            }
            this.attributeStack[this.sp] = attributes;
            this.tagStack[this.sp] = tag;
            ++this.sp;
            this.matchStart(this);
            this.body = "";
        }
        catch (Exception ex) {
            throw new SAXException(this.positionToString(), ex);
        }
    }

    public String positionToString() {
        AttributeList attributes;
        StringBuffer sb = new StringBuffer();
        if (this.locator != null) {
            sb.append("Line ").append(this.locator.getLineNumber()).append(" ");
        }
        sb.append("/");
        for (int i = 0; i < this.sp; ++i) {
            sb.append(this.tagStack[i]).append("/");
        }
        sb.append(" ");
        if (this.sp > 0 && (attributes = (AttributeList)this.attributeStack[this.sp - 1]) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                sb.append(attributes.getName(i)).append("=").append(attributes.getValue(i));
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public void endElement(String tag) throws SAXException {
        try {
            this.matchEnd(this);
            if (this.sp > 1) {
                this.tagStack[this.sp] = null;
                this.attributeStack[this.sp] = null;
            }
            --this.sp;
        }
        catch (Exception ex) {
            throw new SAXException(this.positionToString(), ex);
        }
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.body = this.body + new String(buf, offset, len);
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    public void processingInstruction(String name, String instruction) throws SAXException {
    }

    public AttributeList getAttributeList(int pos) {
        return (AttributeList)this.attributeStack[pos];
    }

    public AttributeList getCurrentAttributes() {
        return (AttributeList)this.attributeStack[this.sp - 1];
    }

    public int getTagCount() {
        return this.sp;
    }

    public String getTag(int pos) {
        return this.tagStack[pos];
    }

    public String getCurrentElement() {
        return this.tagStack[this.sp - 1];
    }

    public String getBody() {
        return this.body;
    }

    public Stack getObjectStack() {
        return this.oStack;
    }

    public Object popObject() {
        return this.oStack.pop();
    }

    public Object currentObject() {
        return this.oStack.peek();
    }

    public Object previousObject() {
        Object o = this.oStack.pop();
        Object result = this.oStack.peek();
        this.oStack.push(o);
        return result;
    }

    public void pushObject(Object o) {
        this.oStack.push(o);
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object o) {
        this.root = o;
    }

    public void setPropertySource(Object src) {
        this.propSource = src;
    }

    public Object getPropertySource() {
        return this.propSource;
    }

    public String replaceProperties(String k) {
        if (this.propSource == null) {
            return k;
        }
        return IntrospectionUtils.replaceProperties((String)k, (Object)this.propSource);
    }

    public void setDebug(int level) {
    }

    public int getDebug() {
        return logger.isDebugEnabled() ? 1 : 0;
    }

    public void setValidating(boolean validating) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Validating = " + validating));
        }
        this.validating = validating;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setVariable(String name, Object value) {
        if (value == null) {
            this.variables.remove(name);
        } else {
            this.variables.put(name, value);
        }
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public XmlMapper getMapper() {
        return this;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    public void useLocalLoader(boolean b) {
        this.useLocalLoader = b;
    }

    public void log(String msg) {
        logger.info((Object)msg);
    }

    public Object readXml(File xmlFile, Object root) throws Exception {
        if (root != null) {
            this.root = root;
            this.pushObject(root);
        }
        try {
            ClassLoader cl = null;
            if (this.useLocalLoader) {
                cl = jdk11Compat.getContextClassLoader();
                jdk11Compat.setContextClassLoader(this.getClass().getClassLoader());
            }
            SAXParser parser = null;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(this.validating);
            parser = factory.newSAXParser();
            Parser saxParser = parser.getParser();
            saxParser.setDocumentHandler(this);
            saxParser.setEntityResolver(this);
            if (this.errorHandler != null) {
                saxParser.setErrorHandler(this.errorHandler);
            }
            String uri = "file:" + xmlFile.getAbsolutePath();
            if (File.separatorChar == '\\') {
                uri = uri.replace('\\', '/');
            }
            InputSource input = new InputSource(uri);
            saxParser.parse(input);
            if (this.useLocalLoader && cl != null) {
                jdk11Compat.setContextClassLoader(cl);
            }
            return root;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            String msg = "Can't open config file: " + xmlFile + " due to: " + ioe;
            throw new Exception(msg);
        }
        catch (SAXException se) {
            System.out.println("ERROR reading " + xmlFile);
            System.out.println("At " + se.getMessage());
            System.out.println();
            Exception ex1 = se.getException();
            if (ex1 != null) {
                throw ex1;
            }
            throw se;
        }
    }

    public Object readXml(InputStream xmlFile, Object root) throws Exception {
        if (root != null) {
            this.root = root;
            this.pushObject(root);
        }
        SAXParser parser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(this.validating);
            parser = factory.newSAXParser();
            parser.parse(xmlFile, (HandlerBase)this);
            return root;
        }
        catch (IOException ioe) {
            String msg = "Can't open config file: " + xmlFile + " due to: " + ioe;
            throw new Exception(msg);
        }
        catch (SAXException se) {
            System.out.println("ERROR reading " + xmlFile);
            System.out.println("At " + se.getMessage());
            System.out.println();
            Exception ex1 = se.getException();
            throw ex1;
        }
    }

    public void registerDTDFile(String publicId, String dtdFile) {
        this.fileDTDs.put(publicId, dtdFile);
    }

    public void registerDTDRes(String publicId, String dtdRes) {
        this.resDTDs.put(publicId, dtdRes);
    }

    public Hashtable getEntities() {
        return this.entities;
    }

    private void initDefaultRules() {
        this.addRule("xmlmapper:debug", new XmlAction(){

            public void start(SaxContext ctx) {
                AttributeList attributes = ctx.getCurrentAttributes();
                String levelS = attributes.getValue("level");
                XmlMapper mapper = (XmlMapper)ctx;
                if (levelS != null) {
                    mapper.setDebug(new Integer(levelS));
                }
            }
        });
        this.addRule("xmlmapper:taskdef", new XmlAction(){

            public void start(SaxContext ctx) {
                XmlMapper mapper = (XmlMapper)ctx;
                AttributeList attributes = ctx.getCurrentAttributes();
                String match = attributes.getValue("match");
                if (match == null) {
                    return;
                }
                String obj = attributes.getValue("object-create");
                String objA = attributes.getValue("object-create-attrib");
                if (obj != null || objA != null) {
                    mapper.addRule(match, new ObjectCreate(obj, objA));
                }
                if ((obj = attributes.getValue("set-properties")) != null) {
                    mapper.addRule(match, new SetProperties());
                }
                if ((obj = attributes.getValue("set-parent")) != null) {
                    mapper.addRule(match, new SetParent(obj));
                }
                obj = attributes.getValue("add-child");
                objA = attributes.getValue("child-type");
                if (obj != null) {
                    mapper.addRule(match, new AddChild(obj, objA));
                }
                if ((obj = attributes.getValue("action")) != null) {
                    try {
                        ClassLoader cl = XmlMapper.this.getClassLoader();
                        Class<?> c = cl.loadClass(obj);
                        Object o = c.newInstance();
                        mapper.addRule(match, (XmlAction)o);
                    }
                    catch (Exception ex) {
                        System.out.println("Can't add action " + obj);
                    }
                }
            }
        });
    }

    public void addRule(String path, XmlAction action) {
        if (this.ruleCount >= this.rules.length) {
            Rule[] tmp = new Rule[2 * this.rules.length];
            System.arraycopy(this.rules, 0, tmp, 0, this.rules.length);
            this.rules = tmp;
        }
        this.rules[this.ruleCount] = new Rule(new PathMatch(path), action);
        ++this.ruleCount;
    }

    private int match(SaxContext ctx, Rule[] matching) {
        int matchCount = 0;
        for (int i = 0; i < this.ruleCount; ++i) {
            if (!this.rules[i].match.match(ctx) || this.rules[i].action == null) continue;
            matching[matchCount] = this.rules[i];
            ++matchCount;
        }
        return matchCount;
    }

    void matchStart(SaxContext ctx) throws Exception {
        int matchCount = this.match(ctx, this.matching);
        for (int i = 0; i < matchCount; ++i) {
            this.matching[i].action.start(ctx);
        }
    }

    void matchEnd(SaxContext ctx) throws Exception {
        int i;
        int matchCount = this.match(ctx, this.matching);
        for (i = 0; i < matchCount; ++i) {
            this.matching[i].action.end(ctx);
        }
        for (i = 0; i < matchCount; ++i) {
            this.matching[i].action.cleanup(ctx);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        File dtdF;
        if (publicId == null) {
            this.log("publicID is 'null'");
            return null;
        }
        if (systemId == null) {
            this.log("systemId is 'null'");
            systemId = "";
        }
        this.entities.put(publicId, systemId);
        String dtd = (String)this.fileDTDs.get(publicId);
        if (dtd != null && (dtdF = new File(dtd)).exists()) {
            try {
                return new InputSource(new FileInputStream(dtdF));
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        if ((dtd = (String)this.resDTDs.get(publicId)) != null) {
            InputStream is = this.getClassLoader().getResourceAsStream(dtd);
            if (is != null) {
                return new InputSource(is);
            }
            XmlMapper.dumpCP(this.getClassLoader());
        }
        this.log("Can't find resource for entity: " + publicId + " --> " + systemId + " \"" + dtd + "\"");
        return null;
    }

    public static void dumpCP(ClassLoader cl) {
        int i;
        Jdk11Compat jdk = Jdk11Compat.getJdkCompat();
        URL[] urls = jdk.getURLs(cl, 0);
        System.out.println("CLASSPATH ");
        for (i = 0; i < urls.length; ++i) {
            System.out.println("    " + urls[i]);
        }
        urls = jdk.getURLs(cl, 1);
        System.out.println();
        for (i = 0; i < urls.length; ++i) {
            System.out.println("    " + urls[i]);
        }
        urls = jdk.getURLs(cl, 2);
        System.out.println();
        for (i = 0; i < urls.length; ++i) {
            System.out.println("    " + urls[i]);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) {
        System.out.println("Notation: " + name + " " + publicId + " " + systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        System.out.println("Unparsed: " + name + " " + publicId + " " + systemId + " " + notationName);
    }

    public XmlAction objectCreate(String classN) {
        return new ObjectCreate(classN);
    }

    public XmlAction objectCreate(String classN, String attrib) {
        return new ObjectCreate(classN, attrib);
    }

    public XmlAction objectCreate(String classN, String attrib, String[] pref) {
        return new ObjectCreate(classN, attrib, pref);
    }

    public XmlAction setProperties() {
        return new SetProperties();
    }

    public XmlAction setVar(String varName, String attName) {
        return new SetVar(varName, attName);
    }

    public XmlAction setVar(String varName, String nameAtt, String valueAtt, boolean reset) {
        return new SetVar(varName, nameAtt, valueAtt, reset);
    }

    public XmlAction setParent(String childM) {
        return new SetParent(childM);
    }

    public XmlAction setParent(String childM, String argType) {
        return new SetParent(childM, argType);
    }

    public XmlAction addChild(String parentM, String argType) {
        return new AddChild(parentM, argType);
    }

    public XmlAction methodSetter(String method, int paramC) {
        return new MethodSetter(method, paramC);
    }

    public XmlAction methodSetter(String method, int paramC, String[] paramTypes) {
        return new MethodSetter(method, paramC, paramTypes);
    }

    public XmlAction methodParam(int ord) {
        return new MethodParam(ord, null);
    }

    public XmlAction methodParam(int ord, String attrib) {
        return new MethodParam(ord, attrib);
    }

    public XmlAction popStack() {
        return new PopStack();
    }

    public ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = this.getClass().getClassLoader();
        }
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Rule {
        XmlMatch match;
        XmlAction action;

        Rule(XmlMatch match, XmlAction action) {
            this.match = match;
            this.action = action;
        }
    }
}

