/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.xml;

import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.xml.sax.AttributeList;

class ObjectCreate
extends XmlAction {
    String className;
    String attrib;
    String[] pref = null;

    public ObjectCreate(String classN) {
        this.className = classN;
    }

    public ObjectCreate(String classN, String attrib) {
        this.className = classN;
        this.attrib = attrib;
    }

    public ObjectCreate(String classN, String attrib, String[] pref) {
        this.className = classN;
        this.attrib = attrib;
        this.pref = pref;
    }

    public void start(SaxContext ctx) throws Exception {
        AttributeList attributes;
        String tag = ctx.getCurrentElement();
        String classN = this.className;
        ClassLoader cl = ctx.getClassLoader();
        if (this.attrib != null && (attributes = ctx.getCurrentAttributes()).getValue(this.attrib) != null) {
            classN = attributes.getValue(this.attrib);
        }
        Class<?> c = null;
        if (this.pref != null && classN.indexOf(".") < 0) {
            for (int i = 0; i < this.pref.length; ++i) {
                try {
                    c = cl.loadClass(this.pref[i] + classN);
                    if (c == null) continue;
                    break;
                }
                catch (Exception ex) {
                    if (ctx.getDebug() <= 0) continue;
                    ctx.log("Try " + this.pref[i] + classN);
                }
            }
        }
        if (c == null) {
            c = cl.loadClass(classN);
        }
        Object o = c.newInstance();
        ctx.pushObject(o);
        if (ctx.getDebug() > 0) {
            ctx.log("new " + this.attrib + " " + classN + " " + tag + " " + o);
        }
    }

    public void cleanup(SaxContext ctx) {
        String tag = ctx.getCurrentElement();
        Object o = ctx.popObject();
        if (ctx.getDebug() > 0) {
            ctx.log("pop " + tag + " " + o.getClass().getName() + ": " + o);
        }
    }
}

