/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.qlog;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.log.Log;
import org.apache.tomcat.util.log.LogManager;
import org.apache.tomcat.util.qlog.LogDaemon;

public final class QLogFactory
extends LogFactory {
    static LogManager logManager;
    static LogDaemon logDaemon;
    private Hashtable attributes = new Hashtable();
    private Hashtable instances = new Hashtable();

    public QLogFactory() {
        if (logManager == null) {
            logManager = new TomcatLogManager();
            logDaemon = new LogDaemon();
            logDaemon.start();
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            names.addElement((String)keys.nextElement());
        }
        String[] results = new String[names.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = (String)names.elementAt(i);
        }
        return results;
    }

    public org.apache.commons.logging.Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public org.apache.commons.logging.Log getInstance(String name) throws LogConfigurationException {
        org.apache.commons.logging.Log instance = (org.apache.commons.logging.Log)this.instances.get(name);
        if (instance != null) {
            return instance;
        }
        instance = Log.getLog(name, name);
        this.instances.put(name, instance);
        return instance;
    }

    public void release() {
        this.instances.clear();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    static class TomcatLogManager
    extends LogManager {
        TomcatLogManager() {
            LogManager olm = Log.setLogManager(this);
            this.loggers = olm.getLoggers();
            this.channels = olm.getChannels();
        }
    }
}

