/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.util.Hashtable;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.startup.EmbededTomcat;
import org.apache.tomcat.startup.EnableAdmin;
import org.apache.tomcat.startup.StopTomcat;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public class Tomcat {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    EmbededTomcat tomcat = new EmbededTomcat();
    static final String DEFAULT_CONFIG = "conf/server.xml";
    Hashtable attributes = new Hashtable();
    private static int dL = 0;

    public void setHome(String home) {
        if (dL > 0) {
            this.debug("setHome " + home);
        }
        this.attributes.put("home", home);
    }

    public void setH(String home) {
        this.setHome(home);
    }

    public void setInstall(String install) {
        this.attributes.put("install", install);
    }

    public void setI(String install) {
        this.setInstall(install);
    }

    public void setArgs(String[] args) {
        this.attributes.put("args", args);
    }

    public void setConfig(String s) {
        this.attributes.put("config", s);
    }

    public void setF(String s) {
        this.setConfig(s);
    }

    public void setAction(String s) {
        this.attributes.put("action", s);
        this.attributes.put(s, "true");
    }

    public void setSandbox(boolean b) {
        if (b) {
            this.attributes.put("sandbox", "true");
        }
    }

    public void setStop(boolean b) {
        if (b) {
            this.attributes.put("stop", "true");
        }
    }

    public void setEnableAdmin(boolean b) {
        if (b) {
            this.attributes.put("enableAdmin", "true");
        }
    }

    public void setParentClassLoader(ClassLoader cl) {
        this.attributes.put("parentClassLoader", cl);
    }

    public void setCommonClassLoader(ClassLoader cl) {
        this.attributes.put("commonClassLoader", cl);
    }

    public void setAppsClassLoader(ClassLoader cl) {
        this.attributes.put("appsClassLoader", cl);
    }

    public void setContainerClassLoader(ClassLoader cl) {
        this.attributes.put("containerClassLoader", cl);
    }

    public void execute() throws Exception {
        if (this.attributes.get("home") == null) {
            this.attributes.put("home", System.getProperty("tomcat.home"));
        }
        if (this.attributes.get("stop") != null) {
            this.stopTomcat();
        } else if (this.attributes.get("enableAdmin") != null) {
            this.enableAdmin();
        } else if (this.attributes.get("help") != null) {
            Tomcat.printUsage();
        } else {
            this.startTomcat();
        }
    }

    public void enableAdmin() throws TomcatException {
        try {
            EnableAdmin task = new EnableAdmin();
            task.setHome((String)this.attributes.get("home"));
            task.processArgs((String[])this.attributes.get("args"));
            task.execute();
        }
        catch (Exception te) {
            te.printStackTrace();
            throw new TomcatException(te);
        }
    }

    public void stopTomcat() throws TomcatException {
        try {
            StopTomcat task = new StopTomcat();
            task.setHome((String)this.attributes.get("home"));
            task.processArgs((String[])this.attributes.get("args"));
            task.execute();
        }
        catch (Exception te) {
            throw new TomcatException(te);
        }
    }

    public void startTomcat() throws TomcatException {
        try {
            EmbededTomcat task = new EmbededTomcat();
            task.setHome((String)this.attributes.get("home"));
            task.processArgs((String[])this.attributes.get("args"));
            task.execute();
        }
        catch (Exception te) {
            throw new TomcatException(te);
        }
    }

    public static void printUsage() {
        System.out.println("Usage: java org.apache.tomcat.startup.Tomcat {options}");
        System.out.println("  Options are:");
        System.out.println("    -ajpid file                Use this file instead of conf/ajp12.id");
        System.out.println("                                 Use with -stop option");
        System.out.println("    -config file (or -f file)  Use this file instead of server.xml");
        System.out.println("    -enableAdmin               Updates admin webapp config to \"trusted\"");
        System.out.println("    -help (or help)            Show this usage report");
        System.out.println("    -home dir                  Use this directory as tomcat.home");
        System.out.println("    -install dir (or -i dir)   Use this directory as tomcat.install");
        System.out.println("    -sandbox                   Enable security manager (includes java.policy)");
        System.out.println("    -stop                      Shut down currently running Tomcat");
        System.out.println();
        System.out.println("In the absence of \"-enableAdmin\" and \"-stop\", Tomcat will be started");
    }

    public boolean processArgs(String[] args) {
        this.setArgs(args);
        try {
            return IntrospectionUtils.processArgs((Object)this, (String[])args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void setProperty(String s, Object v) {
        if (dL > 0) {
            this.debug("Generic property " + s);
        }
        this.attributes.put(s, v);
    }

    public void setAttribute(String s, Object o) {
        String[] args;
        boolean ok;
        if ("args".equals(s) && !(ok = this.processArgs(args = (String[])o))) {
            Tomcat.printUsage();
            return;
        }
        this.attributes.put(s, o);
    }

    public static void main(String[] args) {
        try {
            Tomcat tomcat = new Tomcat();
            tomcat.processArgs(args);
            tomcat.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void debug(String s) {
        System.out.println("Tomcat: " + s);
    }
}

