/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.startup.Property;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;

public class EmbededTomcat {
    protected ContextManager contextM = new ContextManager();
    protected Object application;
    protected Vector connectors = new Vector();
    String home = null;
    String installDir = null;
    int httpPort = 8080;
    int ajpPort = 0;
    Hashtable attributes = new Hashtable();
    protected int dL = 0;
    boolean defaultConnectors = true;
    boolean autoDeploy = true;
    boolean serverXml = true;
    boolean help;
    boolean blocking = false;
    String modulesFile = null;
    boolean nostart = false;
    boolean noClassLoaders = false;
    Vector modules = new Vector();
    protected boolean initialized = false;
    protected String[] args = null;
    ClassLoader parentCL;
    ClassLoader appsCL;
    ClassLoader commonCL;
    ClassLoader containerCL;
    ClassLoader modulesCL;
    URL[] commonCP;
    URL[] modulesCP;
    URL[] appsCP;
    URL[] containerCP;
    static final Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    public static final String PROPERTY_APPS_LOADER = "org.apache.tomcat.apps.classpath";
    public static final String PROPERTY_CONTAINER_LOADER = "org.apache.tomcat.container.classpath";
    protected String[] moduleSet1 = new String[]{"org.apache.tomcat.modules.config.HookSetter", "org.apache.tomcat.modules.config.PathSetter", "org.apache.tomcat.modules.config.LoaderInterceptor11", "org.apache.tomcat.modules.config.TrustedLoader", "org.apache.tomcat.modules.config.LogSetter", "org.apache.tomcat.modules.mappers.SimpleMapper1", "org.apache.tomcat.modules.session.SessionExpirer", "org.apache.tomcat.modules.session.SessionIdGenerator", "org.apache.tomcat.modules.session.SessionId", "org.apache.tomcat.facade.WebXmlReader", "org.apache.tomcat.modules.generators.ErrorHandler", "org.apache.tomcat.modules.config.WorkDirSetup", "org.apache.tomcat.modules.generators.Jdk12Interceptor", "org.apache.tomcat.modules.generators.InvokerInterceptor", "org.apache.tomcat.modules.generators.StaticInterceptor", "org.apache.tomcat.modules.mappers.ReloadInterceptor", "org.apache.tomcat.modules.session.SimpleSessionStore", "org.apache.tomcat.modules.aaa.AccessInterceptor", "org.apache.tomcat.modules.aaa.CredentialsInterceptor", "org.apache.tomcat.modules.aaa.SimpleRealm", "org.apache.tomcat.facade.LoadOnStartupInterceptor", "org.apache.tomcat.facade.Servlet22Interceptor", "org.apache.tomcat.modules.mappers.DecodeInterceptor"};
    static String POLICY_MODULE = "org.apache.tomcat.modules.config.PolicyInterceptor";
    static String LOG_EVENTS_MODULE = "org.apache.tomcat.modules.loggers.LogEvents";
    protected String[] moduleSetAD = new String[]{"org.apache.tomcat.modules.config.ContextXmlReader", "org.apache.tomcat.modules.config.AutoDeploy", "org.apache.tomcat.modules.config.AutoWebApp"};

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public void setDebug(int debug) {
        this.dL = debug;
        this.contextM.setDebug(debug);
        this.debug("Debugging enabled ");
    }

    public void setStartb(boolean b) {
        this.blocking = b;
    }

    public void setNoClassloaders(boolean b) {
        this.noClassLoaders = b;
    }

    public void setHome(String s) {
        this.home = s;
    }

    public void setInstall(String install) {
        this.installDir = install;
        this.contextM.setInstallDir(install);
        if (this.dL > 0) {
            this.debug("setInstall " + install);
        }
    }

    public void setConfig(String s) {
        this.attributes.put("config", s);
    }

    public void setModulesFile(String mf) {
        this.modulesFile = mf;
    }

    public void setSandbox(boolean b) {
        this.attributes.put("sandbox", "true");
    }

    public void setJkconf(boolean b) {
        this.attributes.put("jkconf", "true");
        this.nostart = true;
    }

    public void setStart(boolean b) {
    }

    public void setEstart(boolean b) {
        this.debug("Using default embedded config ");
        this.serverXml = false;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setAjpPort(int port) {
        this.ajpPort = port;
    }

    public void setRun(boolean b) {
        this.setStart(true);
    }

    public void setHelp(boolean b) {
        this.help = b;
    }

    public void setProperty(String name, String v) {
        if (name.equals("home")) {
            this.setHome(v);
        }
        if (name.equals("install")) {
            this.setInstall(v);
        }
        if (name.equals("sandbox")) {
            this.setSandbox(true);
        }
        this.attributes.put(name, v);
    }

    public void setAttribute(String name, Object v) {
        if (name.equals("parentClassLoader")) {
            this.setParentClassLoader((ClassLoader)v);
        }
        if (name.equals("commonClassLoader")) {
            this.setCommonClassLoader((ClassLoader)v);
        }
        if (name.equals("args")) {
            this.setArgs((String[])v);
        }
        if (name.equals("commonClassPath")) {
            this.setCommonClassPath((URL[])v);
        }
        if (v == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, v);
        }
    }

    public void addProperty(Property prop) {
    }

    public void setApplication(Object app) {
        this.application = app;
    }

    public Object getApplication() {
        return this.application;
    }

    public int addModule(BaseInterceptor ri) throws TomcatException {
        if (ri == null) {
            return -1;
        }
        if (this.dL > 20) {
            this.debug("addModule " + ri.getClass().getName());
        }
        if (ri.getClass().getName().indexOf("Xml") < 0) {
            ri.setDebug(this.dL);
        }
        this.modules.addElement(ri);
        return this.modules.size() - 1;
    }

    public int addModule(String className) throws TomcatException {
        BaseInterceptor bi = this.createModule(className);
        if (bi == null) {
            throw new TomcatException("module not found " + className);
        }
        return this.addModule(bi);
    }

    public int findModule(String className, int startPos) {
        for (int i = startPos; i < this.modules.size(); ++i) {
            Object o = this.modules.elementAt(i);
            if (!className.equals(o.getClass().getName())) continue;
            return i;
        }
        return -1;
    }

    public void setModuleProperty(int id, String name, String value) throws TomcatException {
        Object o = this.modules.elementAt(id);
        if (this.dL > 0) {
            this.debug("setModuleProperty " + o.getClass().getName() + " " + name + " " + value);
        }
        IntrospectionUtils.setProperty(o, (String)name, (String)value);
    }

    public void addServerXmlModules() throws TomcatException {
        String conf = (String)this.attributes.get("config");
        this.addModule("org.apache.tomcat.modules.config.PathSetter");
        int mid = this.addModule("org.apache.tomcat.modules.config.ServerXmlReader");
        if (null != conf) {
            if (this.dL > 0) {
                this.debug("Using config file " + conf);
            }
            this.setModuleProperty(mid, "config", conf);
        }
        if (null != this.modulesFile) {
            if (this.dL > 0) {
                this.debug("Using modules file " + this.modulesFile);
            }
            this.setModuleProperty(mid, "moduleConfig", this.modulesFile);
        }
    }

    public void addDefaultModules() throws TomcatException {
        if (this.serverXml) {
            this.addServerXmlModules();
            return;
        }
        if (this.dL > 0) {
            int mid = this.addModule(LOG_EVENTS_MODULE);
            this.setModuleProperty(mid, "enabled", "true");
        }
        for (int i = 0; i < this.moduleSet1.length; ++i) {
            this.addModule(this.moduleSet1[i]);
        }
    }

    public void addAutoDeploy() throws TomcatException {
        if (this.serverXml) {
            return;
        }
        for (int i = 0; i < this.moduleSetAD.length; ++i) {
            this.addModule(this.moduleSetAD[i]);
        }
    }

    public Context addContext(String ctxPath, URL docRoot, String[] hosts) throws TomcatException {
        if ("ROOT".equals(ctxPath)) {
            ctxPath = "";
        }
        if (this.dL > 0) {
            this.debug("add context \"" + hosts[0] + ":" + ctxPath + "\" " + docRoot);
        }
        this.autoDeploy = false;
        if (!this.initialized) {
            this.initContextManager();
        }
        if (!"file".equals(docRoot.getProtocol())) {
            this.debug("addContext() invalid docRoot: " + docRoot);
            throw new RuntimeException("Invalid docRoot " + docRoot);
        }
        try {
            Context ctx = this.contextM.createContext();
            ctx.setDebug(this.dL);
            ctx.setContextManager(this.contextM);
            ctx.setPath(ctxPath);
            ctx.setDocBase(docRoot.getFile());
            if (hosts != null && hosts.length > 0) {
                ctx.setHost(hosts[0]);
                for (int i = 1; i > hosts.length; ++i) {
                    ctx.addHostAlias(hosts[i]);
                }
            }
            this.contextM.addContext(ctx);
            ctx.init();
            return ctx;
        }
        catch (Exception ex) {
            this.debug("exception adding context " + ctxPath + "/" + docRoot, ex);
            return null;
        }
    }

    public Context getContext(String host, String cpath) {
        Enumeration ctxE = this.contextM.getContexts();
        while (ctxE.hasMoreElements()) {
            Context ctx = (Context)ctxE.nextElement();
            if (!ctx.getPath().equals(cpath)) continue;
            if (ctx.getHost() == null) {
                return ctx;
            }
            if (host == null) {
                return ctx;
            }
            if (ctx.getHost().equals(host)) {
                return ctx;
            }
            Enumeration aliases = ctx.getHostAliases();
            while (aliases.hasMoreElements()) {
                if (!host.equals((String)aliases.nextElement())) continue;
                return ctx;
            }
        }
        return null;
    }

    public void initContextManager() throws TomcatException {
        if (this.initialized) {
            return;
        }
        if (this.installDir == null) {
            this.installDir = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"tomcat.home", (String)"tomcat.jar");
            if (this.dL > 0) {
                this.debug("Guessed installDir " + this.installDir);
            }
        }
        if (this.home == null) {
            this.home = System.getProperty("tomcat.home");
            if (this.home == null) {
                this.home = this.installDir;
            }
            if (this.dL > 0) {
                this.debug("Using homeDir " + this.installDir);
            }
        }
        this.contextM.setInstallDir(this.installDir);
        this.contextM.setHome(this.home);
        try {
            this.setTomcatProperties();
            this.initClassLoaders();
            jdk11Compat.setContextClassLoader(this.containerCL);
            if (this.modules.size() == 0) {
                this.addDefaultModules();
            }
            if (!this.serverXml) {
                if (this.attributes.get("sandbox") != null) {
                    this.addModule(POLICY_MODULE);
                }
                if (this.autoDeploy) {
                    this.addAutoDeploy();
                }
                if (this.defaultConnectors) {
                    this.addDefaultConnectors();
                }
            }
            this.beforeAddInterceptors();
            for (int i = 0; i < this.modules.size(); ++i) {
                this.contextM.addInterceptor((BaseInterceptor)this.modules.elementAt(i));
            }
            if (this.serverXml && this.modules.size() == this.contextM.getContainer().getInterceptors().length) {
                this.debug("No configuration found.");
                this.debug("The modules and/or server configuration files are missing.");
                return;
            }
            this.contextM.init();
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            this.debug("exception initializing ContextManager", ex);
            throw new TomcatException("EmbededTomcat.initContextManager", ex);
        }
        if (this.dL > 0) {
            this.debug("ContextManager initialized");
        }
        this.initialized = true;
    }

    public void start() throws TomcatException {
        if (this.nostart) {
            this.debug("Tomcat will not start  - configuration only mode ");
            this.contextM.shutdown();
            return;
        }
        long time3 = System.currentTimeMillis();
        this.contextM.start();
        long time4 = System.currentTimeMillis();
        this.debug("Startup time " + (time4 - time3));
        if (this.blocking) {
            this.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void await() {
        while (this.blocking) {
            EmbededTomcat embededTomcat = this;
            synchronized (embededTomcat) {
                try {
                    this.wait();
                    this.blocking = false;
                }
                catch (Exception ex) {
                    this.contextM.log("Error in await", ex);
                }
            }
        }
    }

    public void shutdown() throws TomcatException {
        this.contextM.shutdown();
        if (this.blocking) {
            this.notify();
        }
    }

    public void stop() throws TomcatException {
        this.contextM.stop();
        if (this.blocking) {
            this.notify();
        }
    }

    public int addEndpoint(int port, InetAddress addr, String hostname) throws TomcatException {
        if (this.modules.size() == 0) {
            this.addDefaultModules();
        }
        this.defaultConnectors = false;
        if (this.dL > 0) {
            this.debug("addConnector " + port + " " + addr + " " + hostname);
        }
        int mid = this.addModule("org.apache.tomcat.modules.server.Http10Interceptor");
        this.setModuleProperty(mid, "port", Integer.toString(port));
        if (addr != null) {
            this.setModuleProperty(mid, "address", addr.getHostAddress());
        }
        if (hostname != null) {
            this.setModuleProperty(mid, "hostName", hostname);
        }
        return mid;
    }

    public int addAjpEndpoint(int port, InetAddress addr, String hostname) throws TomcatException {
        if (this.modules.size() == 0) {
            this.addDefaultModules();
        }
        this.defaultConnectors = false;
        if (this.dL > 0) {
            this.debug("addAjp12Connector " + port + " " + addr + " " + hostname);
        }
        int mid = this.addModule("org.apache.tomcat.modules.server.Ajp12Interceptor");
        this.setModuleProperty(mid, "port", Integer.toString(port));
        if (addr != null) {
            this.setModuleProperty(mid, "address", addr.getHostAddress());
        }
        if (hostname != null) {
            this.setModuleProperty(mid, "hostName", hostname);
        }
        return mid;
    }

    public int addSecureEndpoint(int port, InetAddress addr, String hostname, String keyFile, String keyPass) throws TomcatException {
        if (this.modules.size() == 0) {
            this.addDefaultModules();
        }
        int mid = this.addEndpoint(port, addr, hostname);
        this.setModuleProperty(mid, "socketFactory", "org.apache.tomcat.util.net.SSLSocketFactory");
        this.setModuleProperty(mid, "secure", "true");
        return mid;
    }

    public void addDefaultConnectors() throws TomcatException {
        if (this.httpPort > 0) {
            this.addEndpoint(this.httpPort, null, null);
        }
        if (this.ajpPort > 0) {
            this.addAjpEndpoint(this.ajpPort, null, null);
        }
    }

    public void execute() throws Exception {
        final EmbededTomcat et = this;
        jdk11Compat.doPrivileged(new Action(){

            public Object run() throws Exception {
                et.execute1();
                return null;
            }
        }, jdk11Compat.getAccessControlContext());
    }

    public void execute1() throws Exception {
        if (this.args != null) {
            this.processArgs(this.args);
        }
        if (this.help) {
            EmbededTomcat.printUsage();
            return;
        }
        if (!this.initialized) {
            long time1 = System.currentTimeMillis();
            this.initContextManager();
            long time2 = System.currentTimeMillis();
            this.debug("Init time " + (time2 - time1));
        }
        if (this.initialized) {
            this.start();
        }
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public boolean processArgs(String[] args) {
        try {
            if (this.dL > 0) {
                this.debug("Processing args ");
                for (int i = 0; i < args.length; ++i) {
                    this.debug(args[i]);
                }
            }
            return IntrospectionUtils.processArgs((Object)this, (String[])args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        EmbededTomcat tomcat = new EmbededTomcat();
        try {
            tomcat.setArgs(args);
            tomcat.execute();
        }
        catch (Exception ex) {
            tomcat.debug("main", ex);
            System.exit(1);
        }
    }

    public void cleanupPrevious() {
    }

    private void setTomcatProperties() throws TomcatException {
        Enumeration attN = this.attributes.keys();
        while (attN.hasMoreElements()) {
            String k = (String)attN.nextElement();
            Object o = this.attributes.get(k);
            if (o instanceof String) {
                IntrospectionUtils.setProperty((Object)this.contextM, (String)k, (String)((String)o));
                if (this.dL <= 0) continue;
                this.debug("Set tomcat property " + k + " " + o);
                continue;
            }
            this.contextM.setNote(k, o);
        }
    }

    public void setParentClassLoader(ClassLoader cl) {
        this.parentCL = cl;
    }

    public void setCommonClassLoader(ClassLoader cl) {
        this.commonCL = cl;
    }

    public void setCommonClassPath(URL[] cp) {
        this.commonCP = cp;
    }

    public void setAppsClassLoader(ClassLoader cl) {
        this.appsCL = cl;
    }

    public void setContainerClassLoader(ClassLoader cl) {
        this.containerCL = cl;
    }

    public ClassLoader getContainerClassLoader() {
        return this.containerCL;
    }

    public void initClassLoaders() throws IOException, MalformedURLException {
        if (this.dL > 0) {
            this.debug("Init class loaders " + this.noClassLoaders);
        }
        if (this.noClassLoaders) {
            this.commonCL = this.getClass().getClassLoader();
            if (this.commonCL == null) {
                this.commonCL = jdk11Compat.newClassLoaderInstance(new URL[0], null);
            }
            this.parentCL = this.commonCL;
            this.containerCL = this.commonCL;
            this.modulesCL = this.commonCL;
            if (this.dL > 0) {
                this.debug("All class loaders " + this.commonCL);
            }
            this.contextM.setParentLoader(this.parentCL);
            this.contextM.setCommonLoader(this.modulesCL);
            this.contextM.setContainerLoader(this.containerCL);
            this.contextM.setAppsLoader(this.appsCL);
            return;
        }
        if (this.parentCL == null && this.dL > 0) {
            this.debug("Default parent loader: null");
        }
        String prefix = this.installDir + File.separator + "lib" + File.separator;
        if (this.commonCL == null) {
            this.debug("Default commonCL ");
            this.commonCL = this.getClass().getClassLoader();
        }
        this.modulesCP = this.getModulesCommonCP();
        if (this.modulesCP == null) {
            this.modulesCL = this.commonCL;
        } else {
            if (this.dL > 0) {
                IntrospectionUtils.displayClassPath((String)"Modules-common", (URL[])this.modulesCP);
            }
            this.modulesCL = jdk11Compat.newClassLoaderInstance(this.modulesCP, this.commonCL);
        }
        if (this.containerCL == null) {
            if (this.dL > 0) {
                this.debug("Dir : " + prefix + "container" + " " + PROPERTY_CONTAINER_LOADER);
            }
            this.containerCP = IntrospectionUtils.getClassPath((String)(prefix + "container"), null, (String)PROPERTY_CONTAINER_LOADER, (boolean)true);
            this.containerCP = this.addModulesContainerCP(this.containerCP);
            this.containerCL = jdk11Compat.newClassLoaderInstance(this.containerCP, this.modulesCL);
            if (this.dL > 0) {
                IntrospectionUtils.displayClassPath((String)"ContainerCP", (URL[])this.containerCP);
            }
        }
        if (this.appsCL == null) {
            this.appsCP = IntrospectionUtils.getClassPath((String)(prefix + "apps"), null, (String)PROPERTY_APPS_LOADER, (boolean)false);
            this.appsCL = jdk11Compat.newClassLoaderInstance(this.appsCP, this.modulesCL);
        }
        String cp = System.getProperty("tc_path_add");
        cp = IntrospectionUtils.classPathAdd((URL[])this.commonCP, (String)cp);
        if (this.modulesCP != null) {
            cp = IntrospectionUtils.classPathAdd((URL[])this.modulesCP, (String)cp);
        }
        if ((cp = IntrospectionUtils.classPathAdd((URL[])this.appsCP, (String)cp)) != null) {
            System.getProperties().put("tc_path_add", cp);
        }
        this.contextM.setParentLoader(this.parentCL);
        this.contextM.setCommonLoader(this.modulesCL);
        this.contextM.setContainerLoader(this.containerCL);
        this.contextM.setAppsLoader(this.appsCL);
    }

    protected URL[] getModulesCommonCP() {
        return this.findModulesCP("/WEB-INF/lib/common");
    }

    protected URL[] findModulesCP(String dir) {
        String prefix = this.installDir + File.separator + "modules" + File.separator;
        File f = new File(prefix);
        if (!f.exists()) {
            return null;
        }
        Vector<URL> jarsV = new Vector<URL>();
        String[] list = f.list();
        for (int i = 0; i < list.length; ++i) {
            URL url;
            File commonF = new File(f, list[i] + dir);
            if (!commonF.exists()) continue;
            IntrospectionUtils.addToClassPath(jarsV, (String)commonF.getAbsolutePath());
            File classes = new File(commonF, "classes");
            if (!classes.exists() || (url = IntrospectionUtils.getURL((String)commonF.getAbsolutePath(), (String)"classes")) == null) continue;
            jarsV.addElement(url);
        }
        if (jarsV.size() == 0) {
            return null;
        }
        return IntrospectionUtils.getClassPath(jarsV);
    }

    protected URL[] addModulesContainerCP(URL[] orig) {
        URL[] mCP = this.findModulesCP("/WEB-INF/lib/container");
        if (mCP == null || mCP.length == 0) {
            return orig;
        }
        URL[] result = new URL[orig.length + mCP.length];
        System.arraycopy(mCP, 0, result, 0, mCP.length);
        System.arraycopy(orig, 0, result, 0, orig.length);
        return result;
    }

    public void debug(String s) {
        this.debug(s, null);
    }

    public void debug(String s, Throwable t) {
        System.out.println("EmbededTomcat: " + s);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public BaseInterceptor createModule(String classN) {
        try {
            Class<?> c = this.containerCL.loadClass(classN);
            return (BaseInterceptor)c.newInstance();
        }
        catch (Exception ex) {
            this.debug("error creating module " + classN, ex);
            return null;
        }
    }

    public void setSecurity(boolean b) {
        this.setSandbox(true);
    }

    public void setH(String s) {
        this.setHome(s);
    }

    public void setI(String s) {
        this.setInstall(s);
    }

    public void setF(String s) {
        this.setConfig(s);
    }

    public void addInterceptor(BaseInterceptor ri) throws TomcatException {
        this.addModule(ri);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void addApplicationAdapter(BaseInterceptor adapter) throws TomcatException {
        if (this.modules.size() == 0) {
            this.addDefaultModules();
        }
        this.addModule(adapter);
    }

    public static void printUsage() {
        PrintStream out = System.out;
        out.println("Usage: java org.apache.tomcat.startup.EmbeddedTomcat {options}");
        out.println("  Options are:");
        out.println("    -config file (or -f file)  Use this file instead of server.xml");
        out.println("    -debug level               Sets specified debug level on EmbeddedTomcat,");
        out.println("                                   ContextManager, \"Xml\" modules, and contexts");
        out.println("    -help                      Show this usage report");
        out.println("    -home dir                  Use this directory as tomcat.home");
        out.println("    -install dir (or -i dir)   Use this directory as tomcat.install");
        out.println("    -jkconf                    Write mod_jk configuration files, without");
        out.println("                                   starting Tomcat");
        out.println("    -sandbox                   Enable security manager (includes java.policy)");
        out.println("    -estart                    Starts Tomcat without reading server.xml");
        out.println("    -httpPort                  HTTP port to use in 'estart' mode");
        out.println("    -ajpPort                   AJP port to use in 'estart' mode");
        out.println("Note: the '-' on the options is optional.");
        out.println();
    }

    protected void beforeAddInterceptors() throws TomcatException {
    }
}

