/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.jython;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.jython.JythonRunnerMBean;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JythonRunner
implements JythonRunnerMBean,
NotificationListener,
MBeanRegistration {
    private MBeanServer server = null;
    private ObjectName targetMBeanName;
    private ObjectName objectName;
    private String notificationName;
    private boolean useText = true;
    private boolean useCache = false;
    private String scriptText;
    private URL scriptFile;
    private PyCode cache = null;
    private static PythonInterpreter interpreter;
    static /* synthetic */ Class class$mx4j$tools$jython$JythonRunner;

    public void handleNotification(Notification notification, Object handback) {
        if (this.notificationName != null && !notification.getType().equals(this.notificationName)) {
            return;
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Notification " + notification + " hit, sending message");
        }
        this.runScript();
    }

    private Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public void runScript() {
        PythonInterpreter interp = JythonRunner.getPythonInterpreter();
        interp.set("server", (Object)this.server);
        String script = null;
        if (this.useText) {
            script = this.scriptText;
        } else {
            try {
                script = JythonRunner.loadStream(this.scriptFile.openStream());
            }
            catch (IOException e) {
                Logger log = this.getLogger();
                log.error("Exception during url opening", e);
            }
        }
        interp.exec(script);
    }

    public static PythonInterpreter getPythonInterpreter() {
        block2: {
            if (interpreter != null) break block2;
            interpreter = new PythonInterpreter();
            PySystemState sys = Py.getSystemState();
            PySystemState.add_package((String)"javax.management");
            PySystemState.add_package((String)"javax.management.loading");
            PySystemState.add_package((String)"javax.management.modelmbean");
            PySystemState.add_package((String)"javax.management.monitor");
            PySystemState.add_package((String)"javax.management.relation");
            PySystemState.add_package((String)"javax.management.timer");
            try {
                String script = JythonRunner.loadStream((class$mx4j$tools$jython$JythonRunner == null ? (class$mx4j$tools$jython$JythonRunner = JythonRunner.class$("mx4j.tools.jython.JythonRunner")) : class$mx4j$tools$jython$JythonRunner).getClassLoader().getResourceAsStream("mx4j/tools/jython/mx4j.py"));
                interpreter.exec(script);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return interpreter;
    }

    protected static String loadStream(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String getNotificationType() {
        return this.notificationName;
    }

    public void setNotificationType(String notificationName) {
        this.notificationName = notificationName;
    }

    public void setObservedObject(ObjectName targetMBeanName) {
        this.targetMBeanName = targetMBeanName;
        this.registerListener();
    }

    public ObjectName getObservedObject() {
        return this.targetMBeanName;
    }

    public boolean getUseText() {
        return this.useText;
    }

    public void setScript(String text) {
        this.scriptText = text;
        this.useText = true;
    }

    public String getScript() {
        return this.scriptText;
    }

    public URL getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(URL file) {
        this.scriptFile = file;
        this.useText = false;
    }

    public boolean getCacheScript() {
        return this.useCache;
    }

    public void setCacheScript(boolean useCache) {
        this.useCache = useCache;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.unregisterListener();
    }

    public void postDeregister() {
    }

    protected void registerListener() {
        try {
            if (this.targetMBeanName != null && this.server.isInstanceOf(this.targetMBeanName, "javax.management.NotificationBroadcaster")) {
                this.server.addNotificationListener(this.targetMBeanName, this, (NotificationFilter)new MessageFilter(), null);
            }
        }
        catch (InstanceNotFoundException e) {
            Logger log = this.getLogger();
            log.error("Exception during notification registration", e);
        }
    }

    protected void unregisterListener() {
        try {
            if (this.targetMBeanName != null && this.server.isInstanceOf(this.targetMBeanName, "javax.management.NotificationBroadcaster")) {
                this.server.removeNotificationListener(this.targetMBeanName, this);
            }
        }
        catch (InstanceNotFoundException e) {
            Logger log = this.getLogger();
            log.error("Exception during notification unregistration", e);
        }
        catch (ListenerNotFoundException e) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MessageFilter
    implements NotificationFilter {
        private MessageFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            return JythonRunner.this.notificationName == null || notification.getType() != null && notification.getType().equals(JythonRunner.this.notificationName);
        }
    }
}

