/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.modules.server.JNIConnectionHandler;

public class JNIRequestAdapter
extends Request {
    JNIConnectionHandler h;
    long s;
    long l;

    public JNIRequestAdapter(ContextManager cm, JNIConnectionHandler h) {
        this.contextM = cm;
        this.h = h;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.available <= 0) {
            return 0;
        }
        int rc = 0;
        while (0 == rc) {
            rc = this.h.read(this.s, this.l, b, off, len);
            if (0 != rc) continue;
            Thread.currentThread();
            Thread.yield();
        }
        this.available -= rc;
        return rc;
    }

    protected void readNextRequest(long s, long l) throws IOException {
        String[] env = new String[15];
        int i = 0;
        this.s = s;
        this.l = l;
        for (i = 0; i < 12; ++i) {
            env[i] = null;
        }
        if (this.h.readEnvironment(s, l, env) > 0) {
            this.methodMB.setString(env[0]);
            this.uriMB.setString(env[1]);
            this.queryMB.setString(env[2]);
            this.remoteAddrMB.setString(env[3]);
            this.remoteHostMB.setString(env[4]);
            this.serverNameMB.setString(env[5]);
            this.serverPort = Integer.parseInt(env[6]);
            this.authType = env[7];
            this.remoteUser = env[8];
            this.schemeMB.setString(env[9]);
            this.protoMB.setString(env[10]);
            if (this.schemeMB.equalsIgnoreCase("https")) {
                if (null != env[12]) {
                    this.attributes.put("javax.servlet.request.X509Certificate", env[12]);
                }
                if (null != env[13]) {
                    this.attributes.put("javax.servlet.request.cipher_suite", env[13]);
                }
                if (null != env[14]) {
                    this.attributes.put("javax.servlet.request.ssl_session", env[14]);
                }
            }
        } else {
            throw new IOException("Error: JNI implementation error");
        }
        int nheaders = this.h.getNumberOfHeaders(s, l);
        if (nheaders > 0) {
            String[] names = new String[nheaders];
            String[] values = new String[nheaders];
            if (this.h.readHeaders(s, l, names, values) > 0) {
                for (i = 0; i < nheaders; ++i) {
                    this.headers.addValue(names[i]).setString(values[i]);
                }
            } else {
                throw new IOException("Error: JNI implementation error");
            }
        }
        String requestURI = this.uriMB.toString();
        int indexQ = requestURI.indexOf("?");
        int rLen = requestURI.length();
        if (indexQ > -1 && indexQ < rLen) {
            this.queryMB.setString(requestURI.substring(indexQ + 1, requestURI.length()));
            this.uriMB.setString(requestURI.substring(0, indexQ));
        }
    }
}

