/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.File;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.server.JNIEndpoint;
import org.apache.tomcat.modules.server.JNIRequestAdapter;
import org.apache.tomcat.modules.server.JNIResponseAdapter;

public class JNIConnectionHandler
extends BaseInterceptor
implements JNIEndpoint.JniHandler {
    boolean nativeLibLoaded = false;
    String lib;
    boolean exitOnError = true;
    JNIEndpoint ep = null;
    static Vector pool = new Vector();
    static boolean reuse = true;

    public void setNativeLibrary(String lib) {
        this.lib = lib;
    }

    public void setExitIfNoLib(boolean b) {
        this.exitOnError = b;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.ep = JNIEndpoint.getEndpoint();
        if (this.ep == null) {
            return;
        }
        super.engineInit(cm);
        if (!this.nativeLibLoaded) {
            this.initLibrary();
            if (!this.nativeLibLoaded && this.exitOnError) {
                System.exit(2);
            }
        }
        try {
            this.ep.setConnectionHandler(this);
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        if (this.ep == null) {
            return;
        }
        try {
            this.ep.setConnectionHandler(null);
        }
        catch (Exception ex) {
            throw new TomcatException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConnection(long s, long l) {
        JNIConnectionHandler jNIConnectionHandler;
        JNIRequestAdapter reqA = null;
        JNIResponseAdapter resA = null;
        try {
            if (reuse) {
                jNIConnectionHandler = this;
                synchronized (jNIConnectionHandler) {
                    if (pool.size() == 0) {
                        reqA = new JNIRequestAdapter(this.cm, this);
                        resA = new JNIResponseAdapter(this);
                        this.cm.initRequest((Request)reqA, (Response)resA);
                    } else {
                        reqA = (JNIRequestAdapter)((Object)pool.lastElement());
                        resA = (JNIResponseAdapter)reqA.getResponse();
                        pool.removeElement((Object)reqA);
                    }
                }
                reqA.recycle();
                resA.recycle();
            } else {
                reqA = new JNIRequestAdapter(this.cm, this);
                resA = new JNIResponseAdapter(this);
                this.cm.initRequest((Request)reqA, (Response)resA);
            }
            resA.setRequestAttr(s, l);
            reqA.readNextRequest(s, l);
            if (resA.getStatus() >= 400) {
                resA.finish();
                return;
            }
            this.cm.service((Request)reqA, (Response)resA);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (reuse) {
            jNIConnectionHandler = this;
            synchronized (jNIConnectionHandler) {
                pool.addElement(reqA);
            }
        }
    }

    public void shutdown() {
        try {
            this.cm.log("Shutdown from JNI");
            this.cm.shutdown();
        }
        catch (Throwable t) {
            this.cm.log("Exception while JNI shutdown", t);
        }
    }

    private void initLibrary() throws TomcatException {
        File libF;
        block10: {
            if (this.ep == null && this.debug > 0) {
                this.log("JNI connector disabled, endpoint is null");
            }
            if (this.lib == null) {
                this.lib = "jni_connect.";
                String os = System.getProperty("os.name").toLowerCase();
                this.lib = os.indexOf("windows") >= 0 ? this.lib + "dll" : (os.indexOf("netware") >= 0 ? this.lib + "nlm" : this.lib + "so");
            }
            this.log("JNI mode detected, try to load library " + this.lib);
            libF = new File(this.lib);
            if (!libF.isAbsolute()) {
                try {
                    System.loadLibrary(this.lib);
                    this.nativeLibLoaded = true;
                    System.out.println("Library " + this.lib + " was loaded from the lib path");
                    return;
                }
                catch (UnsatisfiedLinkError usl) {
                    System.err.println("loadLibrary(" + this.lib + ") didn't find the library, try with full path");
                    if (this.debug <= 0) break block10;
                    usl.printStackTrace();
                }
            }
        }
        if (!libF.isAbsolute()) {
            File f1 = new File(this.cm.getInstallDir());
            File f2 = new File(f1, "bin" + File.separator + "native");
            libF = new File(f2, this.lib);
        }
        if (!libF.exists()) {
            throw new TomcatException("Native library doesn't exist " + libF);
        }
        try {
            System.load(libF.getAbsolutePath());
            this.nativeLibLoaded = true;
            System.out.println("Library " + libF.getAbsolutePath() + " loaded");
            return;
        }
        catch (UnsatisfiedLinkError usl) {
            System.err.println("Failed to load() " + libF.getAbsolutePath());
            if (this.debug > 0) {
                usl.printStackTrace();
            }
            return;
        }
    }

    native int readEnvironment(long var1, long var3, String[] var5);

    native int getNumberOfHeaders(long var1, long var3);

    native int readHeaders(long var1, long var3, String[] var5, String[] var6);

    native int read(long var1, long var3, byte[] var5, int var6, int var7);

    native int startReasponse(long var1, long var3, int var5, String var6, String[] var7, String[] var8, int var9);

    native int write(long var1, long var3, byte[] var5, int var6, int var7);
}

