/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.modules.server.Http10;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.SSLSupport;

class HttpRequest
extends Request {
    Http10 http = new Http10();
    private boolean moreRequests = false;
    Socket socket;
    SSLSupport sslSupport = null;

    public HttpRequest() {
        this.remoteAddrMB.recycle();
        this.remoteHostMB.recycle();
    }

    public void recycle() {
        super.recycle();
        if (this.http != null) {
            this.http.recycle();
        }
        this.remoteAddrMB.recycle();
        this.remoteHostMB.recycle();
        this.sslSupport = null;
    }

    public void setSocket(Socket socket) throws IOException {
        this.http.setSocket(socket);
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int doRead() throws IOException {
        if (this.available == 0) {
            return -1;
        }
        if (this.available != -1) {
            --this.available;
        }
        return this.http.doRead();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.available == 0) {
            return -1;
        }
        int rd = this.http.doRead(b, off, len);
        if (rd == -1) {
            this.available = 0;
            return -1;
        }
        if (this.available != -1) {
            this.available -= rd;
        }
        return rd;
    }

    public void readNextRequest(Response response) throws IOException {
        int status = this.http.processRequestLine(this.methodMB, this.uriMB, this.queryMB, this.protoMB);
        if (status > 200) {
            response.setStatus(status);
            return;
        }
        if (!this.protoMB.equals("") && (status = this.http.readHeaders(this.headers)) > 200) {
            response.setStatus(status);
            return;
        }
        this.moreRequests = false;
    }

    public MessageBytes remoteAddr() {
        if (this.remoteAddrMB.isNull()) {
            this.remoteAddrMB.setString(this.socket.getInetAddress().getHostAddress());
        }
        return this.remoteAddrMB;
    }

    public MessageBytes remoteHost() {
        if (this.remoteHostMB.isNull()) {
            this.remoteHostMB.setString(this.socket.getInetAddress().getHostName());
        }
        return this.remoteHostMB;
    }

    public String getLocalHost() {
        InetAddress localAddress = this.socket.getLocalAddress();
        this.localHost = localAddress.getHostName();
        return this.localHost;
    }

    public MessageBytes serverName() {
        if (!this.serverNameMB.isNull()) {
            return this.serverNameMB;
        }
        this.parseHostHeader();
        return this.serverNameMB;
    }

    public int getServerPort() {
        if (this.serverPort != -1) {
            return this.serverPort;
        }
        this.parseHostHeader();
        return this.serverPort;
    }

    protected void parseHostHeader() {
        MessageBytes hH = this.getMimeHeaders().getValue("host");
        this.serverPort = this.sslSupport != null ? 443 : 80;
        if (hH != null) {
            String hostHeader = hH.toString();
            int i = hostHeader.indexOf(58);
            if (i > -1) {
                this.serverNameMB.setString(hostHeader.substring(0, i));
                hostHeader = hostHeader.substring(i + 1);
                try {
                    this.serverPort = Integer.parseInt(hostHeader);
                }
                catch (NumberFormatException nfe) {}
            } else {
                this.serverNameMB.setString(hostHeader);
            }
            return;
        }
        this.serverPort = this.socket.getLocalPort();
        if (this.localHost != null) {
            this.serverNameMB.setString(this.localHost);
        }
        this.serverNameMB.setString(this.getLocalHost());
    }

    void setSSLSupport(SSLSupport s) {
        this.sslSupport = s;
    }
}

