/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.modules.server.HttpRequest;
import org.apache.tomcat.modules.server.HttpResponse;
import org.apache.tomcat.modules.server.PoolTcpConnector;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;

public class Http10Interceptor
extends PoolTcpConnector
implements TcpConnectionHandler {
    private int timeout = 300000;
    private String reportedname;
    private int socketCloseDelay = -1;
    private static final int GET_OTHER = 0;
    private static final int GET_CIPHER_SUITE = 1;
    private static final int GET_PEER_CERTIFICATE_CHAIN = 2;

    public Http10Interceptor() {
        super.setSoLinger(100);
        this.setPort(8080);
    }

    protected void localInit() throws Exception {
        this.ep.setConnectionHandler((TcpConnectionHandler)this);
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts * 1000;
    }

    public void setReportedname(String reportedName) {
        this.reportedname = reportedName;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
    }

    public void setProperty(String prop, String value) {
        this.setAttribute(prop, value);
    }

    public void setServer(Object o) {
        this.cm = (ContextManager)o;
    }

    public Object[] init() {
        Object[] thData = new Object[3];
        HttpRequest reqA = new HttpRequest();
        HttpResponse resA = new HttpResponse();
        if (this.reportedname != null) {
            resA.setReported(this.reportedname);
        }
        this.cm.initRequest((Request)reqA, (Response)resA);
        thData[0] = reqA;
        thData[1] = resA;
        thData[2] = null;
        return thData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processConnection(TcpConnection connection, Object[] thData) {
        block25: {
            Socket socket = null;
            HttpRequest reqA = null;
            HttpResponse resA = null;
            reqA = (HttpRequest)((Object)thData[0]);
            resA = (HttpResponse)((Object)thData[1]);
            socket = connection.getSocket();
            socket.setSoTimeout(this.timeout);
            reqA.setSocket(socket);
            resA.setSocket(socket);
            reqA.readNextRequest(resA);
            if (this.secure) {
                reqA.scheme().setString("https");
                if (this.sslImplementation != null) {
                    reqA.setSSLSupport(this.sslImplementation.getSSLSupport(socket));
                }
            }
            this.cm.service((Request)reqA, (Response)resA);
            if (this.socketCloseDelay >= 0) {
                try {
                    Thread.sleep(this.socketCloseDelay);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            TcpConnection.shutdownInput((Socket)socket);
            Object var8_11 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
                break block25;
            }
            catch (IOException e2) {}
            break block25;
            {
                catch (SocketException e) {
                    this.log("SocketException reading request, ignored", null, 3);
                    this.log("SocketException reading request:", e, 4);
                    Object var8_12 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block25;
                    }
                    catch (IOException e2) {}
                    break block25;
                }
                catch (InterruptedIOException ioe) {
                    ioe.printStackTrace();
                    this.log("Timeout reading request, aborting", ioe, 1);
                    Object var8_13 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block25;
                    }
                    catch (IOException e2) {}
                    break block25;
                }
                catch (IOException e) {
                    this.log("IOException reading request, ignored", null, 3);
                    this.log("IOException reading request:", e, 4);
                    Object var8_14 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block25;
                    }
                    catch (IOException e2) {}
                    break block25;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.log("Error reading request, ignored", e, 1);
                    Object var8_15 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block25;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public Object getInfo(Context ctx, Request request, int id, String key) {
        if (key != null) {
            int infoRequested = 0;
            if (key.equals("javax.servlet.request.cipher_suite")) {
                infoRequested = 1;
            } else if (key.equals("javax.servlet.request.X509Certificate")) {
                infoRequested = 2;
            }
            if (infoRequested != 0) {
                HttpRequest httpReq;
                try {
                    httpReq = (HttpRequest)request;
                }
                catch (ClassCastException e) {
                    return null;
                }
                if (httpReq != null && httpReq.sslSupport != null) {
                    try {
                        switch (infoRequested) {
                            case 1: {
                                return httpReq.sslSupport.getCipherSuite();
                            }
                            case 2: {
                                return httpReq.sslSupport.getPeerCertificateChain();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log("Exception getting SSL attribute " + key, e, 2);
                        return null;
                    }
                }
            }
        }
        return super.getInfo(ctx, request, id, key);
    }
}

