/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

public class Ajp13Packet {
    byte[] buff;
    int pos;
    OutputBuffer ob;
    int len;
    public static final String DEFAULT_CHAR_ENCODING = "ISO-8859-1";
    private static final int dL = 0;

    public Ajp13Packet(int size) {
        this.buff = new byte[size];
    }

    public Ajp13Packet(byte[] b) {
        this.buff = b;
    }

    public Ajp13Packet(OutputBuffer ob) {
        this.ob = ob;
        this.buff = ob.getBuffer();
    }

    public byte[] getBuff() {
        return this.buff;
    }

    public int getLen() {
        return this.len;
    }

    public int getByteOff() {
        return this.pos;
    }

    public void setByteOff(int c) {
        this.pos = c;
    }

    public int checkIn() {
        this.pos = 0;
        int mark = this.getInt();
        if (mark != 4660) {
            System.err.println("Ajp13Packet: invalid packet header : " + mark);
            return -1;
        }
        this.len = this.getInt();
        return this.len;
    }

    public void reset() {
        this.len = 4;
        this.pos = 4;
        this.buff[0] = 65;
        this.buff[1] = 66;
    }

    public void end() {
        this.len = this.pos;
        this.setInt(2, this.len - 4);
    }

    private void setInt(int bPos, int val) {
        this.buff[bPos] = (byte)(val >>> 8 & 0xFF);
        this.buff[bPos + 1] = (byte)(val & 0xFF);
    }

    public void appendInt(int val) {
        this.setInt(this.pos, val);
        this.pos += 2;
    }

    public void appendByte(byte val) {
        this.buff[this.pos++] = val;
    }

    public void appendBool(boolean val) {
        this.buff[this.pos++] = (byte)(val ? 1 : 0);
    }

    public void appendString(String str) {
        if (str == null) {
            this.setInt(this.pos, 0);
            this.buff[this.pos + 2] = 0;
            this.pos += 3;
            return;
        }
        int strStart = this.pos;
        this.ob.setByteOff(this.pos + 2);
        try {
            this.ob.write(str);
            this.ob.flushChars();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int strEnd = this.ob.getByteOff();
        this.buff[strEnd] = 0;
        int strLen = strEnd - strStart;
        this.setInt(this.pos, strEnd - strStart);
        this.pos += strLen + 3;
    }

    public void appendBytes(byte[] b, int off, int numBytes) {
        this.appendInt(numBytes);
        if (this.pos + numBytes >= this.buff.length) {
            System.out.println("Buffer overflow " + this.buff.length + " " + this.pos + " " + numBytes);
        }
        System.arraycopy(b, off, this.buff, this.pos, numBytes);
        this.buff[this.pos + numBytes] = 0;
        this.pos += numBytes + 1;
    }

    public int getInt() {
        int result = this.peekInt();
        this.pos += 2;
        return result;
    }

    public int peekInt() {
        int b1 = this.buff[this.pos] & 0xFF;
        int b2 = this.buff[this.pos + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public byte getByte() {
        byte res = this.buff[this.pos];
        ++this.pos;
        return res;
    }

    public byte peekByte() {
        return this.buff[this.pos];
    }

    public boolean getBool() {
        return this.getByte() == 1;
    }

    public void getMessageBytes(MessageBytes mb) {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            mb.setString(null);
            return;
        }
        mb.setBytes(this.buff, this.pos, length);
        this.pos += length;
        ++this.pos;
    }

    public MessageBytes addHeader(MimeHeaders headers) {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            return null;
        }
        MessageBytes vMB = headers.addValue(this.buff, this.pos, length);
        this.pos += length;
        ++this.pos;
        return vMB;
    }

    public String getString() throws UnsupportedEncodingException {
        int length = this.getInt();
        if (length == 65535 || length == -1) {
            return null;
        }
        String s = new String(this.buff, this.pos, length, DEFAULT_CHAR_ENCODING);
        this.pos += length;
        ++this.pos;
        return s;
    }

    public int getBytes(byte[] dest) {
        int length = this.getInt();
        if (length > this.buff.length) {
            System.out.println("XXX Assert failed, buff too small ");
        }
        if (length == 65535 || length == -1) {
            System.out.println("null string " + length);
            return 0;
        }
        System.arraycopy(this.buff, this.pos, dest, 0, length);
        this.pos += length;
        ++this.pos;
        return length;
    }

    private String hex(int x) {
        String h = Integer.toHexString(x);
        if (h.length() == 1) {
            h = "0" + h;
        }
        return h.substring(h.length() - 2);
    }

    private void hexLine(int start, StringBuffer sb) {
        int i;
        int pkgEnd = this.len + 4;
        if (pkgEnd > this.buff.length) {
            pkgEnd = this.buff.length;
        }
        for (i = start; i < start + 16; ++i) {
            if (i < pkgEnd) {
                sb.append(this.hex(this.buff[i]) + " ");
                continue;
            }
            sb.append("   ");
        }
        sb.append(" | ");
        for (i = start; i < start + 16 && i < pkgEnd; ++i) {
            char c = (char)this.buff[i];
            if (!Character.isISOControl(c) && Character.isDefined(c)) {
                sb.append(c);
                continue;
            }
            if (c == ' ') {
                sb.append(c);
                continue;
            }
            sb.append(".");
        }
        sb.append("\n");
    }

    public void dump(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this).append("/").append(Thread.currentThread()).append("\n");
        sb.append(msg + ": " + this.buff + " " + this.pos + "/" + (this.len + 4) + "\n");
        for (int j = 0; j < this.len + 4; j += 16) {
            this.hexLine(j, sb);
        }
        System.out.println(sb);
    }

    private void d(String s) {
        System.err.println("Ajp13Packet: " + s);
    }
}

