/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Principal;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.modules.server.Ajp13Packet;
import org.apache.tomcat.util.aaa.SimplePrincipal;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;

public class Ajp13 {
    public static final int MAX_PACKET_SIZE = 8192;
    public static final int H_SIZE = 4;
    public static final int MAX_READ_SIZE = 8186;
    public static final int MAX_SEND_SIZE = 8184;
    public static final byte JK_AJP13_FORWARD_REQUEST = 2;
    public static final byte JK_AJP13_SHUTDOWN = 7;
    public static final byte JK_AJP13_PING_REQUEST = 8;
    public static final int JK_AJP13_BAD_HEADER = -100;
    public static final int JK_AJP13_NO_HEADER = -101;
    public static final int JK_AJP13_COMM_CLOSED = -102;
    public static final int JK_AJP13_COMM_BROKEN = -103;
    public static final int JK_AJP13_BAD_BODY = -104;
    public static final int JK_AJP13_INCOMPLETE_BODY = -105;
    public static final byte JK_AJP13_SEND_BODY_CHUNK = 3;
    public static final byte JK_AJP13_SEND_HEADERS = 4;
    public static final byte JK_AJP13_END_RESPONSE = 5;
    public static final byte JK_AJP13_GET_BODY_CHUNK = 6;
    public static final byte JK_AJP13_PONG_REPLY = 9;
    public static final int SC_RESP_CONTENT_TYPE = 40961;
    public static final int SC_RESP_CONTENT_LANGUAGE = 40962;
    public static final int SC_RESP_CONTENT_LENGTH = 40963;
    public static final int SC_RESP_DATE = 40964;
    public static final int SC_RESP_LAST_MODIFIED = 40965;
    public static final int SC_RESP_LOCATION = 40966;
    public static final int SC_RESP_SET_COOKIE = 40967;
    public static final int SC_RESP_SET_COOKIE2 = 40968;
    public static final int SC_RESP_SERVLET_ENGINE = 40969;
    public static final int SC_RESP_STATUS = 40970;
    public static final int SC_RESP_WWW_AUTHENTICATE = 40971;
    public static final byte SC_A_CONTEXT = 1;
    public static final byte SC_A_SERVLET_PATH = 2;
    public static final byte SC_A_REMOTE_USER = 3;
    public static final byte SC_A_AUTH_TYPE = 4;
    public static final byte SC_A_QUERY_STRING = 5;
    public static final byte SC_A_JVM_ROUTE = 6;
    public static final byte SC_A_SSL_CERT = 7;
    public static final byte SC_A_SSL_CIPHER = 8;
    public static final byte SC_A_SSL_SESSION = 9;
    public static final byte SC_A_SECRET = 12;
    public static final byte SC_A_REQ_ATTRIBUTE = 10;
    public static final byte SC_A_ARE_DONE = -1;
    public static final String[] methodTransArray = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "ACL", "REPORT", "VERSION-CONTROL", "CHECKIN", "CHECKOUT", "UNCHECKOUT", "SEARCH"};
    public static final String[] headerTransArray = new String[]{"accept", "accept-charset", "accept-encoding", "accept-language", "authorization", "connection", "content-type", "content-length", "cookie", "cookie2", "host", "pragma", "referer", "user-agent"};
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    OutputStream out;
    InputStream in;
    int dL = 0;
    OutputBuffer headersWriter = new OutputBuffer(8192);
    Ajp13Packet outBuf = new Ajp13Packet(this.headersWriter);
    Ajp13Packet inBuf = new Ajp13Packet(8192);
    Ajp13Packet hBuf = new Ajp13Packet(8192);
    byte[] bodyBuff = new byte[8186];
    int blen;
    int pos;
    boolean end_of_stream;
    String secret = null;
    private boolean tomcatAuthentication = true;

    public void recycle() {
        this.blen = 0;
        this.pos = 0;
        this.end_of_stream = false;
        if (this.dL > 0) {
            this.d("recycle()");
        }
        this.headersWriter.recycle();
    }

    public boolean isTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean newTomcatAuthentication) {
        this.tomcatAuthentication = newTomcatAuthentication;
    }

    public void setSocket(Socket socket) throws IOException {
        socket.setSoLinger(true, 100);
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.pos = 0;
    }

    public String getSecret() {
        return this.secret;
    }

    public int receiveNextRequest(Request req) throws IOException {
        int err = 0;
        try {
            err = this.receive(this.hBuf);
        }
        catch (IOException ioe) {
            return -1;
        }
        if (err < 0) {
            return 500;
        }
        byte type = this.hBuf.getByte();
        switch (type) {
            case 2: {
                return this.decodeRequest(req, this.hBuf);
            }
            case 7: {
                if (this.hBuf.getLen() > 3) {
                    this.secret = this.hBuf.getString();
                }
                return -2;
            }
            case 8: {
                return this.sendPong();
            }
        }
        return 200;
    }

    private int sendPong() {
        this.outBuf.reset();
        this.outBuf.appendByte((byte)9);
        try {
            this.send(this.outBuf);
        }
        catch (IOException ioe) {
            this.d("can't send pong reply");
        }
        return 999;
    }

    private int decodeRequest(Request req, Ajp13Packet msg) throws IOException {
        MessageBytes clB;
        int contentLength;
        boolean isSSL = false;
        byte methodCode = msg.getByte();
        req.method().setString(methodTransArray[methodCode - 1]);
        msg.getMessageBytes(req.protocol());
        msg.getMessageBytes(req.requestURI());
        msg.getMessageBytes(req.remoteAddr());
        msg.getMessageBytes(req.remoteHost());
        msg.getMessageBytes(req.serverName());
        req.setServerPort(msg.getInt());
        isSSL = msg.getBool();
        MimeHeaders headers = req.getMimeHeaders();
        int hCount = msg.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = msg.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                msg.getInt();
                hName = headerTransArray[hId - 1];
                vMB = headers.addValue(hName);
            } else {
                vMB = msg.addHeader(headers);
                if (vMB == null) {
                    return 500;
                }
            }
            msg.getMessageBytes(vMB);
        }
        byte attributeCode = msg.getByte();
        while (attributeCode != -1) {
            switch (attributeCode) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (this.isTomcatAuthentication()) {
                        msg.getString();
                        break;
                    }
                    req.setRemoteUser(msg.getString());
                    req.setUserPrincipal((Principal)new SimplePrincipal(req.getRemoteUser()));
                    break;
                }
                case 4: {
                    req.setAuthType(msg.getString());
                    break;
                }
                case 5: {
                    msg.getMessageBytes(req.queryString());
                    break;
                }
                case 6: {
                    req.setJvmRoute(msg.getString());
                    break;
                }
                case 7: {
                    isSSL = true;
                    String certString = msg.getString();
                    byte[] certData = certString.getBytes();
                    try {
                        Object jsseCerts = jdk11Compat.getX509Certificates(certData);
                        req.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
                    }
                    catch (Exception e) {
                        this.d("Certificate convertion failed" + e);
                        req.setAttribute("javax.servlet.request.X509Certificate", (Object)certString);
                    }
                    break;
                }
                case 12: {
                    String s = msg.getString();
                    if (s == null) break;
                    this.secret = s;
                    break;
                }
                case 8: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.cipher_suite", (Object)msg.getString());
                    break;
                }
                case 9: {
                    isSSL = true;
                    req.setAttribute("javax.servlet.request.ssl_session", (Object)msg.getString());
                    break;
                }
                case 10: {
                    req.setAttribute(msg.getString(), (Object)msg.getString());
                    break;
                }
                default: {
                    msg.getString();
                }
            }
            attributeCode = msg.getByte();
        }
        if (isSSL) {
            req.scheme().setString("https");
        }
        int n = contentLength = (clB = headers.getValue("content-length")) == null ? -1 : clB.getInt();
        if (this.dL > 0) {
            this.d("Content-Length: " + contentLength);
        }
        if (contentLength != 0) {
            req.setContentLength(contentLength);
            int err = this.receive(this.inBuf);
            if (err < 0) {
                return 500;
            }
            this.pos = 0;
            this.blen = 0;
            if (this.inBuf.getLen() != 0) {
                this.blen = this.inBuf.peekInt();
                int cpl = this.inBuf.getBytes(this.bodyBuff);
                if (this.dL > 0) {
                    this.d("Copy into body buffer " + this.bodyBuff + " " + cpl + " " + this.blen + " " + new String(this.bodyBuff, 0, cpl));
                }
            }
        }
        return 200;
    }

    public int doRead() throws IOException {
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        return this.bodyBuff[this.pos++] & 0xFF;
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.blen && !this.refillReadBuffer()) {
            return -1;
        }
        if (this.pos + len <= this.blen) {
            System.arraycopy(this.bodyBuff, this.pos, b, off, len);
            if (this.dL > 0) {
                this.d("doRead1: " + this.pos + " " + len + " " + this.blen + " " + new String(b, off, len) + " " + Thread.currentThread());
            }
            this.pos += len;
            return len;
        }
        int toCopy = len;
        while (toCopy > 0) {
            int bytesRemaining = this.blen - this.pos;
            if (bytesRemaining < 0) {
                bytesRemaining = 0;
            }
            int c = bytesRemaining < toCopy ? bytesRemaining : toCopy;
            System.arraycopy(this.bodyBuff, this.pos, b, off, c);
            if (this.dL > 0) {
                this.d("doRead2: " + this.pos + " " + len + " " + this.blen + " " + c + " " + new String(b, off, c) + " " + new String(this.bodyBuff, this.pos, c));
            }
            off += c;
            this.pos += c;
            if ((toCopy -= c) <= 0 || this.refillReadBuffer()) continue;
            break;
        }
        return len - toCopy;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.end_of_stream) {
            return false;
        }
        this.inBuf.reset();
        this.inBuf.appendByte((byte)6);
        this.inBuf.appendInt(8186);
        if (this.dL > 0) {
            this.d("refillReadBuffer " + Thread.currentThread());
        }
        this.send(this.inBuf);
        int err = this.receive(this.inBuf);
        if (err < 0) {
            throw new IOException();
        }
        if (this.inBuf.getLen() == 0) {
            this.pos = 0;
            this.blen = 0;
            this.end_of_stream = true;
            return false;
        }
        this.blen = this.inBuf.peekInt();
        this.pos = 0;
        int cpl = this.inBuf.getBytes(this.bodyBuff);
        if (this.dL > 0) {
            this.d("Copy into body buffer2 " + this.bodyBuff + " " + cpl + " " + this.blen + " " + new String(this.bodyBuff, 0, cpl));
        }
        return this.blen > 0;
    }

    public void sendHeaders(int status, MimeHeaders headers) throws IOException {
        this.outBuf.reset();
        this.outBuf.appendByte((byte)4);
        this.outBuf.appendInt(status);
        this.outBuf.appendString(HttpMessages.getMessage((int)status));
        int numHeaders = headers.size();
        this.outBuf.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            String headerName = headers.getName(i).toString();
            int sc = this.headerNameToSc(headerName);
            if (-1 != sc) {
                this.outBuf.appendInt(sc);
            } else {
                this.outBuf.appendString(headerName);
            }
            this.outBuf.appendString(headers.getValue(i).toString());
        }
        this.outBuf.end();
        this.send(this.outBuf);
    }

    protected int headerNameToSc(String name) {
        switch (name.charAt(0)) {
            case 'C': 
            case 'c': {
                if (name.equalsIgnoreCase("Content-Type")) {
                    return 40961;
                }
                if (name.equalsIgnoreCase("Content-Language")) {
                    return 40962;
                }
                if (!name.equalsIgnoreCase("Content-Length")) break;
                return 40963;
            }
            case 'D': 
            case 'd': {
                if (!name.equalsIgnoreCase("Date")) break;
                return 40964;
            }
            case 'L': 
            case 'l': {
                if (name.equalsIgnoreCase("Last-Modified")) {
                    return 40965;
                }
                if (!name.equalsIgnoreCase("Location")) break;
                return 40966;
            }
            case 'S': 
            case 's': {
                if (name.equalsIgnoreCase("Set-Cookie")) {
                    return 40967;
                }
                if (!name.equalsIgnoreCase("Set-Cookie2")) break;
                return 40968;
            }
            case 'W': 
            case 'w': {
                if (!name.equalsIgnoreCase("WWW-Authenticate")) break;
                return 40971;
            }
        }
        return -1;
    }

    public void finish() throws IOException {
        this.outBuf.reset();
        this.outBuf.appendByte((byte)5);
        this.outBuf.appendBool(true);
        this.outBuf.end();
        this.send(this.outBuf);
    }

    public void doWrite(byte[] b, int off, int len) throws IOException {
        int to_send;
        for (int sent = 0; sent < len; sent += to_send) {
            to_send = len - sent;
            to_send = to_send > 8184 ? 8184 : to_send;
            this.outBuf.reset();
            this.outBuf.appendByte((byte)3);
            this.outBuf.appendBytes(b, off + sent, to_send);
            this.send(this.outBuf);
        }
    }

    private int readN(InputStream in, byte[] b, int offset, int len) throws IOException {
        int pos;
        int got;
        for (pos = 0; pos < len; pos += got) {
            got = in.read(b, pos + offset, len - pos);
            if (this.dL > 10) {
                this.d("read got # " + got);
            }
            if (got == 0) {
                return -102;
            }
            if (got >= 0) continue;
            return -103;
        }
        return pos;
    }

    private int receive(Ajp13Packet msg) throws IOException {
        byte[] b = msg.getBuff();
        int rd = this.readN(this.in, b, 0, 4);
        if (rd < 0) {
            return rd;
        }
        int len = msg.checkIn();
        if (len < 0) {
            return -100;
        }
        int total_read = 0;
        total_read = this.readN(this.in, b, 4, len);
        if (total_read < 0) {
            this.d("can't read body, waited #" + len);
            return -104;
        }
        if (total_read != len) {
            this.d("incomplete read, waited #" + len + " got only " + total_read);
            return -105;
        }
        if (this.dL > 0) {
            msg.dump("Ajp13.receive() " + rd + " " + len);
        }
        return total_read;
    }

    private void send(Ajp13Packet msg) throws IOException {
        msg.end();
        byte[] b = msg.getBuff();
        int len = msg.getLen();
        this.out.write(b, 0, len);
        if (this.dL > 0) {
            msg.dump("Ajp13.send()");
        }
    }

    public void close() throws IOException {
        if (null != this.out) {
            this.out.close();
        }
        if (null != this.in) {
            this.in.close();
        }
    }

    public void setDebug(int i) {
        this.dL = i;
    }

    private void d(String s) {
        System.err.println("Ajp13: " + s);
    }
}

