/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.mappers;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.depend.DependClassLoader;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;

public class ReloadInterceptor
extends BaseInterceptor {
    boolean fullReload = true;
    int dependManagerNote = -1;

    public void engineInit(ContextManager cm) throws TomcatException {
        this.dependManagerNote = cm.getNoteId(1, "DependManager");
    }

    public void setFullReload(boolean full) {
        this.fullReload = full;
    }

    public void addContext(ContextManager cm, Context context) throws TomcatException {
        DependManager dm = (DependManager)context.getContainer().getNote("DependManager");
        if (dm == null) {
            dm = new DependManager();
            context.getContainer().setNote("DependManager", (Object)dm);
        }
        if (this.debug > 0) {
            dm.setDebug(this.debug);
        }
    }

    public void contextInit(Context context) throws TomcatException {
        ContextManager cm = context.getContextManager();
        DependManager dm = (DependManager)context.getContainer().getNote("DependManager");
        File inf_xml = new File(context.getAbsolutePath() + "/WEB-INF/web.xml");
        if (inf_xml.exists()) {
            Dependency dep = new Dependency();
            dep.setTarget((Object)"web.xml");
            dep.setOrigin(inf_xml);
            dep.setLastModified(inf_xml.lastModified());
            dm.addDependency(dep);
        }
        this.loaderHook(dm, context);
    }

    public void reload(Request req, Context context) throws TomcatException {
        DependManager dm = (DependManager)context.getContainer().getNote("DependManager");
        if (dm != null) {
            dm.reset();
        }
        this.loaderHook(dm, context);
        this.log("Reloading context " + context);
    }

    protected void loaderHook(DependManager dm, Context context) {
        ClassLoader cl = context.getClassLoader();
        ClassLoader loader = DependClassLoader.getDependClassLoader((DependManager)dm, (ClassLoader)cl, (Object)context.getAttribute("org.apache.tomcat.protection_domain"), (int)this.debug);
        context.setClassLoader(loader);
        context.setAttribute("org.apache.tomcat.classloader", (Object)loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int contextMap(Request request) {
        block22: {
            Context ctx = request.getContext();
            if (ctx == null) {
                return 0;
            }
            if (!ctx.getReloadable()) {
                return 0;
            }
            if (request.getAttribute("tomcat.ReloadInterceptor") != null) {
                return 0;
            }
            DependManager dm = (DependManager)ctx.getContainer().getNote(this.dependManagerNote);
            if (!dm.shouldReload()) {
                return 0;
            }
            if (this.debug > 0) {
                this.log("Detected changes in " + ctx.toString());
            }
            try {
                ContextManager cm = ctx.getContextManager();
                if (this.fullReload) {
                    Context context = ctx;
                    synchronized (context) {
                        int i;
                        if (ctx.getState() == 0) {
                            return 0;
                        }
                        Vector<BaseInterceptor> sI = new Vector<BaseInterceptor>();
                        BaseInterceptor[] eI = ctx.getContainer().getInterceptors();
                        for (int i2 = 0; i2 < eI.length; ++i2) {
                            if (ctx != eI[i2].getContext()) continue;
                            sI.addElement(eI[i2]);
                        }
                        Context ctx1 = cm.createContext();
                        ctx1.setContextManager(cm);
                        ctx1.setPath(ctx.getPath());
                        ctx1.setDocBase(ctx.getDocBase());
                        ctx1.setReloadable(ctx.getReloadable());
                        ctx1.setDebug(ctx.getDebug());
                        ctx1.setHost(ctx.getHost());
                        ctx1.setTrusted(ctx.isTrusted());
                        Enumeration e = ctx.getHostAliases();
                        while (e.hasMoreElements()) {
                            ctx1.addHostAlias((String)e.nextElement());
                        }
                        BaseInterceptor[] ri = cm.getContainer().getInterceptors(19);
                        for (i = 0; i < ri.length; ++i) {
                            ri[i].copyContext(request, ctx, ctx1);
                        }
                        cm.removeContext(ctx);
                        cm.addContext(ctx1);
                        e = sI.elements();
                        while (e.hasMoreElements()) {
                            BaseInterceptor savedI = (BaseInterceptor)e.nextElement();
                            ctx1.addInterceptor(savedI);
                            savedI.setContext(ctx1);
                            savedI.reload(request, ctx1);
                        }
                        ctx1.init();
                        request.setAttribute("tomcat.ReloadInterceptor", (Object)this);
                        ri = cm.getContainer().getInterceptors(2);
                        for (i = 0; i < ri.length && ri[i] != this; ++i) {
                            int status = ri[i].contextMap(request);
                            if (status == 0) continue;
                            return status;
                        }
                        break block22;
                    }
                }
                Enumeration sE = ctx.getServletNames();
                while (sE.hasMoreElements()) {
                    try {
                        String sN = (String)sE.nextElement();
                        Handler sw = ctx.getServletByName(sN);
                        sw.reload();
                    }
                    catch (Exception ex) {
                        this.log("Reload exception: " + ex);
                    }
                }
                if (this.debug > 0) {
                    this.log("Reloading hooks for context " + ctx.toString());
                }
                BaseInterceptor[] cI = ctx.getContainer().getInterceptors();
                for (int i = 0; i < cI.length; ++i) {
                    cI[i].reload(request, ctx);
                    ctx.getContainer().setNote("oldLoader", null);
                }
            }
            catch (TomcatException ex) {
                this.log("Error reloading " + (Object)((Object)ex));
            }
        }
        return 0;
    }
}

