/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.loggers;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.loggers.Counters;

public class AccountingInterceptor
extends BaseInterceptor {
    ContextManager cm;
    int debug = 0;
    boolean acc = true;
    String trace = "trace.log";
    BufferedOutputStream logF = null;
    public static final int ACC_PRE_CMAP = 0;
    public static final int ACC_PRE_RMAP = 1;
    public static final int ACC_POST_MAP = 2;
    public static final int ACC_PRE_SERVICE = 3;
    public static final int ACC_POST_SERVICE = 4;
    public static final int ACC_IN_OUT = 5;
    public static final int ACC_OUT_COUNT = 6;
    public static final int COUNTERS_COUNT = 10;
    int reqCountNote = 0;
    static int cnt = 0;

    public void setTrace(String file) {
        this.trace = file;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        try {
            this.logF = new BufferedOutputStream(new FileOutputStream(this.trace));
            this.reqCountNote = cm.getNoteId(2, "counters");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int requestMap(Request request) {
        if (this.acc) {
            Counters ct = (Counters)request.getNote(this.reqCountNote);
            if (ct == null) {
                request.setNote(this.reqCountNote, (Object)new Counters(10));
            }
            ct.setCounter(1, System.currentTimeMillis());
        }
        return 0;
    }

    public int contextMap(Request request) {
        if (this.acc) {
            Counters ct = (Counters)request.getNote(this.reqCountNote);
            if (ct == null) {
                request.setNote(this.reqCountNote, (Object)new Counters(10));
            }
            ct.setCounter(0, System.currentTimeMillis());
        }
        return 0;
    }

    public int authenticate(Request request, Response response) {
        if (this.acc) {
            Counters ct = (Counters)request.getNote(this.reqCountNote);
            if (ct == null) {
                request.setNote(this.reqCountNote, (Object)new Counters(10));
            }
            ct.setCounter(2, System.currentTimeMillis());
        }
        return 0;
    }

    public int authorize(Request request, Response response) {
        return 0;
    }

    public int preService(Request request, Response response) {
        if (this.acc) {
            Counters ct = (Counters)request.getNote(this.reqCountNote);
            if (ct == null) {
                request.setNote(this.reqCountNote, (Object)new Counters(10));
            }
            ct.setCounter(3, System.currentTimeMillis());
        }
        return 0;
    }

    public int beforeBody(Request rrequest, Response response) {
        return 0;
    }

    public int beforeCommit(Request request, Response response) {
        return 0;
    }

    public int afterBody(Request request, Response response) {
        return 0;
    }

    public int postService(Request request, Response response) {
        if (this.acc) {
            Counters ct = (Counters)request.getNote(this.reqCountNote);
            if (ct == null) {
                request.setNote(this.reqCountNote, (Object)new Counters(10));
            }
            ct.setCounter(4, System.currentTimeMillis());
            long t1 = ct.getCounter(0);
            long t2 = ct.getCounter(1);
            long t3 = ct.getCounter(2);
            long t4 = ct.getCounter(3);
            long t5 = ct.getCounter(4);
            long t21 = t2 - t1;
            long t31 = t3 - t1;
            long t54 = t5 - t4;
            long t41 = t4 - t1;
            long tout = ct.getCounter(6);
            StringBuffer sb = new StringBuffer();
            sb.append(t21).append(",");
            sb.append(t31).append(",");
            sb.append(t54).append(",");
            sb.append(tout).append(",");
            sb.append(t41).append("\n");
            ct.recycle();
            ++cnt;
            try {
                if (this.logF != null) {
                    this.logF.write(sb.toString().getBytes());
                }
                if (cnt % 64 == 0) {
                    this.logF.flush();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }
}

