/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.loggers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;

public class AccessLogInterceptor
extends BaseInterceptor {
    private static final String LOGFORMAT_COMBINED = "%h %l %u %t \"%r\" %>s %b \"%{Referer}\" \"%{User-Agent}\"";
    private static final String LOGFORMAT_COMMON = "%h %l %u %t \"%r\" %>s %b";
    private static FileWriter fw = null;
    private static String fileName = "logs/AccessLog";
    private static boolean useFlush = false;
    private static String logformat = "%h %l %u %t \"%r\" %>s %b \"%{Referer}\" \"%{User-Agent}\"";
    private static DateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
    private static String crlf = System.getProperty("line.separator");
    static /* synthetic */ Class class$org$apache$tomcat$modules$loggers$AccessLogInterceptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogFile(String logFile) {
        Class clazz = class$org$apache$tomcat$modules$loggers$AccessLogInterceptor == null ? (class$org$apache$tomcat$modules$loggers$AccessLogInterceptor = AccessLogInterceptor.class$("org.apache.tomcat.modules.loggers.AccessLogInterceptor")) : class$org$apache$tomcat$modules$loggers$AccessLogInterceptor;
        synchronized (clazz) {
            fileName = logFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFlush(boolean flush) {
        Class clazz = class$org$apache$tomcat$modules$loggers$AccessLogInterceptor == null ? (class$org$apache$tomcat$modules$loggers$AccessLogInterceptor = AccessLogInterceptor.class$("org.apache.tomcat.modules.loggers.AccessLogInterceptor")) : class$org$apache$tomcat$modules$loggers$AccessLogInterceptor;
        synchronized (clazz) {
            useFlush = flush;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFormat(String format) {
        Class clazz = class$org$apache$tomcat$modules$loggers$AccessLogInterceptor == null ? (class$org$apache$tomcat$modules$loggers$AccessLogInterceptor = AccessLogInterceptor.class$("org.apache.tomcat.modules.loggers.AccessLogInterceptor")) : class$org$apache$tomcat$modules$loggers$AccessLogInterceptor;
        synchronized (clazz) {
            logformat = format.equalsIgnoreCase("combined") ? LOGFORMAT_COMBINED : (format.equalsIgnoreCase("common") ? LOGFORMAT_COMMON : format);
        }
    }

    private FileWriter getFileWriter() {
        if (fw != null) {
            return fw;
        }
        if (fileName != null) {
            try {
                File f = new File(fileName);
                if (!f.isAbsolute()) {
                    f = new File(this.cm.getHome());
                    f = new File(f, fileName);
                }
                fw = new FileWriter(f.getAbsolutePath(), true);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return fw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int postRequest(Request request, Response response) {
        Class clazz = class$org$apache$tomcat$modules$loggers$AccessLogInterceptor == null ? (class$org$apache$tomcat$modules$loggers$AccessLogInterceptor = AccessLogInterceptor.class$("org.apache.tomcat.modules.loggers.AccessLogInterceptor")) : class$org$apache$tomcat$modules$loggers$AccessLogInterceptor;
        synchronized (clazz) {
            FileWriter fw = this.getFileWriter();
            if (fw != null) {
                try {
                    for (int i = 0; i < logformat.length(); ++i) {
                        char c = logformat.charAt(i);
                        if (c == '%' && ++i < logformat.length()) {
                            c = logformat.charAt(i);
                            switch (c) {
                                case 'h': {
                                    if (request.remoteHost().toString() != null) {
                                        fw.write(request.remoteHost().toString());
                                        break;
                                    }
                                    fw.write("DEFAULT");
                                    break;
                                }
                                case 'l': {
                                    fw.write(45);
                                    break;
                                }
                                case 'u': {
                                    String user = request.getRemoteUser();
                                    fw.write(user == null ? "-" : user);
                                    break;
                                }
                                case 't': {
                                    Calendar cal = Calendar.getInstance();
                                    fw.write(91);
                                    fw.write(df.format(cal.getTime()));
                                    fw.write(32);
                                    long millis = cal.get(15) + cal.get(16);
                                    String msecstr = Long.toString((millis + 30000L) / 60000L);
                                    for (int j = msecstr.length(); j < 4; ++j) {
                                        fw.write(48);
                                    }
                                    fw.write(msecstr);
                                    fw.write(93);
                                    break;
                                }
                                case 'r': {
                                    fw.write(request.method().toString());
                                    fw.write(32);
                                    fw.write(request.requestURI().toString());
                                    String q = request.queryString().toString();
                                    if (q != null && q.length() > 0) {
                                        fw.write(63);
                                        fw.write(q);
                                    }
                                    fw.write(32);
                                    fw.write(request.protocol().toString().trim());
                                    break;
                                }
                                case 'b': {
                                    String cl = response.getStatus() == 201 ? request.getHeader("Content-Length") : response.getMimeHeaders().getHeader("Content-Length");
                                    if (cl != null && !"0".equals(cl)) {
                                        fw.write(cl);
                                        break;
                                    }
                                    fw.write("-");
                                    break;
                                }
                                case 's': {
                                    fw.write(Integer.toString(response.getStatus()));
                                    break;
                                }
                                case '>': {
                                    if (++i < logformat.length()) {
                                        c = logformat.charAt(i);
                                        if (c == 's') {
                                            fw.write(Integer.toString(response.getStatus()));
                                            break;
                                        }
                                        fw.write(62);
                                        fw.write(c);
                                        break;
                                    }
                                    fw.write(c);
                                    break;
                                }
                                case '{': {
                                    int offset = logformat.indexOf(125, i);
                                    if (offset == -1) {
                                        fw.write(c);
                                        break;
                                    }
                                    String var = logformat.substring(i + 1, offset);
                                    String val = request.getHeader(var);
                                    if (val != null) {
                                        fw.write(val);
                                    }
                                    i = offset;
                                    break;
                                }
                                default: {
                                    fw.write(c);
                                    break;
                                }
                            }
                            continue;
                        }
                        fw.write(c);
                    }
                    fw.write(crlf);
                    if (useFlush) {
                        fw.flush();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        try {
            this.getFileWriter().flush();
            this.getFileWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

