/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.util.Locale;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.LocaleToCharsetMap;
import org.apache.tomcat.util.res.StringManager;

class StatusHandler
extends Handler {
    static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    int sbNote = 0;
    boolean showDebugInfo = true;

    StatusHandler(BaseInterceptor bi, boolean showDebugInfo) {
        this.name = "tomcat.statusHandler";
        this.setModule(bi);
        this.showDebugInfo = showDebugInfo;
    }

    public void doService(Request req, Response res) throws Exception {
        Integer ut;
        boolean needsHead;
        StringBuffer buf;
        String msg = (String)req.getAttribute("javax.servlet.error.message");
        String errorURI = res.getErrorURI();
        int sc = res.getStatus();
        if (sc == 304) {
            return;
        }
        String charset = LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
        if (charset == null) {
            res.setContentType("text/html");
        } else {
            res.setContentType("text/html; charset=" + charset);
            res.setUsingWriter(true);
        }
        if (this.sbNote == 0) {
            this.sbNote = req.getContextManager().getNoteId(2, "StatusHandler.buff");
        }
        if ((buf = (StringBuffer)req.getNote(this.sbNote)) == null) {
            buf = new StringBuffer();
            req.setNote(this.sbNote, (Object)buf);
        }
        if (needsHead = res.getBuffer().isNew()) {
            buf.append("<head><title>");
            if (null != errorURI && this.showDebugInfo) {
                buf.append(sm.getString("defaulterrorpage.includedservlet")).append(" ");
            } else {
                buf.append("Error: ");
            }
            buf.append(sc).append("</title></head>\r\n<body>\r\n");
        }
        buf.append("<h1>");
        if (null != errorURI && this.showDebugInfo) {
            buf.append(sm.getString("defaulterrorpage.includedservlet")).append(" ");
        } else {
            buf.append("Error: ");
        }
        buf.append(sc);
        buf.append("</h1>\r\n");
        buf.append("<h2>").append(sm.getString("defaulterrorpage.location")).append(" ").append(HttpMessages.filter((String)req.requestURI().toString())).append("</h2>");
        if (sc >= 400 && errorURI != null && this.showDebugInfo) {
            buf.append("\r\n<h2>").append(sm.getString("defaulterrorpage.errorlocation")).append(" ").append(HttpMessages.filter((String)errorURI)).append("</h2>");
        }
        if (msg != null) {
            buf.append("\r\n<b>").append(msg).append("</b><br>\r\n");
        }
        if (sc == 503 && (ut = (Integer)req.getAttribute("tomcat.servlet.error.service.unavailableTime")) != null) {
            buf.append("<br>");
            if (ut < 0) {
                buf.append(sm.getString("defaulterrorpage.service.permanently.unavailable"));
            } else {
                buf.append(sm.getString("defaulterrorpage.service.unavailable", (Object)ut));
            }
            buf.append("<br>\r\n");
        }
        if (needsHead) {
            buf.append("</body>");
        }
        buf.append("\r\n");
        res.setContentLength(buf.length());
        res.getBuffer().write(buf);
        buf.setLength(0);
    }
}

