/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.io.File;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.generators.DirHandler;
import org.apache.tomcat.modules.generators.FileHandler;
import org.apache.tomcat.util.io.FileUtil;

public class StaticInterceptor
extends BaseInterceptor {
    int realFileNote = -1;
    boolean useAcceptLanguage = true;
    String charset = null;
    private boolean extraSafety = false;
    private boolean useInternal = false;
    private boolean strict23Welcome = false;
    private boolean listings = true;

    public boolean getListings() {
        return this.listings;
    }

    public void setListings(boolean listings) {
        this.listings = listings;
    }

    public void setUseInternal(boolean internal) {
        this.useInternal = internal;
    }

    public void setStrict23Welcome(boolean support) {
        this.strict23Welcome = support;
    }

    public void setUseAcceptLanguage(boolean use) {
        this.useAcceptLanguage = use;
    }

    public void setUseCharset(String charset) {
        this.charset = charset;
    }

    public void setExtraSafety(boolean safe) {
        this.extraSafety = safe;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        try {
            this.realFileNote = cm.getNoteId(2, "static.realFile");
        }
        catch (TomcatException ex) {
            this.log("getting note for " + cm, ex);
            throw new RuntimeException("Invalid state ");
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        FileHandler fileHandler = new FileHandler();
        DirHandler dirHandler = new DirHandler();
        fileHandler.setModule(this);
        fileHandler.setContext(ctx);
        fileHandler.setNoteId(this.realFileNote);
        fileHandler.setExtraSafety(this.extraSafety);
        ctx.addServlet((Handler)fileHandler);
        dirHandler.setNoteId(this.realFileNote);
        dirHandler.setContext(ctx);
        dirHandler.setModule(this);
        dirHandler.setUseAcceptLanguage(this.useAcceptLanguage);
        dirHandler.setCharset(this.charset);
        if (this.listings) {
            ctx.addServlet((Handler)dirHandler);
        }
    }

    public int requestMap(Request req) {
        File file;
        if (req.getHandler() != null) {
            return 0;
        }
        Context ctx = req.getContext();
        String pathInfo = req.servletPath().toString();
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (this.debug > 0) {
            this.log("Method: " + req.method());
        }
        if (req.method().equalsIgnoreCase("OPTIONS") || req.method().equalsIgnoreCase("TRACE")) {
            req.setHandler(ctx.getServletByName("tomcat.fileHandler"));
            return 0;
        }
        String absPath = FileUtil.safePath((String)ctx.getAbsolutePath(), (String)pathInfo);
        if (this.debug > 0) {
            this.log("RequestMap " + req + " " + absPath + " " + ctx.getAbsolutePath());
        }
        if (absPath == null) {
            return 0;
        }
        String requestURI = req.requestURI().toString();
        if (this.debug > 0) {
            this.log("Requested: " + absPath);
        }
        if ((file = new File(absPath)).isFile()) {
            if (this.debug > 0) {
                this.log("Setting handler to file " + absPath);
            }
            req.setNote(this.realFileNote, (Object)absPath);
            req.setHandler(ctx.getServletByName("tomcat.fileHandler"));
            return 0;
        }
        if (!file.isDirectory()) {
            if (this.debug > 0) {
                this.log("No file and no directory");
            }
            return 0;
        }
        if (!requestURI.endsWith("/") && !req.getResponse().isIncluded()) {
            String redirectURI = requestURI + "/";
            redirectURI = this.fixURLRewriting(req, redirectURI);
            String query = req.query().toString();
            if (query != null && !query.equals("")) {
                redirectURI = redirectURI + "?" + query;
            }
            req.setAttribute("javax.servlet.error.message", (Object)redirectURI);
            if (this.debug > 0) {
                this.log("Redirect " + redirectURI);
            }
            req.setHandler(ctx.getServletByName("tomcat.redirectHandler"));
            return 0;
        }
        String welcomeFile = null;
        welcomeFile = this.strict23Welcome ? this.getStrictWelcomeFile(ctx, file, pathInfo) : this.getWelcomeFile(ctx, file);
        if (this.debug > 0) {
            this.log("DefaultServlet: welcome file: " + welcomeFile);
        }
        if (welcomeFile == null) {
            req.setHandler(ctx.getServletByName("tomcat.dirHandler"));
            if (this.debug > 0) {
                this.log("Dir handler");
            }
            return 0;
        }
        int status = 0;
        status = this.useInternal ? this.doInternalRedirect(req, welcomeFile) : this.doExternalRedirect(req, welcomeFile);
        return status;
    }

    private int doInternalRedirect(Request req, String welcomeFile) {
        int i;
        String requestURI = req.requestURI().toString();
        String redirectURI = StaticInterceptor.concatPath(requestURI, welcomeFile);
        Context ctx = req.getContext();
        req.requestURI().setString(redirectURI);
        req.unparsedURI().recycle();
        req.servletPath().recycle();
        req.pathInfo().recycle();
        int status = 0;
        BaseInterceptor[] ri = ctx == null ? this.cm.getContainer().getInterceptors(2) : ctx.getContainer().getInterceptors(2);
        for (i = 0; i < ri.length; ++i) {
            status = ri[i].contextMap(req);
            if (status == 0) continue;
            return status;
        }
        ri = req.getContext().getContainer().getInterceptors(1);
        for (i = 0; i < ri.length; ++i) {
            if (this.debug > 1) {
                this.log("RequestMap " + ri[i]);
            }
            if ((status = ri[i].requestMap(req)) != 0) {
                return status;
            }
            if (ri[i] == this) break;
        }
        return 0;
    }

    private int doExternalRedirect(Request req, String welcomeFile) {
        String redirectURI = null;
        String requestURI = req.requestURI().toString();
        redirectURI = StaticInterceptor.concatPath(requestURI, welcomeFile);
        redirectURI = this.fixURLRewriting(req, redirectURI);
        String query = req.query().toString();
        if (query != null && !query.equals("")) {
            redirectURI = redirectURI + "?" + query;
        }
        Context lCtx = req.getContext();
        req.setAttribute("javax.servlet.error.message", (Object)redirectURI);
        if (this.debug > 0) {
            this.log("Redirect " + redirectURI);
        }
        req.setHandler(lCtx.getServletByName("tomcat.redirectHandler"));
        return 0;
    }

    private String fixURLRewriting(Request req, String redirectURI) {
        ServerSession session = req.getSession(false);
        if (session != null && "url".equals(req.getSessionIdSource())) {
            String id = ";jsessionid=" + req.getSessionId();
            redirectURI = redirectURI + id;
        }
        return redirectURI;
    }

    private static String concatPath(String s1, String s2) {
        if (s1.endsWith("/")) {
            if (s2.startsWith("/")) {
                return s1 + s2.substring(1);
            }
            return s1 + s2;
        }
        if (s2.startsWith("/")) {
            return s1 + s2;
        }
        return s1 + "/" + s2;
    }

    private String getStrictWelcomeFile(Context context, File dir, String pathInfo) {
        String[] wf = context.getWelcomeFiles();
        BaseInterceptor[] ri = context.getContainer().getInterceptors(2);
        for (int i = 0; i < wf.length; ++i) {
            if (this.getOneWelcomeFile(dir, wf[i])) {
                return wf[i];
            }
            String wfURI = StaticInterceptor.concatPath(pathInfo, wf[i]);
            Request req = this.cm.createRequest(context, wfURI);
            int status = 0;
            for (int j = 0; j < ri.length && (status = ri[j].contextMap(req)) == 0; ++j) {
            }
            if (status != 0 || req.servletPath() == null || req.servletPath().equals("") || req.getContainer().getMapType() == 3) continue;
            return req.servletPath().toString().substring(pathInfo.length());
        }
        return null;
    }

    private String getWelcomeFile(Context context, File dir) {
        String[] wf = context.getWelcomeFiles();
        for (int i = 0; i < wf.length; ++i) {
            if (!this.getOneWelcomeFile(dir, wf[i])) continue;
            return wf[i];
        }
        return null;
    }

    private boolean getOneWelcomeFile(File dir, String wf) {
        File f = new File(dir, wf);
        return f.exists();
    }
}

