/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.util.Locale;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.LocaleToCharsetMap;
import org.apache.tomcat.util.res.StringManager;

class NotFoundHandler
extends Handler {
    static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    int sbNote = 0;
    boolean showDebugInfo = true;

    NotFoundHandler(BaseInterceptor bi, boolean showDebugInfo) {
        this.name = "tomcat.notFoundHandler";
        this.setModule(bi);
        this.showDebugInfo = showDebugInfo;
    }

    public void doService(Request req, Response res) throws Exception {
        boolean needsHead;
        StringBuffer buf;
        String msg = (String)req.getAttribute("javax.servlet.error.message");
        String charset = LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
        if (charset == null) {
            res.setContentType("text/html");
        } else {
            res.setContentType("text/html; charset=" + charset);
            res.setUsingWriter(true);
        }
        String requestURI = req.requestURI().toString();
        if (this.sbNote == 0) {
            this.sbNote = req.getContextManager().getNoteId(2, "NotFoundHandler.buff");
        }
        if ((buf = (StringBuffer)req.getNote(this.sbNote)) == null) {
            buf = new StringBuffer();
            req.setNote(this.sbNote, (Object)buf);
        }
        if (needsHead = res.getBuffer().isNew()) {
            buf.append("<head><title>").append(sm.getString("defaulterrorpage.notfound404")).append("</title></head>\r\n<body>");
        }
        buf.append("<h1>").append(sm.getString("defaulterrorpage.notfound404")).append("</h1>\r\n");
        buf.append(sm.getString("defaulterrorpage.originalrequest")).append(" ").append(HttpMessages.filter((String)requestURI)).append("\r\n");
        if (null != requestURI && this.showDebugInfo) {
            buf.append("<br><br>\r\n<b>").append(sm.getString("defaulterrorpage.notfoundrequest")).append("</b> ").append(HttpMessages.filter((String)requestURI)).append("\r\n");
        }
        if (msg != null) {
            buf.append("<br><br>\r\n<b>").append(msg).append("</b><br>\r\n");
        }
        if (needsHead) {
            buf.append("</body>");
        }
        buf.append("\r\n");
        res.setContentLength(buf.length());
        res.getBuffer().write(buf);
        buf.setLength(0);
    }
}

