/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;

public class InvokerInterceptor
extends BaseInterceptor {
    String prefix = "/servlet/";
    int prefixLen = this.prefix.length();

    public void setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
            this.prefixLen = this.prefix.length();
        }
    }

    public int requestMap(Request req) {
        int secondSlash;
        Container ct = req.getContainer();
        if (req.getHandler() != null && ct != null && ct.getMapType() != 4) {
            return 0;
        }
        String pathInfo = req.pathInfo().toString();
        String servletPath = req.servletPath().toString();
        if (servletPath == null || !servletPath.startsWith(this.prefix)) {
            return 0;
        }
        Context ctx = req.getContext();
        String servletName = null;
        String newPathInfo = null;
        if (this.debug > 0) {
            this.log("Original ServletPath=" + servletPath + " PathInfo=" + pathInfo);
        }
        if ((secondSlash = servletPath.indexOf("/", this.prefixLen)) > -1) {
            servletName = servletPath.substring(this.prefixLen, secondSlash);
            newPathInfo = servletPath.substring(secondSlash);
        } else {
            servletName = servletPath.substring(this.prefixLen);
        }
        String newServletPath = this.prefix + servletName;
        if (this.debug > 0) {
            this.log("After pathfix SN=" + servletName + " SP=" + newServletPath + " PI=" + newPathInfo);
        }
        req.servletPath().setString(newServletPath);
        req.pathInfo().setString(newPathInfo);
        Handler wrapper = ctx.getServletByName(servletName);
        if (wrapper != null) {
            req.setHandler(wrapper);
            return 0;
        }
        try {
            Handler sw;
            ctx.addServletMapping(newServletPath + "/*", servletName);
            wrapper = sw = ctx.getServletByName(servletName);
            if (this.debug > 0) {
                this.log("Added mapping " + wrapper + " path=" + newServletPath + "/*");
            }
        }
        catch (TomcatException ex) {
            this.loghelper.log("dynamically adding wrapper for " + servletName, (Throwable)ex);
            return 404;
        }
        req.setHandler(wrapper);
        return 0;
    }
}

