/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.io.FileUtil;

final class FileHandler
extends Handler {
    int realFileNote;
    Context context;
    private boolean extraSafety = false;

    FileHandler() {
        this.name = "tomcat.fileHandler";
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setExtraSafety(boolean safe) {
        this.extraSafety = safe;
    }

    public void setNoteId(int n) {
        this.realFileNote = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doService(Request req, Response res) throws Exception {
        String mimeType;
        String base;
        String absPath;
        if (req.method().equalsIgnoreCase("OPTIONS")) {
            this.doOptions(req, res);
            return;
        }
        if (req.method().equalsIgnoreCase("TRACE")) {
            this.doTrace(req, res);
            return;
        }
        Request subReq = req;
        if (req.getChild() != null) {
            subReq = req.getChild();
        }
        Context ctx = subReq.getContext();
        String pathInfo = (String)subReq.getAttribute("javax.servlet.include.servlet_path");
        if (pathInfo == null) {
            pathInfo = subReq.servletPath().toString();
        }
        if ((absPath = (String)subReq.getNote(this.realFileNote)) == null) {
            absPath = FileUtil.safePath((String)this.context.getAbsolutePath(), (String)pathInfo);
        }
        if (this.debug > 0) {
            this.log("Requested file = " + absPath);
        }
        if ((absPath = this.extraCheck(base = ctx.getAbsolutePath(), absPath)) == null) {
            this.context.getContextManager().handleStatus(req, res, 404);
            return;
        }
        File file = new File(absPath);
        if (!res.isIncluded()) {
            long date = req.getDateHeader("If-Modified-Since");
            if (file.lastModified() <= date + 1000L) {
                this.context.getContextManager().handleStatus(req, res, 304);
                return;
            }
        }
        if (this.debug > 0) {
            this.log("After paranoic checks = " + absPath);
        }
        if ((mimeType = ctx.getMimeMap().getContentTypeFor(absPath)) == null) {
            mimeType = "text/plain";
        }
        if (this.debug > 0) {
            this.log("Serving  " + absPath);
        }
        res.setContentType(mimeType);
        res.setContentLength((int)file.length());
        FileHandler.setDateHeader(res, "Last-Modified", file.lastModified());
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            OutputBuffer out = res.getBuffer();
            byte[] buf = new byte[1024];
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        catch (FileNotFoundException e) {
            this.context.getContextManager().handleStatus(req, res, 404);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    static void setDateHeader(Response res, String name, long value) {
        if (!res.isIncluded()) {
            MimeHeaders headers = res.getMimeHeaders();
            headers.setValue(name).setTime(value);
        }
    }

    void doOptions(Request req, Response res) throws IOException {
        res.addHeader("Allow", "HEAD, GET, POST, OPTIONS, TRACE");
    }

    void doTrace(Request req, Response res) throws IOException {
        String CRLF = "\r\n";
        res.setContentType("message/http");
        StringBuffer resp = new StringBuffer();
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String hName = (String)headers.nextElement();
            String hValue = req.getHeader(hName);
            resp.append(CRLF).append(hName).append(": ").append(hValue);
        }
        resp.append(CRLF);
        res.setContentLength(resp.length());
        OutputBuffer out = res.getBuffer();
        out.write(resp.toString());
    }

    String extraCheck(String base, String absPath) {
        if (absPath.endsWith("/") || absPath.endsWith("\\") || absPath.endsWith(".")) {
            this.log("Ends with \\/. " + absPath);
            return null;
        }
        if (this.extraSafety && absPath.length() > base.length()) {
            String relPathU;
            String relPath = absPath.substring(base.length() + 1);
            if (this.debug > 0) {
                this.log("RelPath = " + relPath);
            }
            if ((relPathU = relPath.toUpperCase()).startsWith("WEB-INF") || relPathU.startsWith("META-INF") || relPathU.indexOf("/WEB-INF/") >= 0 || relPathU.indexOf("/META-INF/") >= 0) {
                return null;
            }
        }
        return absPath;
    }
}

