/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.util.Locale;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.LocaleToCharsetMap;
import org.apache.tomcat.util.qlog.Logger;
import org.apache.tomcat.util.res.StringManager;

class ExceptionHandler
extends Handler {
    static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    int sbNote = 0;
    boolean showDebugInfo = true;

    ExceptionHandler(BaseInterceptor bi, boolean showDebugInfo) {
        this.name = "tomcat.exceptionHandler";
        this.setModule(bi);
        this.showDebugInfo = showDebugInfo;
    }

    public void doService(Request req, Response res) throws Exception {
        boolean needsHead;
        StringBuffer buf;
        String msg = (String)req.getAttribute("javax.servlet.error.message");
        String errorURI = res.getErrorURI();
        Throwable e = (Throwable)req.getAttribute("tomcat.servlet.error.throwable");
        if (e == null) {
            this.log("Exception handler called without an exception", new Throwable("trace"));
            return;
        }
        if (this.sbNote == 0) {
            this.sbNote = req.getContextManager().getNoteId(2, "ExceptionHandler.buff");
        }
        if ((buf = (StringBuffer)req.getNote(this.sbNote)) == null) {
            buf = new StringBuffer();
            req.setNote(this.sbNote, (Object)buf);
        }
        if (needsHead = res.getBuffer().isNew()) {
            String charset = LocaleToCharsetMap.getCharset((Locale)Locale.getDefault());
            if (charset == null) {
                res.setContentType("text/html");
            } else {
                res.setContentType("text/html; charset=" + charset);
                res.setUsingWriter(true);
            }
            res.setStatus(500);
            buf.append("<head><title>");
            if (null != errorURI && this.showDebugInfo) {
                buf.append(sm.getString("defaulterrorpage.includedservlet")).append(" ");
            } else {
                buf.append("Error: ");
            }
            buf.append(500).append("</title></head>\r\n<body>\r\n");
        }
        buf.append("<h1>");
        if (null != errorURI && this.showDebugInfo) {
            buf.append(sm.getString("defaulterrorpage.includedservlet")).append(" ");
        } else {
            buf.append("Error: ");
        }
        buf.append(500);
        buf.append("</h1>\r\n");
        buf.append("<h2>").append(sm.getString("defaulterrorpage.location")).append(" ").append(HttpMessages.filter((String)req.requestURI().toString())).append("</h2>");
        if (null != errorURI && this.showDebugInfo) {
            buf.append("\r\n<h2>").append(sm.getString("defaulterrorpage.errorlocation")).append(" ").append(HttpMessages.filter((String)errorURI)).append("</h2>");
        }
        if (this.showDebugInfo) {
            buf.append("<b>").append(sm.getString("defaulterrorpage.internalservleterror"));
            buf.append("</b><br>\r\n<pre>");
            String trace = Logger.throwableToString((Throwable)e, (String)("<b>" + sm.getString("defaulterrorpage.rootcause") + "</b>"));
            buf.append(trace);
            buf.append("</pre>\r\n");
        } else {
            buf.append("<b>Error:</b> ").append(e.getMessage()).append("<br><br>\r\n");
        }
        if (needsHead) {
            buf.append("</body>");
        }
        buf.append("\r\n");
        res.getBuffer().write(buf);
        buf.setLength(0);
    }
}

