/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.generators.ExceptionHandler;
import org.apache.tomcat.modules.generators.NotFoundHandler;
import org.apache.tomcat.modules.generators.RedirectHandler;
import org.apache.tomcat.modules.generators.StatusHandler;

public final class ErrorHandler
extends BaseInterceptor {
    private Context rootContext = null;
    boolean showDebugInfo = true;
    int defaultRedirectStatus = 301;

    public void setShowDebugInfo(boolean b) {
        this.showDebugInfo = b;
    }

    public void setDefaultRedirectStatus(String s) {
        this.defaultRedirectStatus = "302".equals(s) ? 302 : ("301".equals(s) ? 301 : 301);
    }

    public void engineInit(ContextManager cm) {
    }

    public void engineStart(ContextManager cm) throws TomcatException {
        if (this.rootContext == null) {
            this.rootContext = cm.createContext();
            this.rootContext.setContextManager(cm);
            this.rootContext.setPath("");
            this.contextInit(this.rootContext);
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        ContextManager cm;
        String dI;
        if (ctx.getHost() == null && ctx.getPath().equals("")) {
            this.rootContext = ctx;
        }
        if ((dI = (cm = ctx.getContextManager()).getProperty("showDebugInfo")) != null && (dI.equalsIgnoreCase("no") || dI.equalsIgnoreCase("false"))) {
            this.showDebugInfo = false;
        }
        if ((dI = ctx.getProperty("showDebugInfo")) != null && (dI.equalsIgnoreCase("no") || dI.equalsIgnoreCase("false"))) {
            this.showDebugInfo = false;
        }
        if (dI != null && (dI.equalsIgnoreCase("yes") || dI.equalsIgnoreCase("true"))) {
            this.showDebugInfo = true;
        }
        ctx.addServlet((Handler)new ExceptionHandler(this, this.showDebugInfo));
        ctx.addServlet((Handler)new StatusHandler(this, this.showDebugInfo));
        RedirectHandler rh = new RedirectHandler(this);
        rh.setDefaultRedirectStatus(this.defaultRedirectStatus);
        ctx.addServlet((Handler)rh);
        if (ctx.getErrorPage("302") == null) {
            ctx.addErrorPage("302", "tomcat.redirectHandler");
        }
        if (ctx.getErrorPage("301") == null) {
            ctx.addErrorPage("301", "tomcat.redirectHandler");
        }
        ctx.addServlet((Handler)new NotFoundHandler(this, this.showDebugInfo));
        if (ctx.getErrorPage("404") == null) {
            ctx.addErrorPage("404", "tomcat.notFoundHandler");
        }
        if (this.debug > 0) {
            this.log("Init " + ctx + " " + this.showDebugInfo);
        }
    }

    public int handleError(Request req, Response res, Throwable t) {
        ContextManager cm = req.getContextManager();
        Context ctx = req.getContext();
        if (ctx == null) {
            ctx = this.rootContext;
        }
        if (this.debug > 0) {
            this.log("In error handler " + t);
        }
        if (t == null) {
            this.handleStatusImpl(cm, ctx, req, res, res.getStatus());
        } else {
            this.handleErrorImpl(cm, ctx, req, res, t);
        }
        return 200;
    }

    private final void handleStatusImpl(ContextManager cm, Context ctx, Request req, Response res, int code) {
        String errorPath = null;
        Handler errorServlet = null;
        if (code > 401) {
            if (ctx == null) {
                cm.log("Status code:" + code + " request:" + req + " msg:" + req.getAttribute("javax.servlet.error.message"));
            } else {
                ctx.log("Status code:" + code + " request:" + req + " msg:" + req.getAttribute("javax.servlet.error.message"));
            }
        }
        if ((errorPath = ctx.getErrorPage(code)) != null) {
            errorServlet = this.getHandlerForPath(cm, ctx, errorPath);
            String cpath = ctx.getPath();
            if ("/".equals(cpath)) {
                cpath = "";
            }
            if (null != errorPath && errorPath.startsWith("/")) {
                req.setAttribute("javax.servlet.include.request_uri", (Object)(cpath + errorPath));
            } else {
                req.setAttribute("javax.servlet.include.request_uri", (Object)(cpath + "/" + errorPath));
            }
            req.setAttribute("javax.servlet.include.servlet_path", (Object)errorPath);
        }
        boolean isDefaultHandler = false;
        if (this.statusLoop(ctx, req, code)) {
            this.log("Error loop for " + req + " error code " + code);
            return;
        }
        if (errorServlet == null) {
            errorServlet = code == 404 ? ctx.getServletByName("tomcat.notFoundHandler") : ctx.getServletByName("tomcat.statusHandler");
            isDefaultHandler = true;
        }
        if (errorServlet == null) {
            ctx.log("Handler errorServlet is null! errorPath:" + errorPath);
            return;
        }
        if (!res.isBufferCommitted()) {
            res.resetBuffer();
        }
        req.setAttribute("javax.servlet.error.status_code", (Object)new Integer(code));
        req.setAttribute("tomcat.servlet.error.request", (Object)req);
        if (this.debug > 0) {
            ctx.log("Handler " + errorServlet + " " + errorPath);
        }
        res.setErrorException(null);
        Exception ex = null;
        try {
            errorServlet.service(req, res);
            ex = res.getErrorException();
        }
        catch (Exception ex1) {
            ex = ex1;
        }
        if (ex != null && !(ex instanceof IOException)) {
            ctx.log("Error in default status handler", (Throwable)ex);
        }
    }

    void handleErrorImpl(ContextManager cm, Context ctx, Request req, Response res, Throwable t) {
        Class<?> clazz;
        if (this.debug > 0) {
            this.log("Handle error in " + req + " " + ((Throwable)t).getMessage());
        }
        if (t instanceof IllegalStateException) {
            ctx.log("IllegalStateException in " + req, (Throwable)t);
        } else if (t instanceof IOException) {
            if ("Broken pipe".equals(((Throwable)t).getMessage())) {
                ctx.log("Broken pipe in " + req, (Throwable)t, 4);
                return;
            }
            if ("Connection reset by peer".equals(((Throwable)t).getMessage())) {
                ctx.log("Connection reset by peer in " + req, (Throwable)t, 4);
                return;
            }
            ctx.log("IOException in " + req, (Throwable)t);
        } else {
            ctx.log("Exception in " + req, (Throwable)t);
        }
        if (null != req.getAttribute("tomcat.servlet.error.defaultHandler")) {
            this.log("ERROR: can't find default error handler, or error in default error page", (Throwable)t);
        }
        String errorPath = null;
        Handler errorServlet = null;
        for (clazz = t.getClass(); errorPath == null && clazz != null; clazz = clazz.getSuperclass()) {
            String name = clazz.getName();
            errorPath = ctx.getErrorPage(name);
        }
        if (errorPath == null) {
            Object t2 = null;
            try {
                Method m = t.getClass().getMethod("getRootCause", new Class[0]);
                t2 = (Throwable)m.invoke(t, new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (t2 != null) {
                for (clazz = t2.getClass(); errorPath == null && clazz != null; clazz = clazz.getSuperclass()) {
                    String name = clazz.getName();
                    errorPath = ctx.getErrorPage(name);
                }
            }
            if (errorPath != null) {
                t = t2;
            }
        }
        if (errorPath != null) {
            errorServlet = this.getHandlerForPath(cm, ctx, errorPath);
            String cpath = ctx.getPath();
            if ("/".equals(cpath)) {
                cpath = "";
            }
            if (null != errorPath && errorPath.startsWith("/")) {
                req.setAttribute("javax.servlet.include.request_uri", (Object)(cpath + errorPath));
            } else {
                req.setAttribute("javax.servlet.include.request_uri", (Object)(cpath + "/" + errorPath));
            }
            req.setAttribute("javax.servlet.include.servlet_path", (Object)errorPath);
        }
        boolean isDefaultHandler = false;
        if (this.errorLoop(ctx, req)) {
            this.log("Error loop for " + req + " error " + t);
            return;
        }
        if (errorServlet == null) {
            errorServlet = ctx.getServletByName("tomcat.exceptionHandler");
            isDefaultHandler = true;
            if (this.debug > 0) {
                ctx.log("Using default handler " + errorServlet);
            }
        }
        if (errorServlet == null) {
            ctx.log("Handler errorServlet is null! errorPath:" + errorPath);
            return;
        }
        if (!res.isBufferCommitted()) {
            res.resetBuffer();
        }
        req.setAttribute("javax.servlet.error.exception_type", t.getClass());
        req.setAttribute("javax.servlet.error.message", (Object)((Throwable)t).getMessage());
        req.setAttribute("javax.servlet.jsp.jspException", t);
        req.setAttribute("tomcat.servlet.error.throwable", t);
        req.setAttribute("tomcat.servlet.error.request", (Object)req);
        if (this.debug > 0) {
            ctx.log("Handler " + errorServlet + " " + errorPath);
        }
        res.setErrorException(null);
        Exception ex = null;
        try {
            errorServlet.service(req, res);
            ex = res.getErrorException();
        }
        catch (Exception ex1) {
            ex = ex1;
        }
        if (ex != null && !(ex instanceof IOException)) {
            ctx.log("Error in errorServlet: ", (Throwable)ex);
        }
    }

    public final Handler getHandlerForPath(ContextManager cm, Context ctx, String path) {
        if (!path.startsWith("/")) {
            return ctx.getServletByName(path);
        }
        Request req1 = cm.createRequest(ctx, path);
        cm.processRequest(req1);
        return req1.getHandler();
    }

    private boolean errorLoop(Context ctx, Request req) {
        if (req.getAttribute("javax.servlet.error.status_code") != null || req.getAttribute("javax.servlet.error.exception_type") != null) {
            if (ctx.getDebug() > 0) {
                ctx.log("Error: exception inside exception servlet " + req.getAttribute("javax.servlet.error.status_code") + " " + req.getAttribute("javax.servlet.error.exception_type"));
            }
            return true;
        }
        return false;
    }

    private boolean statusLoop(Context ctx, Request req, int newCode) {
        Integer lastCode = (Integer)req.getAttribute("javax.servlet.error.status_code");
        if (lastCode != null && lastCode == newCode) {
            if (ctx.getDebug() > 0) {
                ctx.log("Error: nested error inside status servlet " + newCode);
            }
            return true;
        }
        return false;
    }
}

