/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.Profile;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

public class ProfileLoader
extends BaseInterceptor {
    Hashtable profiles = new Hashtable();
    String configFile = null;
    static final String DEFAULT_CONFIG = "conf/profile.xml";

    public void setConfig(String s) {
        this.configFile = s;
    }

    public void addProfile(Profile p) {
        String name = p.getName();
        if (this.debug > 0) {
            this.log("Adding " + name);
        }
        if (name == null) {
            return;
        }
        this.profiles.put(name, p);
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        int i;
        Profile p;
        String ctxProfile = ctx.getProperty("profile");
        if (ctxProfile == null) {
            ctxProfile = "default";
        }
        if ((p = (Profile)this.profiles.get(ctxProfile)) == null) {
            this.log("Can't find profile " + ctxProfile);
            p = (Profile)this.profiles.get("default");
        }
        if (p == null) {
            throw new TomcatException("Can't load profile");
        }
        URL[] cp = p.commonClassPath;
        for (i = 0; i < cp.length; ++i) {
            ctx.addClassPath(cp[i]);
        }
        cp = p.sharedClassPath;
        for (i = 0; i < cp.length; ++i) {
            ctx.addClassPath(cp[i]);
        }
        Enumeration en = p.getModules();
        while (en.hasMoreElements()) {
            BaseInterceptor bi = (BaseInterceptor)en.nextElement();
            if (this.debug > 0) {
                this.log(ctx + " " + bi);
            }
            ctx.addInterceptor(bi);
        }
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
        File f;
        if (this != module) {
            return;
        }
        XmlMapper xh = new XmlMapper();
        xh.setDebug(this.debug);
        this.addProfileRules(xh);
        this.addTagRules(cm, ctx, xh);
        if (this.configFile == null) {
            this.configFile = DEFAULT_CONFIG;
        }
        if (!(f = new File(this.configFile)).isAbsolute()) {
            f = new File(cm.getHome(), File.separator + this.configFile);
        }
        if (f.exists()) {
            try {
                xh.readXml(f, (Object)this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new TomcatException((Throwable)ex);
            }
        }
    }

    public void addTagRules(ContextManager cm, Context ctx, XmlMapper xh) throws TomcatException {
        Hashtable modules = (Hashtable)cm.getNote("modules");
        if (modules == null) {
            return;
        }
        Enumeration keys = modules.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String classN = (String)modules.get(name);
            String tag = "Profile/" + name;
            xh.addRule(tag, (XmlAction)new TagAction(classN));
        }
    }

    public void addProfileRules(XmlMapper xh) {
        xh.addRule("Profile", (XmlAction)new ProfileAction(this));
    }

    static class TagAction
    extends XmlAction {
        String className;

        TagAction(String classN) {
            this.className = classN;
        }

        public void start(SaxContext ctx) throws Exception {
            String tag = ctx.getCurrentElement();
            Profile profile = (Profile)ctx.currentObject();
            Class<?> c = null;
            ClassLoader cl = profile.containerLoader;
            try {
                c = cl.loadClass(this.className);
            }
            catch (ClassNotFoundException ex2) {
                c = profile.commonLoader.loadClass(this.className);
            }
            Object o = c.newInstance();
            AttributeList attributes = ctx.getCurrentAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String type = attributes.getType(i);
                String name = attributes.getName(i);
                String value = attributes.getValue(i);
                IntrospectionUtils.setProperty(o, (String)name, (String)value);
            }
            profile.addModule((BaseInterceptor)o);
        }
    }

    static class ProfileAction
    extends XmlAction {
        ProfileLoader ploader;

        ProfileAction(ProfileLoader ploader) {
            this.ploader = ploader;
        }

        public void start(SaxContext ctx) throws Exception {
            Profile p = new Profile(this.ploader.getContextManager());
            AttributeList attributes = ctx.getCurrentAttributes();
            p.setName(attributes.getValue("name"));
            p.initClassLoaders();
            ctx.pushObject((Object)p);
        }

        public void end(SaxContext ctx) {
            Profile obj = (Profile)ctx.currentObject();
            this.ploader.addProfile(obj);
        }

        public void cleanup(SaxContext ctx) {
            ctx.popObject();
        }
    }
}

