/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.compat.Jdk11Compat;

class Profile {
    String name;
    URL[] sharedClassPath;
    URL[] commonClassPath;
    URL[] serverClassPath;
    ClassLoader commonLoader;
    ClassLoader containerLoader;
    ClassLoader appLoader;
    Vector modules = new Vector();
    ContextManager cm;
    static final Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();

    public Profile(ContextManager cm) {
        this.cm = cm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public Enumeration getModules() {
        return this.modules.elements();
    }

    public void addModule(BaseInterceptor bi) {
        this.modules.addElement(bi);
    }

    ClassLoader getContainerLoader() {
        return this.containerLoader;
    }

    public void initClassLoaders() {
        String home = this.cm.getHome();
        Vector commonClassPathV = new Vector();
        IntrospectionUtils.addToClassPath(commonClassPathV, (String)(home + "/lib/common/" + this.name));
        this.commonClassPath = IntrospectionUtils.getClassPath(commonClassPathV);
        this.commonLoader = jdk11Compat.newClassLoaderInstance(this.commonClassPath, this.cm.getCommonLoader());
        Vector sharedClassPathV = new Vector();
        IntrospectionUtils.addToClassPath(sharedClassPathV, (String)(home + "/lib/apps/" + this.name));
        this.sharedClassPath = IntrospectionUtils.getClassPath(sharedClassPathV);
        this.appLoader = jdk11Compat.newClassLoaderInstance(this.sharedClassPath, this.cm.getAppsLoader());
        Vector serverClassPathV = new Vector();
        IntrospectionUtils.addToClassPath(serverClassPathV, (String)(home + "/lib/container/" + this.name));
        IntrospectionUtils.addToolsJar(serverClassPathV);
        this.serverClassPath = IntrospectionUtils.getClassPath(serverClassPathV);
        this.containerLoader = jdk11Compat.newClassLoaderInstance(this.serverClassPath, this.cm.getContainerLoader());
    }
}

