/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.compat.Jdk11Compat;

public class PolicyLoader
extends BaseInterceptor {
    String securityManagerClass = "java.lang.SecurityManager";
    String policyFile = null;
    boolean sandbox = false;
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();

    public void setSecurityManagerClass(String cls) {
        this.securityManagerClass = cls;
    }

    public String getSecurityManagerClass() {
        return this.securityManagerClass;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    public void setPolicyFile(String pf) {
        this.policyFile = pf;
    }

    public void setSandbox(boolean b) {
        this.sandbox = b;
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
        if (this != module) {
            return;
        }
        if (!jdk11Compat.isJava2()) {
            return;
        }
        if (this.debug > 0) {
            this.log("Checking for security manager " + cm.getProperty("sandbox"));
        }
        if (this.sandbox || System.getSecurityManager() != null || cm.getProperty("sandbox") != null) {
            this.log("Loading sandbox ");
            try {
                Class<?> c = Class.forName("org.apache.tomcat.modules.config.PolicyInterceptor");
                PolicyLoader policyModule = (PolicyLoader)((Object)c.newInstance());
                policyModule.setSecurityManagerClass(this.securityManagerClass);
                policyModule.setPolicyFile(this.policyFile);
                policyModule.setDebug(this.debug);
                cm.addInterceptor((BaseInterceptor)policyModule);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

