/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.PropertyPermission;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.PolicyLoader;
import org.apache.tomcat.util.io.FileUtil;

public class PolicyInterceptor
extends PolicyLoader {
    String securityManagerClass = "java.lang.SecurityManager";
    String policyFile = null;

    public void setSecurityManagerClass(String cls) {
        this.securityManagerClass = cls;
    }

    public void setPolicyFile(String pf) {
        this.policyFile = pf;
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.initSecurityManager(cm);
    }

    public void initSecurityManager(ContextManager cm) throws TomcatException {
        if (System.getSecurityManager() != null) {
            return;
        }
        try {
            if (null == System.getProperty("java.security.policy")) {
                this.log("Setting java.security.policy. This may fail on some VMs, please set it as a system property before starting tomcat");
                File f = null;
                if (this.policyFile == null) {
                    this.policyFile = "conf/tomcat.policy";
                }
                f = FileUtil.isAbsolute((String)this.policyFile) ? new File(this.policyFile) : new File(cm.getHome() + File.separator + this.policyFile);
                try {
                    this.policyFile = f.getCanonicalPath();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (this.debug > 0) {
                    this.log("Setting policy file to " + this.policyFile + " tomcat.home= " + System.getProperty("tomcat.home"));
                }
                System.setProperty("java.security.policy", this.policyFile);
            }
            Class<?> c = Class.forName(this.securityManagerClass);
            Object o = c.newInstance();
            Policy.getPolicy().refresh();
            System.setSecurityManager((SecurityManager)o);
            this.log("SANDBOX mode enabled");
            if (!"java.lang.SecurityManager".equals(this.securityManagerClass)) {
                this.log("Security Manager=" + this.securityManagerClass);
            }
        }
        catch (ClassNotFoundException ex) {
            this.log("SecurityManager Class not found: " + this.securityManagerClass, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log("SecurityManager Class could not be loaded: " + this.securityManagerClass, 1);
        }
    }

    protected void addDefaultPermissions(Context context, String base, Permissions p) {
        if (context.isTrusted()) {
            if (this.debug > 0) {
                this.log("All permissions for " + context);
            }
            AllPermission aP = new AllPermission();
            p.add(aP);
            return;
        }
        FilePermission fp = new FilePermission(base + File.separator + "-", "read");
        p.add(fp);
        fp = new FilePermission(base + File.separator + "-", "write");
        p.add(fp);
        fp = new FilePermission(base, "read");
        p.add(fp);
        fp = new FilePermission(context.getWorkDir() + File.separator + "-", "read");
        p.add(fp);
        fp = new FilePermission(context.getWorkDir() + File.separator + "-", "write");
        p.add(fp);
        fp = new FilePermission(context.getWorkDir().toString(), "read");
        p.add(fp);
        fp = new FilePermission(this.cm.getInstallDir() + File.separator + "lib" + File.separator + "common" + File.separator + "-", "read");
        p.add(fp);
        fp = new FilePermission(this.cm.getInstallDir() + File.separator + "lib" + File.separator + "apps" + File.separator + "-", "read");
        p.add(fp);
        RuntimePermission rp = new RuntimePermission("getClassLoader");
        p.add(rp);
        PropertyPermission pp = new PropertyPermission("line.separator", "read");
        p.add(pp);
        pp = new PropertyPermission("file.separator", "read");
        p.add(pp);
        pp = new PropertyPermission("path.separator", "read");
        p.add(pp);
        if (this.debug > 0 || context.getDebug() > 0) {
            context.log("permissions " + p);
        }
    }

    public void contextInit(Context context) throws TomcatException {
        ContextManager cm = context.getContextManager();
        String base = context.getAbsolutePath();
        try {
            File dir = new File(base);
            URL url = new URL("file:" + dir.getAbsolutePath());
            CodeSource cs = new CodeSource(url, null);
            Permissions p = new Permissions();
            this.addDefaultPermissions(context, dir.getAbsolutePath(), p);
            Policy.getPolicy().refresh();
            PermissionCollection pFileP = Policy.getPolicy().getPermissions(cs);
            if (pFileP != null) {
                Enumeration<Permission> enumeration = pFileP.elements();
                while (enumeration.hasMoreElements()) {
                    p.add(enumeration.nextElement());
                }
            }
            ProtectionDomain pd = new ProtectionDomain(cs, p);
            context.setAttribute("org.apache.tomcat.protection_domain", (Object)pd);
        }
        catch (Exception ex) {
            this.log("Security init for Context " + base + " failed", ex);
        }
    }
}

