/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.log.Log;
import org.apache.tomcat.util.log.LogHandler;
import org.apache.tomcat.util.log.LogManager;
import org.apache.tomcat.util.qlog.LogDaemon;
import org.apache.tomcat.util.qlog.QueueLogger;

public class LogSetter
extends BaseInterceptor {
    String name;
    String path;
    String verbosityLevel = "INFORMATION";
    boolean servletLogger = false;
    boolean timestamps = true;
    String tsFormat = null;
    QueueLogger ql;

    public void setName(String s) {
        this.name = s;
    }

    public void setPath(String s) {
        this.path = s;
    }

    public void setVerbosityLevel(String s) {
        this.verbosityLevel = s;
    }

    public void setServletLogger(boolean b) {
        this.servletLogger = b;
    }

    public void setTimestamps(boolean b) {
        this.timestamps = b;
    }

    public void setTimestampFormat(String s) {
        this.tsFormat = s;
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
        LogDaemon logDaemon;
        if (module != this) {
            return;
        }
        LogManager logManager = (LogManager)cm.getNote("tc.LogManager");
        if (logManager == null) {
            logManager = new TomcatLogManager();
            cm.setNote("tc.LogManager", (Object)logManager);
            Log.setLogManager((LogManager)logManager);
        }
        if ((logDaemon = (LogDaemon)cm.getNote("tc.LogDaemon")) == null) {
            logDaemon = new LogDaemon();
            cm.setNote("tc.LogDaemon", (Object)logDaemon);
            logDaemon.start();
        }
        if (this.name == null) {
            this.name = this.servletLogger ? "org/apache/tomcat/facade" : "org/apache/tomcat/core";
        }
        if (this.path != null && !FileUtil.isAbsolute((String)this.path)) {
            File wd = new File(cm.getHome(), this.path);
            this.path = wd.getAbsolutePath();
        }
        if ("tc_log".equals(this.name)) {
            this.name = "org/apache/tomcat/core";
        }
        if (this.servletLogger || "servlet_log".equals(this.name)) {
            this.name = "org/apache/tomcat/facade";
        }
        if (ctx != null) {
            this.name = this.name + "/" + ctx.getId();
        }
        this.createLogger(logManager, logDaemon);
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        LogDaemon logDaemon = (LogDaemon)cm.getNote("tc.LogDaemon");
        logDaemon.start();
    }

    public void engineShutdown(ContextManager cm) throws TomcatException {
        LogDaemon logDaemon;
        if (this.getContext() != null) {
            return;
        }
        if (this.debug > 0) {
            this.log("Stopping the logger " + this.name);
        }
        cm.getLog().flush();
        if (this.ql != null) {
            this.ql.flush();
        }
        if ((logDaemon = (LogDaemon)cm.getNote("tc.LogDaemon")) != null) {
            try {
                logDaemon.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        if ("org/apache/tomcat/facade".equals(this.name) && ctx.getServletLog() == null) {
            ctx.setServletLog(Log.getLog((String)this.name, (String)ctx.getId()));
        }
    }

    private void createLogger(LogManager logManager, LogDaemon logDaemon) {
        if (this.debug > 0) {
            this.log("Constructing logger " + this.name + " " + this.path + " " + this.ctx);
        }
        this.ql = new QueueLogger();
        this.ql.setLogDaemon(logDaemon);
        if (!this.timestamps) {
            this.ql.setTimestamp("false");
        }
        if (this.tsFormat != null) {
            this.ql.setTimestampFormat(this.tsFormat);
        }
        if (this.path != null) {
            this.ql.setPath(this.path);
        }
        if (this.verbosityLevel != null) {
            this.ql.setVerbosityLevel(this.verbosityLevel);
        }
        this.ql.open();
        logManager.addChannel(this.name, (LogHandler)this.ql);
        if ("org/apache/tomcat/core".equals(this.name)) {
            this.cm.setLog(Log.getLog((String)this.name, (String)"ContextManager"));
        }
        if (this.ctx != null) {
            if (this.servletLogger) {
                this.ctx.setServletLog(Log.getLog((String)this.name, (String)this.ctx.getId()));
            } else {
                this.ctx.setLog(Log.getLog((String)this.name, (String)this.ctx.getId()));
            }
        }
    }

    static class TomcatLogManager
    extends LogManager {
        TomcatLogManager() {
            LogManager olm = Log.setLogManager((LogManager)this);
            this.loggers = olm.getLoggers();
            this.channels = olm.getChannels();
        }
    }
}

