/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.compat.SimpleClassLoader;

public class LoaderInterceptor11
extends BaseInterceptor {
    boolean useAppsL = true;
    boolean useParentL = false;
    boolean useCommonL = false;
    boolean useContainerL = false;
    boolean useNoParent = false;
    boolean use11Loader = false;
    boolean addJaxp = true;
    private int attributeInfo;
    String loader = null;
    Vector jaxpJars = new Vector();
    String jaxpJarsSDefault = "jaxp.jar:crimson.jar:xalan.jar:xerces.jar";
    String jaxpJarsS = null;
    String jaxpDir = null;
    Vector additionalJars = new Vector();
    String additionalJarsS = null;
    String jarSeparator = ":";
    static final String clAttribute = "org.apache.tomcat.classloader";
    private static final String separator = System.getProperty("path.separator", ":");
    static Jdk11Compat jdkProxy = Jdk11Compat.getJdkCompat();
    static final Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();

    public void setUseApplicationLoader(boolean b) {
        this.useAppsL = b;
    }

    public void setUseNoParent(boolean b) {
        this.useNoParent = b;
    }

    public void setUse11Loader(boolean b) {
        this.use11Loader = b;
    }

    public void setJaxpDir(String dir) {
        this.jaxpDir = dir;
    }

    public void setJaxpJars(String jars) {
        this.jaxpJarsS = jars;
    }

    public void setAdditionalJars(String jars) {
        this.additionalJarsS = jars;
    }

    public void setJarSeparator(String sep) {
        if (sep != null && sep.length() > 0) {
            if (sep.length() > 1) {
                sep = sep.substring(0, 1);
            }
            char[] oldSep = new char[1];
            char[] newSep = new char[1];
            this.jarSeparator.getChars(0, 1, oldSep, 0);
            sep.getChars(0, 1, newSep, 0);
            this.jaxpJarsSDefault = this.jaxpJarsSDefault.replace(oldSep[0], newSep[0]);
            this.jarSeparator = sep;
        }
    }

    public void setJaxp(boolean b) {
        this.addJaxp = b;
    }

    public void setLoader(String name) {
        this.loader = name;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.attributeInfo = cm.getNoteId(2, "req.attribute");
        this.initJaxpJars();
        this.initAdditionalJars();
    }

    public void addContext(ContextManager cm, Context context) throws TomcatException {
        String base = context.getAbsolutePath();
        File dir = new File(base + "/WEB-INF/classes");
        if (dir.exists()) {
            try {
                URL url = new URL("file", null, dir.getAbsolutePath().replace('\\', '/') + "/");
                context.addClassPath(url);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        File f = new File(base + "/WEB-INF/lib");
        Vector jars = new Vector();
        this.getJars(jars, f);
        for (int i = 0; i < jars.size(); ++i) {
            String jarfile = (String)jars.elementAt(i);
            File jf = new File(f, jarfile);
            String absPath = jf.getAbsolutePath().replace('\\', '/');
            try {
                URL url = new URL("file", null, absPath);
                context.addClassPath(url);
                continue;
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        if (ctx.getAttribute(clAttribute) == null) {
            this.prepareClassLoader(ctx);
        }
    }

    public void copyContext(Request req, Context oldC, Context newC) throws TomcatException {
        if (this.debug > 0) {
            this.log("Reload event " + newC.getPath());
        }
        ClassLoader oldLoader = oldC.getClassLoader();
        newC.getContainer().setNote("oldLoader", (Object)oldLoader);
    }

    public void reload(Request req, Context context) throws TomcatException {
        if (this.debug > 0) {
            this.log("Reload event " + context.getPath());
        }
        ClassLoader oldLoader = context.getClassLoader();
        context.getContainer().setNote("oldLoader", (Object)oldLoader);
        ClassLoader loader = this.constructLoader(context);
        if (this.debug > 5) {
            URL[] classP = context.getClassPath();
            this.log("  Context classpath URLs:");
            for (int i = 0; i < classP.length; ++i) {
                this.log("    " + classP[i].toString());
            }
        }
        context.setClassLoader(loader);
        context.setAttribute(clAttribute, (Object)loader);
    }

    public void prepareClassLoader(Context context) throws TomcatException {
        boolean hasJaxp;
        String list = context.getProperty("additionalJars");
        if (list != null) {
            Vector urls = new Vector();
            this.getUrls(null, list, urls);
            Enumeration en = urls.elements();
            while (en.hasMoreElements()) {
                URL url = (URL)en.nextElement();
                if (this.debug > 0) {
                    this.log(context + " adding: " + url);
                }
                context.addClassPath(url);
            }
        }
        Enumeration en = this.additionalJars.elements();
        while (en.hasMoreElements()) {
            URL url = (URL)en.nextElement();
            if (this.debug > 0) {
                this.log(context + " adding: " + url);
            }
            context.addClassPath(url);
        }
        ClassLoader loader = this.constructLoader(context);
        if (this.addJaxp && !(hasJaxp = this.checkJaxp(loader, context))) {
            en = this.jaxpJars.elements();
            while (en.hasMoreElements()) {
                URL url = (URL)en.nextElement();
                if (this.debug > 0) {
                    this.log(context + " adding jaxp: " + url);
                }
                context.addClassPath(url);
            }
            loader = this.constructLoader(context);
        }
        if (this.debug > 5) {
            URL[] classP = context.getClassPath();
            this.log("  Context classpath URLs:");
            for (int i = 0; i < classP.length; ++i) {
                this.log("    " + classP[i].toString());
            }
        }
        context.setClassLoader(loader);
        context.setAttribute(clAttribute, (Object)loader);
    }

    protected ClassLoader constructLoader(Context context) throws TomcatException {
        URL[] classP = context.getClassPath();
        ClassLoader parent = null;
        if (this.useNoParent) {
            if (this.debug > 0) {
                this.log("Using no parent loader ");
            }
            parent = null;
        } else if (this.useAppsL && !context.isTrusted()) {
            if (this.debug > 0) {
                this.log("Using webapp loader ");
            }
            parent = this.cm.getAppsLoader();
        } else {
            if (this.debug > 0) {
                this.log("Using container loader ");
            }
            parent = ((Object)((Object)this)).getClass().getClassLoader();
        }
        ClassLoader loader = null;
        loader = this.use11Loader ? new SimpleClassLoader(classP, parent) : jdk11Compat.newClassLoaderInstance(classP, parent);
        if (this.debug > 0) {
            this.log("Loader " + loader.getClass().getName() + " " + parent);
        }
        return loader;
    }

    private void initJaxpJars() {
        if (this.jaxpJarsS == null) {
            this.jaxpJarsS = this.jaxpJarsSDefault;
        }
        this.getUrls(this.jaxpDir, this.jaxpJarsS, this.jaxpJars);
    }

    private void initAdditionalJars() {
        if (this.additionalJarsS != null) {
            this.getUrls(null, this.additionalJarsS, this.additionalJars);
        }
    }

    private void getUrls(String dir, String jarList, Vector jars) {
        if (dir == null) {
            dir = this.cm.getInstallDir() + "/lib/container";
        }
        File base = new File(dir);
        if (this.debug > 5) {
            this.log("Scanning \"" + jarList + "\" with base directory " + base);
        }
        StringTokenizer st = new StringTokenizer(jarList, this.jarSeparator);
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            File f = new File(s);
            if (!f.isAbsolute()) {
                f = new File(base, s);
            }
            if (!f.exists()) continue;
            try {
                URL url = new URL("file", null, f.getAbsolutePath().replace('\\', '/'));
                jars.addElement(url);
                if (this.debug <= 5) continue;
                this.log("Adding " + url);
            }
            catch (MalformedURLException ex) {}
        }
    }

    private boolean checkJaxp(ClassLoader loader, Context context) {
        try {
            loader.loadClass("javax.xml.parsers.SAXParserFactory");
            return true;
        }
        catch (Exception ex) {
            if (this.debug > 0) {
                context.log("Jaxp not detected, adding jaxp ");
            }
            return false;
        }
    }

    public final Object getInfo(Context ctx, Request req, int info, String k) {
        if (req != null) {
            return null;
        }
        if (info == this.attributeInfo) {
            if (!k.startsWith("org.apache.tomcat")) {
                return null;
            }
            if (k.equals("org.apache.tomcat.jsp_classpath")) {
                return this.getClassPath(ctx);
            }
            if (k.equals(clAttribute)) {
                return ctx.getClassLoader();
            }
        }
        return null;
    }

    private String getClassPath(Context ctx) {
        StringBuffer cpath = new StringBuffer();
        URL[] classPaths = ctx.getClassPath();
        this.convertClassPath(cpath, classPaths);
        ClassLoader Loader = ctx.getClassLoader();
        this.convertClassPath(cpath, jdkProxy.getURLs(Loader, 1));
        this.convertClassPath(cpath, jdkProxy.getURLs(Loader, 2));
        if (this.debug > 9) {
            this.log("Getting classpath " + cpath);
        }
        return cpath.toString();
    }

    private void convertClassPath(StringBuffer cpath, URL[] classPaths) {
        if (classPaths == null) {
            return;
        }
        for (int i = 0; i < classPaths.length; ++i) {
            URL cp = classPaths[i];
            if (cpath.length() > 0) {
                cpath.append(separator);
            }
            cpath.append(cp.getFile());
        }
    }

    private void getJars(Vector v, File f) {
        FilenameFilter jarfilter = new FilenameFilter(){

            public boolean accept(File dir, String fname) {
                return fname.endsWith(".jar");
            }
        };
        FilenameFilter dirfilter = new FilenameFilter(){

            public boolean accept(File dir, String fname) {
                File f1 = new File(dir, fname);
                return f1.isDirectory();
            }
        };
        if (f.exists() && f.isDirectory() && f.isAbsolute()) {
            String[] jarlist = f.list(jarfilter);
            for (int i = 0; jarlist != null && i < jarlist.length; ++i) {
                v.addElement(jarlist[i]);
            }
            String[] dirlist = f.list(dirfilter);
            for (int i = 0; dirlist != null && i < dirlist.length; ++i) {
                File dir = new File(f, dirlist[i]);
                this.getJars(v, dir);
            }
        }
    }
}

