/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.server.Ajp12Interceptor;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.log.Log;

public class JservConfig
extends BaseInterceptor {
    public static final String APACHE_CONFIG = "conf/auto/tomcat-apache.conf";
    public static final String JSERV_LOG_LOCATION = "logs/mod_jserv.log";
    public static String MOD_JSERV;
    public static final String AJPV12 = "ajpv12";
    private File configHome = null;
    private File jservConfig = null;
    private File modJserv = null;
    private File jservLog = null;
    private String tomcatHome;
    private String jservDebug = null;
    private boolean noRoot = true;
    boolean forwardAll = true;
    Hashtable NamedVirtualHosts = null;
    String indent = "";

    public void engineState(ContextManager cm, int state) throws TomcatException {
        if (state != 2) {
            return;
        }
        this.execute(cm);
    }

    public void contextInit(Context ctx) throws TomcatException {
        ContextManager cm = ctx.getContextManager();
        if (cm.getState() >= 2) {
            this.execute(cm);
        }
    }

    public void setForwardAll(boolean b) {
        this.forwardAll = b;
    }

    public void setNoRoot(boolean b) {
        this.noRoot = b;
    }

    public void setConfigHome(String dir) {
        if (dir == null) {
            return;
        }
        File f = new File(dir);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("JservConfig.setConfigHome(): Configuration Home must be a directory! : " + dir);
        }
        this.configHome = f;
    }

    public File getConfigHome() {
        return this.configHome;
    }

    public void setJservConfig(String path) {
        this.setJservConfig(path == null ? null : new File(path));
    }

    public void setJservConfig(File path) {
        this.jservConfig = path;
    }

    public void setModJserv(String path) {
        this.setModJserv(path == null ? null : new File(path));
    }

    public void setModJserv(File path) {
        this.modJserv = path;
    }

    public void setJservLog(String path) {
        this.jservLog = path == null ? null : new File(path);
    }

    public void setJservDebug(String level) {
        this.jservDebug = null;
    }

    public void initProperties(ContextManager cm) {
        this.tomcatHome = cm.getHome();
        File tomcatDir = new File(this.tomcatHome);
        if (this.configHome == null) {
            this.configHome = tomcatDir;
        }
        this.jservConfig = FileUtil.getConfigFile((File)this.jservConfig, (File)this.configHome, (String)APACHE_CONFIG);
        this.modJserv = this.modJserv == null ? new File(MOD_JSERV) : FileUtil.getConfigFile((File)this.modJserv, (File)this.configHome, (String)MOD_JSERV);
        this.jservLog = FileUtil.getConfigFile((File)this.jservLog, (File)this.configHome, (String)JSERV_LOG_LOCATION);
    }

    public void execute(ContextManager cm) throws TomcatException {
        try {
            this.initProperties(cm);
            this.NamedVirtualHosts = new Hashtable();
            PrintWriter pw = new PrintWriter(new FileWriter(this.jservConfig));
            this.log("Generating apache mod_jserv config = " + this.jservConfig);
            this.generateJservHead(pw, cm);
            Hashtable<String, Vector<Context>> vhosts = new Hashtable<String, Vector<Context>>();
            Enumeration enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String host = context.getHost();
                if (host == null) {
                    if (this.forwardAll) {
                        this.generateStupidMappings(context, pw);
                        continue;
                    }
                    this.generateContextMappings(context, pw);
                    continue;
                }
                Vector<Context> vhostContexts = (Vector<Context>)vhosts.get(host);
                if (vhostContexts == null) {
                    vhostContexts = new Vector<Context>();
                    vhosts.put(host, vhostContexts);
                }
                vhostContexts.addElement(context);
            }
            enumeration = vhosts.elements();
            while (enumeration.hasMoreElements()) {
                Vector vhostContexts = (Vector)enumeration.nextElement();
                for (int i = 0; i < vhostContexts.size(); ++i) {
                    Context context = (Context)vhostContexts.elementAt(i);
                    if (i == 0) {
                        this.generateVhostHead(context, pw);
                    }
                    if (this.forwardAll) {
                        this.generateStupidMappings(context, pw);
                        continue;
                    }
                    this.generateContextMappings(context, pw);
                }
                this.generateVhostTail(pw);
            }
            pw.close();
        }
        catch (Exception ex) {
            Log loghelper = Log.getLog((String)"tc_log", (Object)((Object)this));
            loghelper.log("Error generating automatic apache mod_jserv configuration", (Throwable)ex);
        }
    }

    private boolean generateJservHead(PrintWriter pw, ContextManager cm) throws TomcatException {
        pw.println("<IfModule !mod_jserv.c>");
        pw.println("  LoadModule jserv_module " + this.modJserv.toString().replace('\\', '/'));
        pw.println("</IfModule>");
        pw.println("ApJServManual on");
        pw.println("ApJServDefaultProtocol ajpv12");
        pw.println("ApJServSecretKey DISABLED");
        pw.println("ApJServMountCopy on");
        pw.println("ApJServLogLevel notice");
        pw.println();
        int portInt = 8007;
        BaseInterceptor[] ci = cm.getContainer().getInterceptors();
        for (int i = 0; i < ci.length; ++i) {
            BaseInterceptor con = ci[i];
            if (!(con instanceof Ajp12Interceptor)) continue;
            Ajp12Interceptor tcpCon = (Ajp12Interceptor)con;
            portInt = tcpCon.getPort();
        }
        pw.println("ApJServDefaultPort " + portInt);
        pw.println();
        return true;
    }

    private void generateVhostHead(Context context, PrintWriter pw) {
        String ctxPath = context.getPath();
        String vhost = context.getHost();
        pw.println();
        String vhostip = this.getVirtualHostAddress(vhost, context.getHostAddress());
        this.generateNameVirtualHost(pw, vhostip);
        pw.println("<VirtualHost " + vhostip + ">");
        pw.println("    ServerName " + vhost);
        Enumeration aliases = context.getHostAliases();
        if (aliases.hasMoreElements()) {
            pw.print("    ServerAlias ");
            while (aliases.hasMoreElements()) {
                pw.print((String)aliases.nextElement() + " ");
            }
            pw.println();
        }
        this.indent = "    ";
    }

    private void generateVhostTail(PrintWriter pw) {
        pw.println("</VirtualHost>");
        this.indent = "";
    }

    private void generateStupidMappings(Context context, PrintWriter pw) {
        String nPath;
        String ctxPath = context.getPath();
        String vhost = context.getHost();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        pw.println();
        pw.println(this.indent + "ApJServMount " + nPath + " " + nPath);
        if ("".equals(ctxPath)) {
            pw.println(this.indent + "ApJServMount " + nPath + "* " + nPath);
            if (vhost != null) {
                pw.println(this.indent + "DocumentRoot \"" + this.getApacheDocBase(context) + "\"");
            } else {
                pw.println(this.indent + "# To avoid Apache serving root welcome files from htdocs, update DocumentRoot");
                pw.println(this.indent + "# to point to: \"" + this.getApacheDocBase(context) + "\"");
            }
        } else {
            pw.println(this.indent + "ApJServMount " + nPath + "/* " + nPath);
        }
    }

    private void generateNameVirtualHost(PrintWriter pw, String ip) {
        if (!this.NamedVirtualHosts.containsKey(ip)) {
            pw.println("NameVirtualHost " + ip + "");
            this.NamedVirtualHosts.put(ip, ip);
        }
    }

    private void generateContextMappings(Context context, PrintWriter pw) {
        String ctxPath = context.getPath();
        String vhost = context.getHost();
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in non-forward-all mode  ");
            return;
        }
        pw.println();
        pw.println("#################### " + (vhost != null ? vhost + ":" : "") + ("".equals(ctxPath) ? "/" : ctxPath) + " ####################");
        pw.println();
        this.generateStaticMappings(context, pw);
        this.addMapping(ctxPath + "/servlet/*", ctxPath, pw);
        Enumeration servletMaps = context.getContainers();
        while (servletMaps.hasMoreElements()) {
            Container ct = (Container)servletMaps.nextElement();
            this.addMapping(context, ct, pw);
        }
    }

    protected boolean addMapping(Context ctx, Container ct, PrintWriter pw) {
        int type = ct.getMapType();
        String ctPath = ct.getPath();
        String ctxPath = ctx.getPath();
        if (type == 3) {
            if (ctPath.length() < 3) {
                return false;
            }
            String ext = ctPath.substring(2);
            return this.addExtensionMapping(ctxPath, ext, pw);
        }
        String fullPath = null;
        fullPath = ctPath.startsWith("/") ? ctxPath + ctPath : ctxPath + "/" + ctPath;
        return this.addMapping(fullPath, ctxPath, pw);
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter pw) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        pw.println(this.indent + "AddHandler jserv-servlet ." + ext);
        if ("jsp".equals(ext)) {
            pw.println(this.indent + "# Forward non-cookie session requests");
            pw.println(this.indent + "<LocationMatch \"" + ctxPath + "/.*;jsessionid=.*\">");
            pw.println(this.indent + "    SetHandler jserv-servlet");
            pw.println(this.indent + "</LocationMatch>");
        }
        return true;
    }

    protected boolean addMapping(String fullPath, String app, PrintWriter pw) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        pw.println(this.indent + "ApJServMount " + fullPath + "  " + app);
        return true;
    }

    private void generateWelcomeFiles(Context context, PrintWriter pw) {
        String[] wf = context.getWelcomeFiles();
        if (wf == null || wf.length == 0) {
            return;
        }
        pw.print(this.indent + "    DirectoryIndex ");
        for (int i = 0; i < wf.length; ++i) {
            pw.print(wf[i] + " ");
        }
        pw.println();
    }

    private void generateStaticMappings(Context context, PrintWriter pw) {
        String ctxPath = context.getPath();
        String docBase = this.getApacheDocBase(context);
        if (!"".equals(ctxPath)) {
            pw.println(this.indent + "# Static files ");
            pw.println(this.indent + "Alias " + ctxPath + " \"" + docBase + "\"");
            pw.println();
        } else if (context.getHost() != null) {
            pw.println(this.indent + "DocumentRoot \"" + this.getApacheDocBase(context) + "\"");
        } else {
            pw.println(this.indent + "# Be sure to update DocumentRoot");
            pw.println(this.indent + "# to point to: \"" + docBase + "\"");
        }
        pw.println(this.indent + "<Directory \"" + docBase + "\">");
        pw.println(this.indent + "    Options Indexes FollowSymLinks");
        this.generateWelcomeFiles(context, pw);
        pw.println(this.indent + "</Directory>");
        pw.println();
        pw.println();
        pw.println(this.indent + "# Deny direct access to WEB-INF and META-INF");
        pw.println(this.indent + "#");
        pw.println(this.indent + "<Location \"" + ctxPath + "/WEB-INF/*\">");
        pw.println(this.indent + "    AllowOverride None");
        pw.println(this.indent + "    deny from all");
        pw.println(this.indent + "</Location>");
        pw.println();
        pw.println(this.indent + "<Location \"" + ctxPath + "/META-INF/*\">");
        pw.println(this.indent + "    AllowOverride None");
        pw.println(this.indent + "    deny from all");
        pw.println(this.indent + "</Location>");
        if (File.separatorChar == '\\') {
            pw.println(this.indent + "#");
            pw.println(this.indent + "# Use Directory too. On Windows, Location doesn't" + " work unless case matches");
            pw.println(this.indent + "#");
            pw.println(this.indent + "<Directory \"" + docBase + "/WEB-INF/\">");
            pw.println(this.indent + "    AllowOverride None");
            pw.println(this.indent + "    deny from all");
            pw.println(this.indent + "</Directory>");
            pw.println();
            pw.println(this.indent + "<Directory \"" + docBase + "/META-INF/\">");
            pw.println(this.indent + "    AllowOverride None");
            pw.println(this.indent + "    deny from all");
            pw.println(this.indent + "</Directory>");
        }
        pw.println();
    }

    private String getAbsoluteDocBase(Context context) {
        String docBase = context.getDocBase();
        if (!FileUtil.isAbsolute((String)docBase)) {
            docBase = this.tomcatHome + "/" + docBase;
        }
        docBase = FileUtil.patch((String)docBase);
        return docBase;
    }

    private String getApacheDocBase(Context context) {
        String docBase = this.getAbsoluteDocBase(context);
        if (File.separatorChar == '\\') {
            docBase = docBase.replace('\\', '/');
        }
        return docBase;
    }

    private String getVirtualHostAddress(String vhost, String vhostip) {
        if (vhostip == null) {
            vhostip = vhost != null && vhost.length() > 0 && Character.isDigit(vhost.charAt(0)) ? vhost : "*";
        }
        return vhostip;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        MOD_JSERV = os.indexOf("windows") >= 0 ? "modules/ApacheModuleJserv.dll" : "libexec/mod_jserv.so";
    }
}

