/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.PrintWriter;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.server.Ajp13Interceptor;
import org.apache.tomcat.util.io.FileUtil;

public class BaseJkConfig
extends BaseInterceptor {
    protected File configHome = null;
    protected File workersConfig = null;
    protected File jkLog = null;
    protected String jkDebug = "emerg";
    protected String jkWorker = null;
    protected boolean noRoot = true;
    protected boolean forwardAll = true;
    protected String tomcatHome;
    protected boolean regenerate = false;

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor bi) throws TomcatException {
        if (cm.getProperty("jkconf") != null) {
            // empty if block
        }
    }

    public void engineState(ContextManager cm, int state) throws TomcatException {
        if (state != 2) {
            return;
        }
        if (this.regenerate || cm.getProperty("jkconf") != null) {
            this.execute(cm);
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        ContextManager cm = ctx.getContextManager();
        if (cm.getState() >= 2 && (this.regenerate || cm.getProperty("jkconf") != null)) {
            this.execute(cm);
        }
    }

    public void execute(ContextManager cm) throws TomcatException {
    }

    public void setForwardAll(boolean b) {
        this.forwardAll = b;
    }

    public void setNoRoot(boolean b) {
        this.noRoot = b;
    }

    public void setConfigHome(String dir) {
        if (dir == null) {
            return;
        }
        File f = new File(dir);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("BaseConfig.setConfigHome(): Configuration Home must be a directory! : " + dir);
        }
        this.configHome = f;
    }

    public void setWorkersConfig(String path) {
        this.workersConfig = path == null ? null : new File(path);
    }

    public void setJkLog(String path) {
        this.jkLog = path == null ? null : new File(path);
    }

    public void setJkDebug(String level) {
        this.jkDebug = level;
    }

    public void setJkWorker(String worker) {
        this.jkWorker = worker;
    }

    protected void initProperties(ContextManager cm) {
        this.tomcatHome = cm.getHome();
        File tomcatDir = new File(this.tomcatHome);
        if (this.configHome == null) {
            this.configHome = tomcatDir;
        }
    }

    protected void initWorker(ContextManager cm) {
        BaseInterceptor[] ci = cm.getContainer().getInterceptors();
        for (int i = 0; i < ci.length; ++i) {
            BaseInterceptor con = ci[i];
            if (this.jkWorker != null || !(con instanceof Ajp13Interceptor)) continue;
            this.jkWorker = "ajp13";
        }
        if (this.jkWorker == null) {
            this.jkWorker = "ajp12";
        }
    }

    protected boolean addMapping(Context ctx, Container ct, PrintWriter pw) {
        int type = ct.getMapType();
        String ctPath = ct.getPath();
        String ctxPath = ctx.getPath();
        if (type == 3) {
            if (ctPath.length() < 3) {
                return false;
            }
            String ext = ctPath.substring(2);
            return this.addExtensionMapping(ctxPath, ext, pw);
        }
        String fullPath = null;
        fullPath = ctPath.startsWith("/") ? ctxPath + ctPath : ctxPath + "/" + ctPath;
        return this.addMapping(fullPath, pw);
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter pw) {
        return true;
    }

    protected boolean addMapping(String fullPath, PrintWriter pw) {
        return true;
    }

    protected String getAbsoluteDocBase(Context context) {
        String docBase = context.getDocBase();
        if (!FileUtil.isAbsolute((String)docBase)) {
            docBase = this.tomcatHome + "/" + docBase;
        }
        docBase = FileUtil.patch((String)docBase);
        return docBase;
    }
}

