/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.depend.DependManager;
import org.apache.tomcat.util.depend.Dependency;
import org.apache.tomcat.util.io.FileUtil;

public class AutoDeploy
extends BaseInterceptor {
    Hashtable hosts = new Hashtable();
    String src = "webapps";
    String dest = "webapps";
    boolean redeploy = false;
    File webappS;
    File webappD;
    Hashtable expanded = new Hashtable();

    public void setSource(String d) {
        this.src = d;
    }

    public void setTarget(String d) {
        this.dest = d;
    }

    public void setFlat(boolean b) {
    }

    public void setRedeploy(boolean b) {
        this.redeploy = b;
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
        if (this != module) {
            return;
        }
        String home = cm.getHome();
        this.webappS = this.src.startsWith("/") ? new File(this.src) : new File(home + "/" + this.src);
        this.webappD = this.dest.startsWith("/") ? new File(this.dest) : new File(home + "/" + this.dest);
        if (!(this.webappD.exists() && this.webappD.isDirectory() && this.webappS.exists() && this.webappS.isDirectory())) {
            this.log("Source or destination missing ");
            return;
        }
        String[] list = this.webappS.list();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            File f = new File(this.webappS, name);
            if (!name.endsWith(".war")) continue;
            this.expandWar(this.webappS, this.webappD, name);
        }
    }

    private void expandWar(File srcD, File destD, String name) {
        String fname = name.substring(0, name.length() - 4);
        File appDir = new File(destD, fname);
        File srcF = new File(srcD, name);
        this.expanded.put(appDir.getAbsolutePath(), new DeployInfo(srcD, destD, srcF, appDir, name));
        if (this.redeploy && appDir.exists() && appDir.lastModified() < srcF.lastModified()) {
            this.log("WAR file is newer, removing old dir " + srcF + " " + name);
            FileUtil.clearDir((File)appDir);
        }
        if (!appDir.exists()) {
            appDir.mkdirs();
            this.log("Expanding " + srcF);
            try {
                FileUtil.expand((String)srcF.getAbsolutePath(), (String)appDir.getAbsolutePath());
            }
            catch (IOException ex) {
                this.log("expanding webapp " + name, ex);
            }
        }
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        if (this.redeploy) {
            String ctxBase = ctx.getAbsolutePath();
            DeployInfo dInfo = (DeployInfo)this.expanded.get(ctxBase);
            if (dInfo == null || !dInfo.srcF.exists()) {
                return;
            }
            if (dInfo.appDir.exists() && dInfo.appDir.lastModified() < dInfo.srcF.lastModified()) {
                this.log("WAR file is newer, removing old dir " + dInfo.srcF + " " + dInfo.name);
                FileUtil.clearDir((File)dInfo.appDir);
                dInfo.appDir.mkdirs();
                this.log("Expanding " + dInfo.srcF);
                try {
                    FileUtil.expand((String)dInfo.srcF.getAbsolutePath(), (String)dInfo.appDir.getAbsolutePath());
                }
                catch (IOException ex) {
                    this.log("expanding webapp " + dInfo.name, ex);
                }
            }
        }
    }

    public void contextInit(Context context) throws TomcatException {
        if (this.redeploy) {
            String ctxBase = context.getAbsolutePath();
            DeployInfo dInfo = (DeployInfo)this.expanded.get(ctxBase);
            if (dInfo == null || !dInfo.srcF.exists()) {
                return;
            }
            File warFile = dInfo.srcF;
            DependManager dm = (DependManager)context.getContainer().getNote("DependManager");
            if (dm != null) {
                this.log("Adding dependency " + context + " -> " + warFile);
                Dependency dep = new Dependency();
                dep.setTarget((Object)"web.xml");
                dep.setOrigin(warFile);
                dep.setLastModified(warFile.lastModified());
                dm.addDependency(dep);
                context.getContainer().setNote("autoDeploy.war", (Object)dInfo);
            } else {
                this.log("No reloading for " + context + " -> " + warFile);
            }
        }
    }

    public void reload(Request req, Context context) throws TomcatException {
        this.log("Reloading " + this.redeploy);
        if (this.redeploy) {
            DeployInfo dI = (DeployInfo)context.getContainer().getNote("autoDeploy.war");
            if (dI == null) {
                return;
            }
            this.log("Re-deploying " + dI.srcF);
            this.log("Removing " + dI.appDir);
            FileUtil.clearDir((File)dI.appDir);
            this.expandWar(dI.srcD, dI.destD, dI.name);
        }
    }

    static class DeployInfo {
        File srcD;
        File destD;
        File srcF;
        File appDir;
        String name;

        DeployInfo(File srcD, File destD, File srcF, File appDir, String name) {
            this.srcD = srcD;
            this.srcF = srcF;
            this.destD = destD;
            this.appDir = appDir;
            this.name = name;
        }
    }
}

