/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.BaseJkConfig;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.log.Log;

public class ApacheConfig
extends BaseJkConfig {
    public static final String MOD_JK_CONFIG = "conf/auto/mod_jk.conf";
    public static final String WORKERS_CONFIG = "conf/jk/workers.properties";
    public static final String JK_LOG_LOCATION = "logs/mod_jk.log";
    public static String MOD_JK;
    private File jkConfig = null;
    private File modJk = null;
    private boolean sslExtract = true;
    private String sslHttpsIndicator = "HTTPS";
    private String sslSessionIndicator = "SSL_SESSION_ID";
    private String sslCipherIndicator = "SSL_CIPHER";
    private String sslCertsIndicator = "SSL_CLIENT_CERT";
    Hashtable NamedVirtualHosts = null;
    String indent = "";

    public void setJkConfig(String path) {
        this.jkConfig = path == null ? null : new File(path);
    }

    public void setModJk(String path) {
        this.modJk = path == null ? null : new File(path);
    }

    public void setExtractSSL(boolean sslMode) {
        this.sslExtract = sslMode;
    }

    public void setHttpsIndicator(String s) {
        this.sslHttpsIndicator = s;
    }

    public void setSessionIndicator(String s) {
        this.sslSessionIndicator = s;
    }

    public void setCipherIndicator(String s) {
        this.sslCipherIndicator = s;
    }

    public void setCertsIndicator(String s) {
        this.sslCertsIndicator = s;
    }

    protected void initProperties(ContextManager cm) {
        super.initProperties(cm);
        this.jkConfig = FileUtil.getConfigFile((File)this.jkConfig, (File)this.configHome, (String)MOD_JK_CONFIG);
        this.workersConfig = FileUtil.getConfigFile((File)this.workersConfig, (File)this.configHome, (String)WORKERS_CONFIG);
        this.modJk = this.modJk == null ? new File(MOD_JK) : FileUtil.getConfigFile((File)this.modJk, (File)this.configHome, (String)MOD_JK);
        this.jkLog = FileUtil.getConfigFile((File)this.jkLog, (File)this.configHome, (String)JK_LOG_LOCATION);
    }

    public void execute(ContextManager cm) throws TomcatException {
        try {
            this.initProperties(cm);
            this.initWorker(cm);
            this.NamedVirtualHosts = new Hashtable();
            StringBuffer sb = new StringBuffer();
            PrintWriter mod_jk = new PrintWriter(new FileWriter(this.jkConfig));
            this.log("Generating apache mod_jk config = " + this.jkConfig);
            this.generateJkHead(mod_jk);
            this.generateSSLConfig(mod_jk);
            Hashtable<String, Vector<Context>> vhosts = new Hashtable<String, Vector<Context>>();
            Enumeration enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String host = context.getHost();
                if (host == null) {
                    if (this.forwardAll) {
                        this.generateStupidMappings(context, mod_jk);
                        continue;
                    }
                    this.generateContextMappings(context, mod_jk);
                    continue;
                }
                Vector<Context> vhostContexts = (Vector<Context>)vhosts.get(host);
                if (vhostContexts == null) {
                    vhostContexts = new Vector<Context>();
                    vhosts.put(host, vhostContexts);
                }
                vhostContexts.addElement(context);
            }
            enumeration = vhosts.elements();
            while (enumeration.hasMoreElements()) {
                Vector vhostContexts = (Vector)enumeration.nextElement();
                for (int i = 0; i < vhostContexts.size(); ++i) {
                    Context context = (Context)vhostContexts.elementAt(i);
                    if (i == 0) {
                        this.generateVhostHead(context, mod_jk);
                    }
                    if (this.forwardAll) {
                        this.generateStupidMappings(context, mod_jk);
                        continue;
                    }
                    this.generateContextMappings(context, mod_jk);
                }
                this.generateVhostTail(mod_jk);
            }
            mod_jk.close();
        }
        catch (Exception ex) {
            Log loghelper = Log.getLog((String)"tc_log", (Object)((Object)this));
            loghelper.log("Error generating automatic apache configuration", (Throwable)ex);
        }
    }

    private boolean generateJkHead(PrintWriter mod_jk) throws TomcatException {
        mod_jk.println("########## Auto generated on " + new Date() + "##########");
        mod_jk.println();
        if (!this.modJk.exists()) {
            this.log("mod_jk location: " + this.modJk);
            this.log("Make sure it is installed corectly or  set the config location");
            this.log("Using <ApacheConfig modJk=\"PATH_TO_MOD_JK.SO_OR_DLL\" />");
        }
        mod_jk.println("<IfModule !mod_jk.c>");
        mod_jk.println("  LoadModule jk_module " + this.modJk.toString().replace('\\', '/'));
        mod_jk.println("</IfModule>");
        mod_jk.println();
        if (!this.workersConfig.exists()) {
            this.log("Can't find workers.properties at " + this.workersConfig);
            this.log("Please install it in the default location or  set the config location");
            this.log("Using <ApacheConfig workersConfig=\"FULL_PATH\" />");
            throw new TomcatException("workers.properties not found ");
        }
        mod_jk.println("JkWorkersFile \"" + this.workersConfig.toString().replace('\\', '/') + "\"");
        mod_jk.println("JkLogFile \"" + this.jkLog.toString().replace('\\', '/') + "\"");
        mod_jk.println();
        if (this.jkDebug != null) {
            mod_jk.println("JkLogLevel " + this.jkDebug);
            mod_jk.println();
        }
        return true;
    }

    private void generateVhostHead(Context context, PrintWriter mod_jk) {
        String ctxPath = context.getPath();
        String vhost = context.getHost();
        mod_jk.println();
        String vhostip = this.getVirtualHostAddress(vhost, context.getHostAddress());
        this.generateNameVirtualHost(mod_jk, vhostip);
        mod_jk.println("<VirtualHost " + vhostip + ">");
        mod_jk.println("    ServerName " + vhost);
        Enumeration aliases = context.getHostAliases();
        if (aliases.hasMoreElements()) {
            mod_jk.print("    ServerAlias ");
            while (aliases.hasMoreElements()) {
                mod_jk.print((String)aliases.nextElement() + " ");
            }
            mod_jk.println();
        }
        this.indent = "    ";
    }

    private void generateVhostTail(PrintWriter mod_jk) {
        mod_jk.println("</VirtualHost>");
        this.indent = "";
    }

    private void generateSSLConfig(PrintWriter mod_jk) {
        if (!this.sslExtract) {
            mod_jk.println("JkExtractSSL Off");
        }
        if (!"HTTPS".equalsIgnoreCase(this.sslHttpsIndicator)) {
            mod_jk.println("JkHTTPSIndicator " + this.sslHttpsIndicator);
        }
        if (!"SSL_SESSION_ID".equalsIgnoreCase(this.sslSessionIndicator)) {
            mod_jk.println("JkSESSIONIndicator " + this.sslSessionIndicator);
        }
        if (!"SSL_CIPHER".equalsIgnoreCase(this.sslCipherIndicator)) {
            mod_jk.println("JkCIPHERIndicator " + this.sslCipherIndicator);
        }
        if (!"SSL_CLIENT_CERT".equalsIgnoreCase(this.sslCertsIndicator)) {
            mod_jk.println("JkCERTSIndicator " + this.sslCertsIndicator);
        }
        mod_jk.println();
    }

    private void generateStupidMappings(Context context, PrintWriter mod_jk) {
        String nPath;
        String ctxPath = context.getPath();
        String vhost = context.getHost();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        mod_jk.println();
        mod_jk.println(this.indent + "JkMount " + nPath + " " + this.jkWorker);
        if ("".equals(ctxPath)) {
            mod_jk.println(this.indent + "JkMount " + nPath + "* " + this.jkWorker);
            if (vhost != null) {
                mod_jk.println(this.indent + "DocumentRoot \"" + this.getApacheDocBase(context) + "\"");
            } else {
                mod_jk.println(this.indent + "# To avoid Apache serving root welcome files from htdocs, update DocumentRoot");
                mod_jk.println(this.indent + "# to point to: \"" + this.getApacheDocBase(context) + "\"");
            }
        } else {
            mod_jk.println(this.indent + "JkMount " + nPath + "/* " + this.jkWorker);
        }
    }

    private void generateNameVirtualHost(PrintWriter mod_jk, String ip) {
        if (!this.NamedVirtualHosts.containsKey(ip)) {
            mod_jk.println("NameVirtualHost " + ip + "");
            this.NamedVirtualHosts.put(ip, ip);
        }
    }

    private void generateContextMappings(Context context, PrintWriter mod_jk) {
        String ctxPath = context.getPath();
        String vhost = context.getHost();
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in non-forward-all mode  ");
            return;
        }
        mod_jk.println();
        mod_jk.println(this.indent + "#################### " + (vhost != null ? vhost + ":" : "") + ("".equals(ctxPath) ? "/" : ctxPath) + " ####################");
        mod_jk.println();
        this.generateStaticMappings(context, mod_jk);
        this.addMapping(ctxPath + "/servlet/*", mod_jk);
        Enumeration servletMaps = context.getContainers();
        while (servletMaps.hasMoreElements()) {
            Container ct = (Container)servletMaps.nextElement();
            this.addMapping(context, ct, mod_jk);
        }
    }

    protected boolean addExtensionMapping(String ctxPath, String ext, PrintWriter mod_jk) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        mod_jk.println(this.indent + "JkMount " + ctxPath + "/*." + ext + " " + this.jkWorker);
        return true;
    }

    protected boolean addMapping(String fullPath, PrintWriter mod_jk) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        if (fullPath.endsWith("/*")) {
            mod_jk.println(this.indent + "JkMount " + fullPath.substring(0, fullPath.length() - 2) + "  " + this.jkWorker);
        }
        mod_jk.println(this.indent + "JkMount " + fullPath + "  " + this.jkWorker);
        return true;
    }

    private void generateWelcomeFiles(Context context, PrintWriter mod_jk) {
        String[] wf = context.getWelcomeFiles();
        if (wf == null || wf.length == 0) {
            return;
        }
        mod_jk.print(this.indent + "    DirectoryIndex ");
        for (int i = 0; i < wf.length; ++i) {
            mod_jk.print(wf[i] + " ");
        }
        mod_jk.println();
    }

    private void generateStaticMappings(Context context, PrintWriter mod_jk) {
        String ctxPath = context.getPath();
        String docBase = this.getApacheDocBase(context);
        if (!"".equals(ctxPath)) {
            mod_jk.println(this.indent + "# Static files ");
            mod_jk.println(this.indent + "Alias " + ctxPath + " \"" + docBase + "\"");
            mod_jk.println();
        } else if (context.getHost() != null) {
            mod_jk.println(this.indent + "DocumentRoot \"" + this.getApacheDocBase(context) + "\"");
        } else {
            mod_jk.println(this.indent + "# Be sure to update DocumentRoot");
            mod_jk.println(this.indent + "# to point to: \"" + docBase + "\"");
        }
        mod_jk.println(this.indent + "<Directory \"" + docBase + "\">");
        mod_jk.println(this.indent + "    Options Indexes FollowSymLinks");
        this.generateWelcomeFiles(context, mod_jk);
        mod_jk.println(this.indent + "</Directory>");
        mod_jk.println();
        mod_jk.println();
        mod_jk.println(this.indent + "# Deny direct access to WEB-INF and META-INF");
        mod_jk.println(this.indent + "#");
        mod_jk.println(this.indent + "<Location \"" + ctxPath + "/WEB-INF/*\">");
        mod_jk.println(this.indent + "    AllowOverride None");
        mod_jk.println(this.indent + "    deny from all");
        mod_jk.println(this.indent + "</Location>");
        mod_jk.println();
        mod_jk.println(this.indent + "<Location \"" + ctxPath + "/META-INF/*\">");
        mod_jk.println(this.indent + "    AllowOverride None");
        mod_jk.println(this.indent + "    deny from all");
        mod_jk.println(this.indent + "</Location>");
        if (File.separatorChar == '\\') {
            mod_jk.println(this.indent + "#");
            mod_jk.println(this.indent + "# Use Directory too. On Windows, Location doesn't" + " work unless case matches");
            mod_jk.println(this.indent + "#");
            mod_jk.println(this.indent + "<Directory \"" + docBase + "/WEB-INF/\">");
            mod_jk.println(this.indent + "    AllowOverride None");
            mod_jk.println(this.indent + "    deny from all");
            mod_jk.println(this.indent + "</Directory>");
            mod_jk.println();
            mod_jk.println(this.indent + "<Directory \"" + docBase + "/META-INF/\">");
            mod_jk.println(this.indent + "    AllowOverride None");
            mod_jk.println(this.indent + "    deny from all");
            mod_jk.println(this.indent + "</Directory>");
        }
        mod_jk.println();
    }

    private String getApacheDocBase(Context context) {
        String docBase = this.getAbsoluteDocBase(context);
        if (File.separatorChar == '\\') {
            docBase = docBase.replace('\\', '/');
        }
        return docBase;
    }

    private String getVirtualHostAddress(String vhost, String vhostip) {
        if (vhostip == null) {
            vhostip = vhost != null && vhost.length() > 0 && Character.isDigit(vhost.charAt(0)) ? vhost : "*";
        }
        return vhostip;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        MOD_JK = os.indexOf("windows") >= 0 ? "modules/mod_jk.dll" : (os.indexOf("netware") >= 0 ? "modules/mod_jk.nlm" : "libexec/mod_jk.so");
    }
}

