/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.aaa;

import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.aaa.RealmBase;
import org.apache.tomcat.util.aaa.SimplePrincipal;

public class JDBCRealm
extends RealmBase {
    private boolean started = false;
    private Connection dbConnection = null;
    private PreparedStatement preparedAuthenticate = null;
    private PreparedStatement preparedRoles = null;
    protected String connectionURL = null;
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String userTable = null;
    protected String userNameCol = null;
    protected String userCredCol = null;
    protected String userRoleTable = null;
    protected String roleNameCol = null;
    protected String driverName = null;
    protected boolean JDBCStarted = false;
    boolean connectOnInit = false;

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public boolean isConnectionNameSet() {
        return this.connectionName != null;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public boolean isConnectionPasswordSet() {
        return this.connectionPassword != null;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public void setConnectOnInit(boolean b) {
        this.connectOnInit = b;
    }

    public synchronized String getCredentials(String username) {
        try {
            if (!this.checkConnection()) {
                return null;
            }
            if (this.preparedAuthenticate == null) {
                this.preparedAuthenticate = this.getPreparedAuthenticate(this.dbConnection);
            }
            this.preparedAuthenticate.setString(1, username);
            ResultSet rs1 = this.preparedAuthenticate.executeQuery();
            if (rs1.next()) {
                return rs1.getString(1).trim();
            }
            rs1.close();
            return null;
        }
        catch (SQLException ex) {
            this.log(sm.getString("jdbcRealm.getCredentialsSQLException", (Object)username), ex);
            this.close();
            return null;
        }
    }

    protected PreparedStatement getPreparedAuthenticate(Connection conn) throws SQLException {
        String sql = "SELECT " + this.userCredCol + " FROM " + this.userTable + " WHERE " + this.userNameCol + " = ?";
        if (this.debug >= 1) {
            this.log("JDBCRealm.authenticate: " + sql);
        }
        return conn.prepareStatement(sql);
    }

    protected PreparedStatement getPreparedRoles(Connection conn) throws SQLException {
        String sql = "SELECT " + this.roleNameCol + " FROM " + this.userRoleTable + " WHERE " + this.userNameCol + " = ?";
        if (this.debug >= 1) {
            this.log("JDBCRealm.roles: " + sql);
        }
        return conn.prepareStatement(sql);
    }

    private boolean checkConnection() {
        try {
            if (this.dbConnection == null || this.dbConnection.isClosed()) {
                Class.forName(this.driverName);
                if (this.JDBCStarted) {
                    this.log(sm.getString("jdbcRealm.checkConnectionDBClosed"));
                }
                this.dbConnection = this.connectionName == null || this.connectionName.equals("") || this.connectionPassword == null || this.connectionPassword.equals("") ? DriverManager.getConnection(this.connectionURL) : DriverManager.getConnection(this.connectionURL, this.connectionName, this.connectionPassword);
                this.JDBCStarted = true;
                if (this.dbConnection == null || this.dbConnection.isClosed()) {
                    this.log(sm.getString("jdbcRealm.checkConnectionDBReOpenFail"));
                    return false;
                }
            }
            return true;
        }
        catch (SQLException ex) {
            this.log(sm.getString("jdbcRealm.checkConnectionSQLException"), ex);
            this.close();
            return false;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("JDBCRealm.checkConnection: " + ex);
        }
    }

    public synchronized String[] getUserRoles(String username) {
        try {
            if (!this.checkConnection()) {
                return null;
            }
            if (this.preparedRoles == null) {
                this.preparedRoles = this.getPreparedRoles(this.dbConnection);
            }
            this.preparedRoles.clearParameters();
            this.preparedRoles.setString(1, username);
            ResultSet rs = this.preparedRoles.executeQuery();
            Vector<String> vrol = new Vector<String>();
            while (rs.next()) {
                vrol.addElement(rs.getString(1).trim());
            }
            String[] res = new String[vrol.size() > 0 ? vrol.size() : 1];
            if (vrol.size() == 0) {
                res[0] = "";
                return res;
            }
            for (int i = 0; i < vrol.size(); ++i) {
                res[i] = (String)vrol.elementAt(i);
            }
            return res;
        }
        catch (SQLException ex) {
            this.log(sm.getString("jdbcRealm.getUserRolesSQLException", (Object)username));
            this.close();
            return null;
        }
    }

    private void close() {
        if (this.preparedRoles != null) {
            try {
                this.preparedRoles.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.preparedRoles = null;
        }
        if (this.preparedAuthenticate != null) {
            try {
                this.preparedAuthenticate.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.preparedAuthenticate = null;
        }
        if (this.dbConnection != null) {
            try {
                this.dbConnection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.dbConnection = null;
        }
    }

    public void contextShutdown(Context ctx) throws TomcatException {
        if (this.started && this.JDBCStarted) {
            this.close();
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        if (!this.started) {
            if (this.connectOnInit && !this.checkConnection()) {
                throw new RuntimeException("JDBCRealm cannot be started");
            }
            this.started = true;
        }
    }

    protected Principal getPrincipal(String username) {
        return new JdbcPrincipal(username);
    }

    public static class JdbcPrincipal
    extends SimplePrincipal {
        private String name;

        JdbcPrincipal(String name) {
            super(name);
        }
    }
}

