/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.aaa;

import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;

class FormAuthHandler
extends Handler {
    FormAuthHandler() {
        this.name = "tomcat.formAuthHandler";
    }

    public void doService(Request req, Response res) throws Exception {
        boolean noSession;
        Context ctx = req.getContext();
        ServerSession session = req.getSession(false);
        boolean bl = noSession = session == null;
        if (this.debug > 0) {
            this.log("Form handler called with no session ");
        }
        String page = ctx.getFormLoginPage();
        String errorPage = ctx.getFormErrorPage();
        session = req.getSession(true);
        String username = (String)session.getAttribute("j_username");
        if (this.debug > 0) {
            this.log("Username = " + username);
        }
        String originalLocation = req.requestURI().toString();
        if (noSession || "url".equals(req.getSessionIdSource())) {
            String id = ";jsessionid=" + req.getSessionId();
            originalLocation = originalLocation + id;
            page = page + id;
        }
        if (req.queryString().toString() != null && !req.queryString().toString().equals("")) {
            originalLocation = originalLocation + "?" + req.queryString().toString();
        }
        session.setAttribute("tomcat.auth.originalLocation", (Object)originalLocation);
        if (username != null) {
            session.removeAttribute("j_username");
            session.removeAttribute("j_password");
            req.setAttribute("javax.servlet.error.message", (Object)errorPage);
            if (this.debug > 0) {
                this.log("Redirecting to " + errorPage);
            }
            this.contextM.handleStatus(req, res, 302);
            return;
        }
        if (this.debug > 0) {
            this.log("Redirect1: " + page + " originalUri=" + originalLocation);
        }
        req.setAttribute("javax.servlet.error.message", (Object)page);
        this.contextM.handleStatus(req, res, 302);
    }
}

